/*ScianSnap.c
  Eric Pepke
  14 January 1993

  Routines for variable snapshots in SciAn
*/

#include "Scian.h"
#include "ScianTypes.h"
#include "ScianIDs.h"
#include "ScianLists.h"
#include "ScianErrors.h"
#include "ScianSnap.h"
#include "ScianWindows.h"
#include "ScianObjWindows.h"

ObjPtr snapshotClass;			/*Class for all snapshots*/

#ifdef PROTO
ObjPtr TakeSnapshot(ObjPtr object)
#else
ObjPtr TakeSnapshot(object)
ObjPtr object;
#endif
/*Takes a snapshot of object*/
{
    ObjPtr list;
    ObjPtr retVal;

    retVal = NewObject(snapshotClass, 0L);
    SetVar(retVal, REPOBJ, object);
    list = GetVar(object, SNAPVARS);
    if (list)
    {
	ThingListPtr runner;

	runner = LISTOF(list);
	while (runner)
	{
	    NameTyp id;

	    id = GetSymbolID(runner -> thing);
	    if (id)
	    {
		SetVar(retVal, id, GetVar(object, id));
	    }
	    runner = runner -> next;
	}
    }
    return retVal;
}

#ifdef PROTO
void ApplySnapshot(ObjPtr snapshot)
#else
void ApplySnapshot(snapshot)
ObjPtr snapshot;
#endif
/*Applies snapshot to its object*/
{
    ObjPtr list;
    ObjPtr object;

    object = GetVar(snapshot, REPOBJ);
    list = GetVar(object, SNAPVARS);

    if (list && object)
    {
	ThingListPtr runner;
	ObjPtr value;

	runner = LISTOF(list);
	while (runner)
	{
	    NameTyp id;

	    id = GetSymbolID(runner -> thing);
	    if (id)
	    {
		if (id == VALUE)
		{
		    value = GetVar(snapshot, VALUE);
		    SetValue(object, value);
		}
		else
		{
		    SetVar(object, id, GetVar(snapshot, id));
		}
	    }
	    runner = runner -> next;
	}
	ImInvalid(object);
    }
}

void InitSnapshots()
/*Initializes snapshot system*/
{
    snapshotClass = NewObject(NULLOBJ, 0L);
    AddToReferenceList(snapshotClass);
}

void KillSnapshots()
/*Kills the snapshot system*/
{
    RemoveFromReferenceList(snapshotClass);
}