%***************************************************************************
%  FILE = indexed.red 				Thu Nov 10 16:35:38 EST 1988
% 
%  Procedures in this file:
%  
%  MKTNSR MKTNSR* MKSCALAR MKCONJ IFMTSYM CHKSYM CHKSYM1 
%  CHKINDEX INDEXLIM INDEXED ISITTEN ISITFR ISITSP CONJRDR
%  READTNSR WRITETNSR FNDCMP CV* PROTECT PROTECT* ISPROTECT
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************

REMPROP ('INDEX, 'STAT);
GLOBAL '(INAMES INDICETEN INDICESP INDICEMAT);
FLUID '(COORDS);
FLAG ('(MKTNSR), 'OPFN);  % make it directly callable 

% mktnsr is the user level routine that accepts information about the
% structure of an indexed object that is to be created (by mktnsr*)
% mktnsr returns an indexed form to show exactly what was created.

SYMBOLIC FEXPR PROCEDURE MKTNSR (U);
BEGIN SCALAR LEX;
  U := MAPCAR (U, 'EVAL);  % note its a fexpr, so eval the args.
  LEX := MKTNSR!* (MYCAR (U), MYCADR (U), IFMTSYM (MYCADDR (U)), MYCADDDR (U),
          MYCADDDR (MYCDR (U)));   % have mktnsr* make the thing
  IF LEX AND MYCADR (U) THEN <<  % if there was a concov, then print it nicely.
   TERPRI ();
    MAPRINT (LIST ('RDR, LEX, MAPCAR (ZPN (97, 
          96 + LENGTH (MYCADR (U)), 1), 'MASCII)), 0);
    TERPRI!* ('T);
    RETURN ('NIL)              % but theres no return value.
  >> ELSE RETURN (LEX);        % if its lacking a concov, return the name.
END;

% mktnsr* is the primitive routine which builds the structure for
% an indexed object. it returns the name of the object.
% the concov list describes the index structure:
% 1 -- tensor
% 2 -- tetrad
% 3 -- unprimed spinor
% 4 -- primed spinor
% 5 -- matrix
% positive values are contravariant, negative are covariant.

SYMBOLIC PROCEDURE MKTNSR!* (TNSR, CONCOV, SYM, IMP, TYPE);
BEGIN SCALAR LEX;
  TNSR := GETNME (TNSR, 'MKTNSR!*);
  IF INDEXED (TNSR) AND NOT KILL (TNSR) OR FLAGP (TNSR, 'RESERVED) THEN << 
    MERROR (LIST ("cannot create object:", TNSR), 'NIL, 'MKTNSR); 
    RETURN ('NIL)
  >>;
  SETPROP (TNSR, 'NIL);   % kill everything about this object
  PUT (TNSR, 'SIMPFN, 'MKRDR);	% simplification function
  FLAG (LIST (TNSR), 'FULL);	% causes name to be passed to mkrdr too.
  SET (TNSR, TNSR);		% so we can use unquoted name.
  SYM := CHKSYM (SYM, CONCOV);
  PUT (TNSR, 'SYMMETRY, SYM);
  IF ATOM (CONCOV) THEN  RETURN (TNSR); % just a declaration, nothing else done

  IF COORDS AND NOT LENGTH (COORDS) = (MYCADR (INDICETEN) -
          MYCAR (INDICETEN) + 1) THEN
     MERROR (LIST ("coord-indice mis-match:", COORDS, ",", INDICETEN),
               'NIL, 'NIL);
  PUT (TNSR, 'INDICES, INDEXLIM (CONCOV));  % place other properties
  PUT (TNSR, 'CONCOV, CONCOV);
  PUT (TNSR, 'COORDS, COORDS);
  PUT (TNSR, 'MULTIPLIER, 1 . 1);
  PUT (TNSR, 'TYPE, TYPE);
  PUT (TNSR, 'PNAME, TNSR);
  FLAG (LIST (TNSR), 'RESERVED);

  IF IMP AND (NOT ATOM (IMP) OR (NOT FIXP (IMP) AND NOT IMP EQ TNSR
     AND (NOT INDEXED (IMP) OR NOT (GET (IMP, 'CONCOV) = CONCOV)))) THEN
    MERROR (LIST ("bad IMPLICIT value:", IMP, TNSR), 'NIL, 'MKTNSR!*)
  ELSE <<
    PUT (TNSR, 'IMPLICIT, IMP);
    IF (IMP EQ TNSR) THEN  % is implicit and must depend on coords
      FOR EACH X IN COORDS DO DEPEND1 (TNSR, X, 'T)
  >>;  
  CONCOV := MAP43 (MAPCAR (CONCOV, 'ABS));
  LEX := MYCAR (CONCOV);
  CONCOV := MYCDR (CONCOV);    % find out what to place under 'indexed prop
  IF CONCOV AND MEMQ ('NIL, FOR EACH X IN CONCOV COLLECT (X EQ LEX))
    THEN LEX := 'MIXED
  ELSE IF LEX = 1 THEN LEX := 'TENSOR
  ELSE IF LEX = 2 THEN LEX := 'FRAME
  ELSE IF LEX = 3 OR LEX = 4 THEN LEX := 'SPINOR
  ELSE IF LEX = 5 THEN LEX := 'MATRIX;

  PUT (TNSR, 'INDEXED, LEX);
  IF ISITSP (TNSR) THEN MKCONJ (TNSR);  % if it's a spinor, make its conjugate
  INAMES := TNSR . INAMES;		% add this object to the list
  PUT (TNSR, 'TVALUE, 'NIL);		% and give a nil value
  RETURN (TNSR);
END;

PUT ('MKSCALAR, 'SIMPFN, 'MKSCALAR!*);  % prevents evaluation.

% mkscalar is analogous to mktnsr, except that scalar objects are
% declared. this allows their use with derivative indices, e.g.
% mkscalar(p);
% p[|a]   etc.
% note vars and mode are passed by the system, but ignored here.

SYMBOLIC PROCEDURE MKSCALAR!* (SCL);
BEGIN;
  SCL:= GETNME (MYCAR (SCL), 'MKSCALAR);
  IF INDEXED (SCL) AND NOT KILL (SCL) THEN RETURN;
  PUT (SCL, 'SIMPFN, 'MKRDR);
  FLAG (LIST (SCL), 'FULL);
  PUT (SCL, 'INDEXED, 'SCALAR);	% make it scalar
  PUT (SCL, 'INDICES, '(0));
  INAMES := SCL . INAMES;
  %
  %  If this is a real scalar variable, we want to copy the value to the
  %  proper location (ie the TVALUE) for it to be a scalar object.
  %
  IF (GET (SCL, 'AVALUE)) THEN <<
     PUT (SCL, 'TVALUE, SIMPCAR (GET (SCL, 'AVALUE)));   % move the value
     REMPROP (SCL, 'AVALUE)
  >>;
  RETURN (SIMP (SCL));
END;
 
% mkconj is called by mktnsr* to generate a conjugate object for a spinor.
% the conjugate is only really a header with the required index
% structure, and a flag so printrdr can put a bar over the name. it never
% has a 'tvalue, since its elements are obtained by conjugating the elements
% of the parent spinor.

SYMBOLIC PROCEDURE MKCONJ (TNSR);
BEGIN SCALAR LEX, TNSR1, CONCOV;
  CONCOV := GET (TNSR, 'CONCOV);
  TNSR1 := MAKENAME (APPEND (EXPLODE (TNSR), '(!# C N J))); % name of conjugate
  IF INDEXED (TNSR1) AND NOT KILL (TNSR1) THEN
    MERROR (LIST ("cannot create conjugate: ", TNSR1), 'T, 'MKCONJ);
  WHILE CONCOV DO <<	% primed indices become unprimed, and vice-versa.
    IF MYCAR (CONCOV) = 3 THEN LEX := 4 . LEX 
    ELSE IF MYCAR (CONCOV) = 4 THEN LEX := 3 . LEX
    ELSE IF MYCAR (CONCOV) = -3 THEN LEX := (-4) . LEX 
    ELSE IF MYCAR (CONCOV) = -4 THEN LEX := (-3) . LEX
    ELSE LEX := MYCAR (CONCOV) . LEX;
    CONCOV := MYCDR (CONCOV)
  >>;
  SET (TNSR1, TNSR1);
  PUT (TNSR1, 'SIMPFN, 'MKRDR);	% add all the properties needed
  FLAG (LIST (TNSR1), 'FULL);
  PUT (TNSR1, 'SYMMETRY, GET (TNSR, 'SYMMETRY));
  PUT (TNSR1, 'CONCOV, REVERSE (LEX));
  PUT (TNSR1, 'COORDS, COORDS);
  PUT (TNSR1, 'MULTIPLIER, 1 . 1);
  PUT (TNSR1, 'TYPE, GET (TNSR, 'TYPE));
  PUT (TNSR1, 'INDICES, GET (TNSR, 'INDICES));
  PUT (TNSR1, 'PNAME, TNSR);
  FLAG (LIST (TNSR1), 'RESERVED);
  PUT (TNSR1, 'INDEXED, GET (TNSR, 'INDEXED));
  PUT (TNSR, 'CONJUGATE, TNSR1 . 'NIL);
  PUT (TNSR1, 'CONJUGATE, TNSR . 'T);
  FLAG (LIST (TNSR1), 'NODIR);	% so directories don't get too cluttered.
  INAMES := TNSR1 . INAMES;
END;

% ifmtsym takes the symmetry list as typed at the user level (i.e to
% mktnsr) and translates it into the internal format used.
% mappings are thus:
% ((b p1 p2 ..) --> (((b) p1 p2 ..)
% ((c b p1 p2 ..) --> ((b . t) p1 p2 ..)
% ((h p1 p2)) --> ((h p1 p2))     (i.e no change)
%  where b is a block size with sign, and p1, p2, .. are pointers.
% c and h are literal characters indicating conjugate and hermitian
% repectively.

SYMBOLIC PROCEDURE IFMTSYM (SYMLST);
BEGIN SCALAR LEX;
  IF ATOM (SYMLST) THEN RETURN ('NIL);
  LEX:= FOR EACH X IN MYCAR (SYMLST) COLLECT   % raise case of key-letters
    (IF IDP (X) THEN UPCASE (X) ELSE X);
  IF MYCAR (LEX) EQ 'C THEN   % conjugate symmetry
    RETURN ((MYCADR (LEX) . 'T) . MYCDDR (LEX)) . 
                        IFMTSYM (MYCDR (SYMLST))
  ELSE IF MYCAR (LEX) EQ 'H THEN   % hermitian symmetry
    RETURN LEX . IFMTSYM (MYCDR (SYMLST))
  ELSE
    RETURN ((MYCAR (LEX) . 'NIL) . MYCDR (LEX)) . IFMTSYM (MYCDR (SYMLST));
END;

% chksym checks the symmetry list (in internal format) for consistency,
% and returns the list. If a hermitian symmetry has been requested, 
% chksym either builds it, or checks it itself; otherwise chksym1 is
% used to do the work.

SYMBOLIC PROCEDURE CHKSYM (SYMLST, CONCOV);
BEGIN SCALAR LASTBLCK, LEX, LEX1, LEX2, LEX3, FLG, L, SP1, OSYM;
  OSYM := SYMLST;	% copy the symmetry list
  LASTBLCK := 0; 	% last seen block size init to 0
  WHILE NOT ATOM (MYCAAR (SYMLST)) DO <<    % run until hermitian or nothing
    IF SYMSZE (SYMLST) < LASTBLCK THEN    % block sizes aren't getting bigger!
      MERROR (LIST ("invalid symmetry:", OSYM), 'T, 'CHKSYM);
    LASTBLCK := SYMSZE (SYMLST);
    CHKSYM1 (MYCAR (SYMLST), CONCOV);       % check each indep symmetry.
    SYMLST := MYCDR (SYMLST)
  >>;
  IF SYMLST THEN << 			  % hermitian symmetry too
    IF NOT (LEX1 := MYCDAR (SYMLST)) THEN BEGIN
      FLG := 'T;    			  % we are making the pointers
      L := LENGTH (LEX2 := CONCOV);
      LOOP:				  % look for first spinor index
        IF MEMQ ((SP1 := MYCAR (LEX2)), '(3 -3 4 -4)) THEN GO AFTERLOOP
        ELSE IF NOT LEX2 THEN GO AFTERLOOP1;
        LEX2 := MYCDR (LEX2);
        GO LOOP;
      AFTERLOOP:
      LEX2 := MYCDR (LEX2);
      LEX1 := (L - (L := LENGTH (LEX2))) . LEX1;
      LOOP1:          % find each succeding occurance of that first indice.
        LEX2 := MYCDR (MEMQ (SP1, LEX2));
        IF NOT LEX2 THEN GO AFTERLOOP1;
        LEX1 := (MYCAR (LEX1) + L - (L := LENGTH (LEX2))) . LEX1; % add pointer
      GO LOOP1;
      AFTERLOOP1:
      LEX1 := REVERSE (LEX1)
    END;
    LEX2 := LEX1;			% if the sublists of the concov aren't
    SP1 := SUBLIST (CONCOV, MYCAR (LEX2) OR 0, 2);  % the same, its not right.
    IF NOT (ABS (MYCAR (SP1) + MYCADR (SP1)) = 7) THEN  
      MERROR (LIST ("improper blocks for hermitian symmetry:",
                    OSYM), 'T, 'CHKSYM);
    LEX2 := MYCDR (LEX2);
    WHILE LEX2 DO <<
      IF NOT SUBLIST (CONCOV, MYCAR (LEX2), 2) = SP1 THEN
        IF FLG THEN
          MERROR (LIST ("improper structure for hermitian symmetry:", 
                        OSYM), 'T, 'CHKSYM)
        ELSE
          MERROR (LIST ("invalid pointers for hermitian symmetry:",
                        OSYM), 'T, 'CHKSYM);
      LEX2 := MYCDR (LEX2)
    >>;
    IF NOT MYCDR (LEX1) THEN     % if only one pointer, make it conjugate instead
      LEX1 := LIST ('(1 . T), MYCAR (LEX1), MYCAR (LEX1) + 1)
    ELSE LEX1 := 'H . LEX1;
    OSYM := REVERSE (LEX1 . MYCDR (REVERSE (OSYM)))
  >>;
  RETURN (OSYM);
END;

% chksym1 checks each independent symmetry for internal consistency.
% if the symmetry passes, chksym1 returns, otherwise it errs out and
% never goes back to chksym.

SYMBOLIC PROCEDURE CHKSYM1 (SYM, CONCOV);
BEGIN SCALAR LEX, LEX1, LIS, LEN;
  LEX := SYM;
  LEN := MAX (ABS (MYCAAR (LEX)), 1);  % size of block, 1 if its diagonal
  LEX := MYCDR (LEX);		     % list of pointers.
  IF NOT FIXP (LEN) THEN
     MERROR (LIST ("bad block size: ", MYCAR (SYM), ",", SYM), 'TRUE, 'CHKSYM)
  ELSE IF LENGTH (LEX) < 2 THEN
     MERROR (LIST ("too few pointers:", SYM), 'TRUE, 'CHKSYM);
  LIS := SUBLIST (CONCOV, MYCAR (LEX), LEN);
  LOOP:
    IF NOT MYCADR (LEX) THEN RETURN ()
    ELSE IF NOT FIXP (MYCAR (LEX)) THEN
      MERROR (LIST ("bad pointer:", MYCAR (LEX), ",", SYM), 'TRUE, 'CHKSYM)
    ELSE IF MYCAR (LEX) < 0 THEN
      MERROR (LIST ("bad pointer:", MYCAR (LEX), ",", SYM), 'TRUE, 'CHKSYM)
    ELSE IF MYCAR (LEX) > MYCADR (LEX) THEN
      MERROR (LIST ("pointer out of order:", SYM), 'TRUE, 'CHKSYM)
    ELSE IF (MYCAR (LEX) + LEN) > MYCADR (LEX) THEN
      MERROR (LIST ("overlapping blocks:", SYM), 'TRUE, 'CHKSYM);
%   ELSE IF NOT LIS = (SUBLIST (CONCOV, MYCADR (LEX), LEN) OR LIS) AND
%        NOT MYCAR (SYM) = 0 THEN
%      MERROR (LIST ("improper symmetry:", SYM), 'TRUE, 'CHKSYM);
    LEX := MYCDR (LEX);
    IF CONCOV AND ((MYCAR (LEX) + LEN) > (LENGTH (CONCOV) + 1)) THEN
      MERROR (LIST ("symmetry too long:", SYM), 'TRUE, 'CHKSYM);
    GO TO LOOP;
END;

% chkindex determines whether the integers in an index are in
% the range described by the 'indices property of the object.
% it returns 't or 'nil depending on what it finds.

SYMBOLIC PROCEDURE CHKINDEX (TNSR, INDEX);
BEGIN SCALAR LEX, LEX1, LEX2;
  LEX2 := GET (TNSR, 'INDICES);
  LEX := MYCADR (LEX2);     % upper bound
  LEX1 := MYCADDR (LEX2);   % lower bound
  LEX2 := INDEX;
  LOOP:
    IF (NOT INDEX) OR (NOT LEX) THEN RETURN ('T);  % got all the way through
    IF FIXP (MYCAR (INDEX)) AND (MYCAR (LEX) > MYCAR (INDEX) OR
            MYCAR (INDEX) > MYCAR (LEX1)) THEN     % number out of range
        RETURN ('NIL);
    INDEX := MYCDR (INDEX);
    LEX := MYCDR (LEX);
    LEX1 := MYCDR (LEX1);
    GO TO LOOP;
END;

% indexlim creates the 'indices property of an indexed object.
% it returns a list of the form (rank (lower-bound) (upper-bound)).
% rank is obvious; the bounds are created by placing the appropriate 
% index runs in each list.

SYMBOLIC PROCEDURE INDEXLIM (CONCOV);
BEGIN SCALAR LEX, LEX1, N, LEX2;
  N := LENGTH (CONCOV);    	% this is the rank
  WHILE CONCOV DO <<
    LEX2 := GETINDICES (MYCAR (CONCOV));   % index run for this slot.
    CONCOV := MYCDR (CONCOV);
    LEX := MYCAR (LEX2) . LEX;
    LEX1 := MYCADR (LEX2) . LEX1
  >>;
  RETURN (LIST (N, REVERSE (LEX), REVERSE (LEX1)));
END;

FLAG ('(INDEXED), 'OPFN);   % user and lisp callable

SYMBOLIC PROCEDURE INDEXED (EX1); % determines if an object is indexed.
  GET (EX1, 'INDEXED);

% note: isitten, isitfr and isitsp probably should be combined into a single
% function with a second arg.

% isitten determines if the given object has any tensor indices

SYMBOLIC PROCEDURE ISITTEN (TNSR);
  MEMQ (1, GET (TNSR, 'CONCOV)) OR MEMQ (-1, GET (TNSR, 'CONCOV));

% isitfr determines if the given object has any tensor indices

SYMBOLIC PROCEDURE ISITFR (TNSR);
  MEMQ (2, GET (TNSR, 'CONCOV)) OR MEMQ (-2, GET (TNSR, 'CONCOV));

% isitsp determines if the given object has any spinor indices.

SYMBOLIC PROCEDURE ISITSP (TNSR);
  MEMQ (3, GET (TNSR, 'CONCOV)) OR MEMQ (4, GET (TNSR, 'CONCOV)) OR
  MEMQ (-3, GET (TNSR, 'CONCOV)) OR MEMQ (-4, GET (TNSR, 'CONCOV));

PUT ('RDR, 'CONJFN, 'CONJRDR);
PUT ('QRDR, 'CONJFN, 'CONJRDR);

% conjrdr determines the conjugate object for a spinor by looking
% for the conjugate property.

SYMBOLIC PROCEDURE CONJRDR (U);
BEGIN SCALAR LEX, LEX1, TNSR;
  IF (LEX := MYCAR (GET (TNSR := MYCADR (U), 'CONJUGATE))) THEN <<
    IF NOT INDEXED (LEX) THEN <<  % some dummy rem'ed it, make it again.
      MERROR (LIST ("missing conjugate for", TNSR, 
         "being created."), 'NIL, 'NIL);
      MKCONJ (TNSR)
    >>;
    LEX1 := (LIST (MYCAR (U), LEX, MYCADDR (U), MYCADDDR (U)));
    RETURN (LEX1)
  >>
  ELSE RETURN (LIST ('CONJ, U));
END;

GLOBAL '(!*XEVAL);
!*XEVAL := 'NIL;       % flag for extra simplification in readtnsr

% readtnsr is the primitive routine which reads indexed object values.
% it accesses the assoc list which is the object tvalue, and returns 
% the result.

SYMBOLIC PROCEDURE READTNSR (TNSR, INDEX);
BEGIN SCALAR INDX, POS, TENSOR, LEX, MULTIPLIER, VAL;
  IF NOT INDEX THEN RETURN (GET (TNSR, 'TVALUE) OR !*K2Q (TNSR));
  IF MYCDR (LEX := GET (TNSR, 'CONJUGATE)) THEN
    RETURN (CONJSQ (READTNSR (MYCAR (LEX), INDEX)));  % we always read the parent 
% and return the conjugate of that value. conjugate objects never have 'tvalues.
  TENSOR := GET (TNSR, 'TVALUE);  	% this is the assoc list of values.

  INDX := SYM (INDEX, GET (TNSR, 'SYMMETRY)); % apply syymetry to index
  IF MYCADR (INDX) = 0 THEN RETURN ('NIL . 1);   % sym sez 0
  MULTIPLIER := MULTSQ (GET (TNSR, 'MULTIPLIER), MYCADR (INDX) . 1);
  POS := ASSOC (MYCAR (INDX), TENSOR);    % get the value

  IF POS THEN <<
    IF MULTIPLIER = '(1 . 1) THEN
      VAL := MYCDR (POS)
    ELSE IF MULTIPLIER = '(-1 . 1) THEN
      VAL := NEGSQ (MYCDR (POS))
    ELSE
      VAL := MULTSQ (MULTIPLIER, MYCDR (POS));
    IF !*XEVAL THEN RETURN (CV!* (SIMP!* (LIST ('!*SQ, 
          VAL, 'NIL)), MYCADDR (INDX)))
    ELSE RETURN (CV!* (VAL, MYCADDR (INDX)))
  >>
  ELSE IF NOT (LEX := GET (TNSR, 'IMPLICIT)) THEN RETURN ('NIL . 1)
  ELSE IF FIXP (LEX) THEN RETURN (MULTSQ (MULTIPLIER, (LEX . 1)));
  MULTIPLIER := MYCADR (INDX) . 1;
  IF LEX NEQ TNSR THEN 
    RETURN (CV!* (MULTSQ (MULTIPLIER,
               SIMP (LIST ('RDR, LEX, MYCAR (INDX)))), MYCADDR (INDX)))
  ELSE RETURN (CV!* (MULTSQ (MULTIPLIER,
               SIMP (LIST ('QRDR, LEX, MYCAR (INDX)))), MYCADDR (INDX)));
END;

% writetnsr is the primitive routine which writes values into an
% indexed object. it returns the value written (not necessarily the
% value input). if flg is on, then the index will not be sym'ed (i.e
% its already in canonical form).

SYMBOLIC PROCEDURE WRITETNSR (TNSR, INDEX, VALUE, FLG);
BEGIN SCALAR POS, INDX, TENSOR, VAL, LEX;
  IF NOT INDEX THEN <<
     PUT (TNSR, 'TVALUE, NOT (REVAL (MK!*SQ (VALUE)) EQ TNSR) AND VALUE);
     RETURN (VALUE)
  >>;
% conjugate objects don't have values, we write the conjugate value
% to the parent object.
   
  IF MYCDR (LEX := GET (TNSR, 'CONJUGATE)) THEN
    RETURN (WRITETNSR (MYCAR (LEX), INDEX, CONJSQ (VALUE), FLG));

  IF ISPROTECT (TNSR, 2) THEN <<
    MERROR (LIST (TNSR, "is write-protected"), 'NIL, 'WRITETNSR);
    RETURN ('NIL)
  >>;
  TENSOR := GET (TNSR, 'TVALUE);  % value list

  IF FLG THEN INDX := LIST (INDEX, 1)  % apply symmetries.
  ELSE INDX := SYM (INDEX, GET (TNSR, 'SYMMETRY));
  IF MYCADR (INDX) = 0 THEN RETURN ('NIL . 1);  % sym sez 0
  POS := FNDCMP (TENSOR, MYCAR (INDX));
  VAL := CV!* (QUOTSQ (MULTSQ (MYCADR (INDX) . 1, VALUE), 
     GET (TNSR, 'MULTIPLIER)), MYCADDR (INDX));
  IF MYCADR (POS) THEN <<
    IF NOT VAL AND NOT GET (TNSR, 'IMPLICIT) THEN
      PUT (TNSR, 'TVALUE, INSERT (TENSOR, 'NIL, MYCAR (POS), 'T))
    ELSE
      PUT (TNSR, 'TVALUE, INSERT (TENSOR, MYCAR (INDX) . VAL, MYCAR (POS), 'T));
    RETURN (VAL)
    >>
  ELSE IF NOT MYCAR (VAL) AND NOT GET (TNSR, 'IMPLICIT) THEN
    RETURN ('NIL)
  ELSE IF NOT TENSOR THEN <<
    PUT (TNSR, 'TVALUE, LIST (MYCAR (INDX) . VAL ));
    RETURN (VAL)
  >>
  ELSE IF MYCAR (POS) > LENGTH (TENSOR) THEN <<
    PUT (TNSR, 'TVALUE, APPEND (TENSOR, LIST (MYCAR (INDX) . VAL)));
    RETURN (VAL)
  >> ELSE <<
    PUT (TNSR, 'TVALUE, INSERT (TENSOR, MYCAR (INDX) . VAL, MYCAR (POS), 'NIL));
    RETURN (VAL)
  >>;
END;

% fndcmp (FiND CoMPonent) is called by writetnsr to locate the
% position where an element is to be placed in the value list of
% an object. it returns a list of the form (pos, flg) where
% flg indicates if the element already exists (and thus should be
% overwritten), and pos is the location of that element, or the location
% of the element that will preceed the one we are writing.

SYMBOLIC PROCEDURE FNDCMP (TNSR, INDEX);
BEGIN SCALAR KNT;
  KNT := 1;     % position counter
  LOOP:
    IF (NOT TNSR) THEN RETURN (LIST (KNT, 'NIL))  % ran off end, append.
    ELSE IF INDEX = MYCAAR (TNSR) THEN RETURN (LIST (KNT, 'T)) % is there
    ELSE IF ORDERINDEX (INDEX, MYCAAR (TNSR)) THEN  % isnt there
        RETURN (LIST (KNT, 'NIL));
    KNT := KNT + 1;
    TNSR := MYCDR (TNSR);
  GO TO LOOP;
END;

% cv* either returns a conjugate value or just the value, depending on the
% flag.

SYMBOLIC PROCEDURE CV!* (VALUE, FLG);
  IF FLG THEN CONJSQ (VALUE)
  ELSE VALUE;

PUT ('PROTECT, 'FORMFN, 'PROTECT);  % somehow prevents evaluations

% protect is the user interface for protect* 

SYMBOLIC PROCEDURE PROTECT (LIST, VARS, MODE);
  PROTECT!* (MYCAR (LIST), MYCADR (LIST));

% protect* places and removes protection flags from indexed objects.

SYMBOLIC PROCEDURE PROTECT!* (TNSR, KEY);
BEGIN;
  TNSR := GETNME (REVAL (TNSR), 'PROTECT);
  IF NOT INDEXED (TNSR) THEN RETURN (NIL);
  IF KEY EQ 'W OR KEY EQ 'w THEN KEY := 2
  ELSE IF KEY EQ 'K OR KEY EQ 'k THEN KEY := 3
  ELSE IF KEY EQ 'KW OR KEY EQ 'WK OR KEY EQ 'kw OR KEY EQ 'wk THEN KEY := 6
  ELSE IF KEY THEN KEY := GET (TNSR, 'PROTECTION)
  ELSE KEY := 'NIL;
  PUT (TNSR, 'PROTECTION, KEY);
  RETURN (TNSR);
END;

% isprotect checks for a particular type of protection on an object.
% values for N mean:
% 2 -- write protected
% 3 -- kill protected
% 6 -- write and kill protected
% see protect*

SYMBOLIC PROCEDURE ISPROTECT (TNSR, N);
  REMAINDER (GET(GETNME (TNSR, 'ISPROTECT), 'PROTECTION) OR 5, N) = 0;

;END;
