%******************************************************************************
%  FILE = igen.red				Sun May 17 20:07:37 EDT 1987
% 
%  Procedures in this file:
%  
%  IGEN IGENN IGEN1 DOSYM NOSYM DOHERM GENIND GENIND1 GENIND2 
%  CHECK MERGER MERGEL
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************
REMPROP ('INDEX, 'STAT);

FLUID ('(EX1 INDEXOUT SYMM ASSOC!* INDEX CONCOV));

% igen generates a list of ordered indices for the given index, concov list
% and symmetry.

SYMBOLIC PROCEDURE IGEN (INDEX, CONCOV, SYM);
BEGIN SCALAR INDEXOUT;
  IF (NOT INDEX) OR (NOT CONCOV) THEN RETURN ('NIL);

  RETURN (CATCH ('ZERO, <<
    INDEXOUT := IGENN (INDEX, CONCOV);
    WHILE (NOT ATOM (MYCAAR (SYM))) DO <<	% do up to end or hermitian sym.
      DOSYM (MYCDAR (SYM), MYCAAAR (SYM));	% apply each symmetry
      SYM := MYCDR (SYM)
    >>;
    IF MYCAR (SYM) THEN DOHERM (MYCADR (NOSYM (1, LENGTH (INDEX))), 
         MYCDAR (SYM))		% apply hermitian symmetry.
    ELSE MYCADR (NOSYM (1, LENGTH (INDEX)))
  >>));
END;

% igenn generates all the possible index values for each element of the
% index according to the value of the corresponding concov element.
% it returns a list whose elements have the form: ((loc)((i1)(i2)..))
% where (loc) is a list of the pointer to the position in the index,
% and the (i)'s are lists of each possible value.

SYMBOLIC PROCEDURE IGENN (INDEX, CONCOV);
BEGIN SCALAR LIS, LEX, LEX1, LEX2, I;
  I := 1;
  WHILE INDEX DO <<		% for each element of the index
    LEX := MYCAR (INDEX);
    INDEX := MYCDR (INDEX);
    LEX2 := GETINDICES (MYCAR (CONCOV));	% index run for this element.
    CONCOV := MYCDR (CONCOV);		% corresponding concov element.
    LEX1 := MYCAR (LEX2);			% lower run limit
    LEX2 := MYCADR (LEX2);		% upper run limit
    IF FIXP (LEX) THEN <<		% indice is an int, if its out of
      IF LEX < LEX1 OR LEX > LEX2 THEN THROW ('ZERO, 'NIL)  % range we leave.
      ELSE LIS := LIST (LIST (I), LIST (LIST (LEX))) . LIS
      >>
   ELSE				% arbitrary indice, generate possible values.
     LIS := (LIST (I) . IGEN1 (MAX (GET (LEX, 'LL) OR LEX1, LEX1),
                          MIN (GET (LEX, 'UL) OR LEX2, LEX2))) . LIS;
   I := I + 1			% position counter
   >>;
   RETURN (REVERSE (LIS));
END;

% igen1 is called from igenn to generate the list of (lists of) possible
% values for each indice. inputs are the lower and upper bounds to the
% indice run. the reason the values are in lists is so they can be appended
% together to form an index.

SYMBOLIC PROCEDURE IGEN1 (N, M);
BEGIN SCALAR LIS;
  WHILE NOT (N > M) DO <<
    LIS := LIST (N) . LIS;
    N := N + 1
  >>;
  RETURN (LIST (REVERSE (LIS)));
END;

% dosym applies each independent symmetry in building the output list of
% indices.

SYMBOLIC PROCEDURE DOSYM (POINT, SYMM);
BEGIN SCALAR INDEX, LIS, LEN, LEX, I, LEX1;
  LEN := MAX (ABS (SYMM), 1);		% block size, 0 --> 1
  LEX := POINT;				% pointer in symmetry list
  LEX1 := NOSYM (MYCAR (LEX), LEN);	% build first block (LEN > 1)
  LEX := MYCDR (LEX);			% remaining pointers
  I := MYCADDR (LEX1);			
  LOOP:					% do for each remaining pointer
    INDEX := APPEND (INDEX, MYCAR (LEX1));
    LIS := MYCADR (LEX1) . LIS;
    IF NOT LEX THEN GO TO AFTERLOOP;
    LEX1 := NOSYM (MYCAR (LEX), LEN);	% build current block
    LEX := MYCDR (LEX);
    GO TO LOOP;
  AFTERLOOP:
  INDEXOUT := INSERT (INDEXOUT, LIST (INDEX,
              GENIND (LIS, SYMM)), I + 1, 'NIL);
  RETURN ('T);
END;

% nosym combines pieces of an index without symmetry.

SYMBOLIC PROCEDURE NOSYM (P1, LEN);
BEGIN SCALAR INDEX, LEX, LEX1, LEX2, LIS, LIS1, I, EX1;
  I := 0;
  INDEX := ZPN (P1, P1 + LEN - 1, 1);
   % search for part with given starting pointer p1.
  WHILE NOT (P1 = MYCAAAR (INDEXOUT)) AND INDEXOUT DO <<
    LEX := MYCAR (INDEXOUT) . LEX;	% save front of list
    INDEXOUT := MYCDR (INDEXOUT);
    I := I + 1
  >>;
  IF NOT INDEXOUT THEN THROW ('ZERO, 'NIL);	% most likely a bad symmetry
  LIS1 := '(NIL);
  WHILE NOT (LEX2 = INDEX) AND INDEXOUT DO <<	% build contiguous block
    LEX1 := MYCAR (INDEXOUT);
    INDEXOUT := MYCDR (INDEXOUT);		% remove each used partial index
    LIS := MYCADR (LEX1) . LIS;
    LIS1 := MYCAR (LEX1) . LIS1;
    LEX2 := MERGER (LEX2, MYCAR (LEX1), LEX2 OR 0, MYCAR (LEX1))
  >>;
  IF NOT (LEX2 = INDEX) AND NOT INDEXOUT THEN THROW ('ZERO, 'NIL); % bad sym
  INDEXOUT := APPEND (REVERSE (LEX), INDEXOUT);	% put it back together,
     % note: we dont put the completed block back in, we pass back the
     % position where it will go in I.
  IF LENGTH (LEX2) = 1 THEN RETURN (LIST (LEX2, MYCAR (LIS), I));
  GENIND2 ('NIL, REVERSE (LIS), REVERSE (LIS1));
  RETURN (LIST (LEX2, REVERSE (EX1), I));
END;

% doherm applies the hermitian symmetry to each index in lis according 
% to the pointers in plist. if the index obtained by exchanging 
% each pair of indices pointed to by the pointers is ordered less 
% than the original, and, furthermore this index already exists then 
% the current one may be discarded.

SYMBOLIC PROCEDURE DOHERM (LIS, PLST);
BEGIN SCALAR LEX, OLIS;

  WHILE LIS DO <<		% look at each outgoing index
    LEX := HERMITIAN (MYCAR (LIS), PLST);	% flip pairs
    IF NOT MYCDR (LEX) THEN OLIS := MYCAR (LIS) . OLIS	% not ordered
    ELSE IF NOT MEMBER (MYCAR (LEX), OLIS) THEN OLIS := MYCAR (LIS) . OLIS;
    LIS := MYCDR (LIS)
  >>;
  RETURN (REVERSE (OLIS));
END;

% genind generates indices from a symmetry list.

SYMBOLIC PROCEDURE GENIND (EX, SYMM);
BEGIN SCALAR LEX, ELMNTS, LEX, LEX1, LEX2, I, ASSOC!*, INDICES, EX1, FLG;
  LEX := EX;
  FLG := 'T;
  LOOP:
    ELMNTS := MERGEL (ELMNTS, MYCAR (LEX));
    LEX := MYCDR (LEX);
    IF NOT LEX THEN GO TO AFTERLOOP;
    IF NOT ELMNTS = MYCAR (LEX) THEN FLG := 'NIL;
    GO TO LOOP;
  AFTERLOOP:
  GENIND1 ('NIL, ELMNTS, LENGTH (EX), SYMM, FLG);
  IF NOT EX1 THEN THROW ('ZERO, 'NIL)
  ELSE IF FLG THEN RETURN (REVERSE (EX1));

  LOOP1:
    LEX := 'NIL;
    LEX1 := EX;
    IF NOT ELMNTS THEN GO TO AFTERLOOP1;
    LEX2 := MYCAR (ELMNTS);
    ELMNTS := MYCDR (ELMNTS);
    I := 1;
    WHILE LEX1 DO <<
      IF MEMBER (LEX2, MYCAR (LEX1)) THEN LEX := I . LEX;
      LEX1 := MYCDR (LEX1);
      I := I + 1
    >>;
    ASSOC!* := LIST (LEX2, REVERSE (LEX)) . ASSOC!*;
  GO TO LOOP1;
  AFTERLOOP1:
  ASSOC!* := REVERSE (ASSOC!*);
  WHILE EX1 DO <<
    IF CATCH ('OK, <<CHECK (MYCAR (EX1), 'NIL, ASSOC!*)>>) THEN
      INDICES := APPENDN (MYCAR (EX1)) . INDICES;
    EX1 := MYCDR (EX1)
  >>;
  IF NOT INDICES THEN THROW ('ZERO, 'NIL)
  ELSE RETURN (INDICES);
END;

% genind1 puts pieces together depending on the sign of the symmetry
% currently being applied. all these genind routines are mutually recursive
% so a simple explanation of how they work is impossible.

SYMBOLIC PROCEDURE GENIND1 (EL, LIS, I, SYMM, FLG);
BEGIN SCALAR LEX;
  IF I = 0 THEN <<
    IF FLG THEN EX1 := APPENDN (REVERSE (EL)) . EX1
    ELSE EX1 := REVERSE (EL) . EX1;
    RETURN ('T)
  >>;
  WHILE LIS DO <<
    IF SYMM > 0 THEN LEX := LIS		% symmetry
    ELSE IF SYMM < 0 THEN LEX := MYCDR (LIS)	% anti-symmetry
    ELSE LEX := LIST (MYCAR (LIS));	% diagonal
    GENIND1 (MYCAR (LIS) . EL, LEX, I - 1, SYMM, FLG);
    LIS := MYCDR (LIS)
  >>;
  RETURN ('T);
END;

% genind2 

SYMBOLIC PROCEDURE GENIND2 (EL, LIS, POINT);
BEGIN SCALAR LEX, LEX1;
  IF NOT LIS THEN <<
    EX1 := EL . EX1;
    RETURN ('T)
  >>;
  LEX := MYCAR (LIS);
  LIS := MYCDR (LIS);
  LEX1 := MERGER (MYCAR (POINT), MYCADR (POINT), MYCAR (POINT), MYCADR (POINT)) .
                MYCDDR (POINT);
  FOR EACH X IN LEX DO
    GENIND2 (MERGER (X, EL, MYCADR (POINT),
             MYCAR (POINT)), LIS, LEX1);
  RETURN ('T);
END;

% check looks at each possible index and determines if it violates
% indice counts and must be discarded.

SYMBOLIC PROCEDURE CHECK (INDEX, SLOTS, ASSOC!*);
BEGIN SCALAR LEX;
  IF NOT INDEX THEN THROW ('OK, 'T);
  LEX := MYCADR (ASSOC (MYCAR (INDEX), ASSOC!*));
  WHILE LEX DO <<
    IF MEMBER (MYCAR (LEX), SLOTS) THEN LEX := MYCDR (LEX)
    ELSE <<
      CHECK (MYCDR (INDEX), APPEND (SLOTS, LIST (MYCAR (LEX))), ASSOC!*);
      LEX := MYCDR (LEX)
    >>
  >>;
  RETURN ('NIL);
END;

% merger combines the lists ex1 and ex2 according to the corresponding
% pointers in i1 and i2. e.g. merger ('(a b c),'(e f),'(1 3 5),'(2 4)) 
% --> (a e b f c)
% the pointers must be in order.

SYMBOLIC PROCEDURE MERGER (EX1, EX2, I1, I2);
BEGIN SCALAR LIS;
  IF NOT EX2 THEN RETURN (EX1)		% no work
  ELSE IF ATOM (EX1) THEN RETURN (EX2)
  ELSE IF MYCAR (I2) > NTH (I1, LENGTH (I1)) THEN
    RETURN (APPEND (EX1, EX2))	% start of ex2 is after end of ex1.
  ELSE IF EX1 = EX2 AND I1 = I2 THEN RETURN (EX1);  % a hook for something
  WHILE EX1 AND EX2 DO <<		% run over both lists
    IF MYCAR (I1) < MYCAR (I2) THEN <<	% put car (ex1) into output
      LIS := MYCAR (EX1) . LIS;
      EX1 := MYCDR (EX1);
      I1 := MYCDR (I1)
    >> ELSE <<
      LIS := MYCAR (EX2) . LIS;		% put car (ex2) into output
      EX2 := MYCDR (EX2);
      I2 := MYCDR (I2)
    >>
  >>;
  RETURN (APPEND (APPEND (REVERSE (LIS), EX1), EX2));  % add leftovers too
END;

% mergel combines 2 lists of partial indices according to the ordering of
% each corresponding pair.

SYMBOLIC PROCEDURE MERGEL (EX1, EX2);
BEGIN SCALAR LIS;
  IF EX1 = EX2 THEN RETURN (EX1);
  WHILE EX1 AND EX2 DO <<
    IF MYCAR (EX1) = MYCAR (EX2) THEN <<
      LIS := MYCAR (EX1) . LIS;
      EX1 := MYCDR (EX1);
      EX2 := MYCDR (EX2)
    >> ELSE IF ORDERINDEX (MYCAR (EX1), MYCAR (EX2)) THEN <<
      LIS := MYCAR (EX1) . LIS;
      EX1 := MYCDR (EX1)
    >> ELSE <<
      LIS := MYCAR (EX2) . LIS;
      EX2 := MYCDR (EX2)
    >>
  >>;
  RETURN (APPEND (APPEND (REVERSE (LIS), EX1), EX2));
END;

;END;
