(* Graphics output for graphics generated remotely.  The terminal	*)
(* may be a SunView window.  Written by Greg Stark.			*)

(* These variables can be reset during a session to alter subsequently
   created mathgraphics windows:  *)

$DisplayWidth = 400
$DisplayHeight = 400
$DisplayTitle := StringForm["Mathematica Graphics:  Out[`1`]", $Line]

$Display := $SunDisplay

$SunDisplay := "!(cat >> ${HOME}/mathgr1; mv ${HOME}/mathgr1 ${HOME}/mathgr2)"

Begin["SunViewRemote`Private`"]

`mathgrcount = 0

$DisplayFunction := (
   Block[
      {home, ofile},
      
      Print["Displaying remote graphic ", ++mathgrcount];
      home = Environment["HOME"];
      ofile = StringJoin[home, "/mathgr1"];
      OpenWrite[ofile];
      WriteString[ofile,
                  "-h '", N[$DisplayHeight],
                  "' -w '", N[$DisplayWidth],
                  "' -T '", $DisplayTitle, "'\n"
                  ];
      Close[ofile];
   ];
   Display[$Display, #]
)&

End[] (* SunViewRemote`Private` *)

Print[]
Print["-- Remote SunView mathgraphics initialized --"]
Print["   For mathgraphics output, \"mathgraphics\" should be running."]
