/*******************************************************************
 *  FILE: MANUAL.C                         Sun May 24 19:22:09 EDT 1987
 *   
 *  Functions in this file:
 *   
 *  main forward find_string
 *   
 *  muTENSOR source code
 *  Copyright (c) 1986, 1987 University of Toronto.
 *  All Rights Reserved.
 *
 *  Written by John Harper and Charles Dyer
 *
 *  Permission to use this software without fee is granted subject to 
 *  the following restrictions:
 * 
 *  1. This software may not be used or distributed for direct commercial
 *     gain.
 * 
 *  2. The author is not responsible for the consequences of use of this
 *     software, no matter how awful, even if they arise from flaws in it.
 * 
 *  3. The origin of this software must not be misrepresented, either by
 *     explicit claim or by omission.
 * 
 *  4. This code may be altered to suit your need, but such alterations
 *     must be plainly marked and the code must not be misrepresented
 *     as the original software.
 * 
 *  5. This notice may not be removed or altered.
 * 
 **********************************************************************/
#include <stdio.h>

#define LINES 20
#define BUFSZE 4192
#define CHRS_BAK 500
#define MIN(x,y) ((x) < (y) ? (x) : (y))
/*
 * We use a very simple search algorithm: read a buffer, and look for the
 * string specified in argv[1] following a newline (i.e at the start of a
 * line). Smarter methods might be faster, but we want a small uncomplicated
 * program. 
 */

char buf[BUFSZE];
char s[100];
FILE *fopen(), *fpin;
long k, n;

main (argc, argv)
char *argv[];
int argc;
{
    char *sym;
    int l_sym;
    long on, m, forward();

    if (argc <= 2) exit(0);
    if ((fpin = fopen (argv[2], "r")) == NULL) exit(0);
    sym = argv[1];			/* thing to look for */
    l_sym = strlen(sym);		/* its length */
    n = 0;
    while (1)
      {
	  if (fread (buf, sizeof (char), BUFSZE, fpin) == NULL) exit (0);
	  if (find_string (buf, sym, l_sym)) break;
	  fseek (fpin, k, 0);
      };
    fseek (fpin, n, 0);
    on = n;
  more:
    m = forward (n);
    if (m >= 0) 
      {
	  on = n;
	  n = m;
      }
    fputs (" --MORE-- ", stderr);
    fgets (s, 100, stdin);
    if (*s == 'q' || *s == 'Q') exit(0);
    if (*s == 'u' || *s == 'U') n = on - CHRS_BAK;
    if (n < 0) n = 0;
    goto more;
}

long forward (n)
long n;
{
    int i;
    if (n > 0) 
      {
	  fseek (fpin, n - 1, 0);
	  fgets (s, 1, fpin);
	  if (*s != '\n') fgets(s, 100, fpin);
      } else fseek(fpin, n, 0);

    for (i = 0; i < LINES; ++i)
      {
	  if (fgets (s, 100, fpin) == NULL) return (-1);
	  fputs (s, stderr);
      }
    return (ftell (fpin));
}

int find_string (buf, sym, l)
char *buf, *sym;
int l;
{
    char *p = buf;
    while (1)
      {
	  while (*p != '\n' && *p != '\0')
	    {
		p++;
		n++;
	    };
	  if (*p == '\0')
	    {
		n = k;
		return (0);
	    };
	  k = n;
	  p++;
	  n++;
	  if (strncmp (p, sym, l) == 0) return (1);
      }
}
