/************************************************************************
**
** Writer - sample writer.  Write 20 sort messages and quit.
**
************************************************************************/

/*
 * $Log: writer.c,v $
 * Revision 1.4  1991/11/01  23:07:37  jefft
 * Added a dummy data section for testing purposes.
 *
 * Revision 1.3  1991/10/15  18:17:46  jplevyak
 * Changed DTMSYNC to DTM_NOSYNC.
 * ... DTMSYNC to DTM_SYNC.
 *
 * Revision 1.2  1991/10/14  19:37:46  jefft
 * fixed quiet option, changed it to verbose.
 *
 * Revision 1.1  1991/10/11  23:16:12  jefft
 * Initial revision
 *
 */

#include	<stdio.h>
#include	<dtm.h>


static float	dummy[10];


main(argc, argv)
  int	argc;
  char	*argv[];
{
  int	i, outport = -1;
  int	verbose = 0;
  char	header[DTM_MAX_HEADER];


  /* scan the command line for port information */
  for (i=1; i<argc; i+=1)
    if (!strcmp(argv[i], "-DTMOUT"))
      outport = DTMmakeOutPort(argv[++i], DTM_SYNC);
    else if (!strncmp(argv[i], "-v", 2))
      verbose = 1;

  /* make sure the outport has been defined */
  if (outport == -1)  {
    fprintf(stderr,"%s: Error - couldn't open port\n", argv[0]);
    exit(-1);
    }


  /* write 20 messages */
  for(i=0; i<20; i+=1)  {

    /* build the header */
    MSGsetClass(header);
    dtm_set_int(header, "ID", i);
    dtm_set_char(header, "STRING", "this is the test");

    if (verbose)
      fprintf(stderr, "writing header = '%s'\n", header);

    /* send each header */
    if (DTMbeginWrite(outport, header, DTMHL(header)) == DTMERROR)  {
      fprintf(stderr, "\tERROR: DTMbeginWrite: DTMerrno = %d\n", DTMerrno);
      exit(-1);
      }

    /* send a dummy data section */
    DTMwriteDataset(outport, dummy, sizeof dummy / sizeof (float), DTM_FLOAT);

    /* no data in these messages, so end the message */
    DTMendWrite(outport);
    }
}
