/*
  File: wff.h
  Author: K.R. Sloan
          Daniel O'Donnell
          Mike Schmidt
  Last Modified: 6 July 1989
  Purpose: definitions for the Washington file Format 
            header access procedures
 */
#define SUCCESS  (1)
#define FAILURE  (0)
#define UNDEF    (-1)

#define NameLength  (128)
#define ValueLength (128)
#define MaxNV        (64)
#define wffMaxCoordinate (16191)

typedef struct
 {
  char Name[NameLength];
  char Value[ValueLength];
 } NVtype;

typedef struct
 {
  int  VALID;
  int  Bottom, Left, Top, Right;
  int  BandsPerPixel, BitsPerBand;
  int  BitsPerPixel, BytesPerPixel;
  int  EncodingType;
  int  AccessType;
  NVtype  NV[MaxNV];
  unsigned char *AIS;
  FILE *FileDescriptor;
  int Count;
  unsigned short *Pixel;
 } FrameBufferType;

extern int GetBounds();     /* GetBounds(FrameBuffer,
                                         Bottom, Left, Top, Right)
                                FrameBufferType *FrameBuffer;
                                int *Bottom,*Left,*Top,*Right;            */

extern int SetBounds();     /* Setbounds(FrameBuffer,
                                         Bottom, Left, Top, Right)
                                FrameBufferType *FrameBuffer;
                                int Bottom,Left,Top,Right;                */

extern int GetColorSystem();/* GetColorSystem(FrameBuffer,
                                              WhatBands, BitsPerBand)
                                FrameBufferType *FrameBuffer;
                                char *WhatBands;
                                int *BitsPerBand;                         */

extern int SetColorSystem();/* SetColorSystem (FrameBuffer, 
                                               WhatBands,  BitsPerBand)
                                FrameBufferType *FrameBuffer;
                                char *WhatBands;
                                int BitsPerBand;                          */

extern int SetDescriptor(); /* SetDescriptor(FrameBuffer, Name, Value)
                                FrameBufferType *FrameBuffer;
                                char *Name;
                                char *Value;                             */

extern int GetDescriptor(); /* GetDescriptor(FrameBuffer, Name, Value)
                                FrameBufferType *FrameBuffer;
                                char *Name;
                                char *Value;                             */

extern int GetDescriptorN();/* GetDescriptorN(FrameBuffer, N, Name, Value)
                                FrameBufferType *FrameBuffer;
                                int N; 
                                char *Name;
                                char *Value;                             */

extern int OpenFB();        /* OpenFB(FrameBufferPtr)
                                FrameBufferType **FrameBufferPtr;         */

extern int CloseFB();       /* CloseFB(FrameBufferPtr)
                                FrameBufferType **FrameBufferPtr;         */

extern int ReadImage();     /* ReadImage(FileDescriptor, FrameBuffer)
                                FILE *FileDescriptor;
                                FrameBufferType *FrameBuffer;             */

extern int WriteImage();    /* WriteImage(FileDescriptor, FrameBuffer)
                                FILE *FileDescriptor;
                                FrameBufferType *FrameBuffer;             */

extern int GetPixel();      /* GetPixel(FrameBuffer, x, y, pixel)
                                FrameBufferType *FrameBuffer;            
                                int x, y;
                                unsigned short *pixel;                   */

extern int PutPixel();      /* PutPixel(FrameBuffer, x, y, pixel)
                                FrameBufferType *FrameBuffer;            
                                int x, y;
                                unsigned short *pixel;                  */

extern int GetBlock();      /* GetBlock(FrameBuffer,
                                         bottom, left, top, right, array)
                                FrameBufferType *FrameBuffer;            
                                int bottom, left, top, right;
                                unsigned short *array;                 */

extern int PutBlock();      /* PutBlock(FrameBuffer,
                                         bottom, left, top, right, array)
                                FrameBufferType *FrameBuffer;            
                                int bottom, left, top, right;
                                unsigned short *array;                */

extern int PutConstant();   /* PutBlock(FrameBuffer,
                                         bottom, left, top, right, pixel)
                                FrameBufferType *FrameBuffer;            
                                int bottom, left, top, right;
                                unsigned short *pixel;               */

extern int PassImageIn();   /* PassImageIn(FileDescriptor, FrameBuffer)
                                FILE *FileDescriptor;
                                FrameBufferType *FrameBuffer;        */

extern int PassImageOut();  /* PassImageOut(FileDescriptor, FrameBuffer)
                                FILE *FileDescriptor;
                                FrameBufferType *FrameBuffer;        */

extern int NextNPixelsIn();   /* NextNPixelsIn(FrameBuffer, N, pixel)
                                 FrameBufferType *FrameBuffer;            
				 int N;
                                 unsigned short *pixel;                   */

#define NextPixelIn(FrameBuffer,pixel) \
       NextNPixelsIn( (FrameBuffer), 1, (pixel) )

extern int NextNPixelsOut();  /* NextPixelOut(FrameBuffer, N, pixel)
                                FrameBufferType *FrameBuffer; 
				int N;
                                unsigned short *pixel;                   */

#define NextPixelOut(FrameBuffer,pixel) \
       NextNPixelsOut( (FrameBuffer), 1, (pixel) )

extern int wffFlush();      /* wffFlush(FrameBuffer)
                                FrameBufferType *FrameBuffer;            */

