/*
  File: wff2rle.c
  Authors: James Painter,
           K.R. Sloan
  Last Modified: 6 September 1990
  Purpose: Convert a WFF format file to  RLE format.
 */

#include <stdio.h>
#include <assert.h>
#include "rle.h"
#include "wff.h"

typedef FILE	*FILPTR;

static char *RoutineName;
static FrameBufferType *OpenWFFFile();

static void ReadWFFScanLine();
static void CloseWFFFile();


usage()
 {
  fprintf( stderr, "\
usage: %s < wfffile > rlefile \n\
\n\
Where:    rlefile  : Name of input file  (RLE format)\n\
          wfffile  : Name of output file (WFF format)\n\
\n\
", RoutineName );
 }

/*
 * usage : wff2rle < wfffile >rlefile
 *
 *	wfffile			File to convert
 *      rlefile                 Result
 */

int main(argc, argv)
 int  argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  register char * cp, * slashp;
  FILPTR *outfil;		/* Output file pointers. */
  FILE   *inpfil;		/* Input file pointer. */
  char   *inpnam = NULL;	/* Input file name. */
  char   *outnam = NULL;	/* Output file name prefix. */
  int aflag = 0;		/* Alpha channel flag. */
  int files;			/* Number of output files. */
  int scans, rasts;		/* Number of scan lines. */
  rle_pixel **outrow;		/* Output buffer. */
  int i, row;
  int channel, scanLength, channelSize;
  int Left,Right,Top,Bottom;
  int y, chan, achan, nchans;
  int width, height;
  FrameBufferType *wffdesc;
  char Bands[80];
  unsigned short *sp, *ScanLineIn;
  int x, Bits;

  RoutineName = argv[ArgsParsed++];
  if (argc != ArgsParsed) { usage(); exit(1); }

  /* Open the input file */
  wffdesc = OpenWFFFile(stdin, &width, &height, Bands, &Bits);
  assert(wffdesc);  


  /* Open output file */
  rle_dflt_hdr.rle_file = stdout;

  nchans = strlen( Bands );

  ScanLineIn = (unsigned short *) 
      malloc( width*nchans*sizeof(unsigned short ) );

  /* Look for an alpha channel */
  aflag = 0;
  achan = nchans;
  if (Bands[nchans-1] == 'A') { aflag = 1; achan = nchans-1; }

  /* Set up the RLE header */
  rle_dflt_hdr.alpha = aflag;
  rle_dflt_hdr.ncolors = nchans - aflag;
  rle_dflt_hdr.xmax = width - 1;
  rle_dflt_hdr.ymax = height - 1;
  rle_dflt_hdr.ymin = rle_dflt_hdr.xmin = 0;
  for (i = -aflag; i < rle_dflt_hdr.ncolors; i++)
   RLE_SET_BIT( rle_dflt_hdr, i );
  rle_put_setup( &rle_dflt_hdr );
  if (rle_row_alloc( &rle_dflt_hdr, &outrow ))
   {
    fprintf( stderr, "%s: No memory for scanline buffer!\n",
           RoutineName);
    exit(1);
   }

  /* Copy the data taking care to map the alpha channel to channel # -1 */
  for (y = 0; y < height; y++)
   {
    ReadWFFScanLine( wffdesc, width, ScanLineIn );
    sp = ScanLineIn;
    for(x = 0; x < width; x++)
     {
      for (chan = 0; chan < achan; chan++)
       outrow[chan][x] = (*sp++ << (16-Bits)) >> 8;
      if (aflag) sp++;
     }

    if (aflag) 
     {
      sp = ScanLineIn + achan ;
      for (x = 0; x < width; x++)
       {
        outrow[-1][x] = (*sp << (16-Bits)) >> 8;
        sp += nchans;
       }
     }
    rle_putrow( outrow, width, &rle_dflt_hdr );
   }
  CloseWFFFile( wffdesc );
  exit(0);
 }


/* ------------------------------------------------------------------------ */

/* These function deal with WFF files */

static FrameBufferType *OpenWFFFile(stream, xsize, ysize, WhatBands, Bits)
 FILE *stream;
 int *xsize, *ysize;
 char *WhatBands;
 int *Bits;
 {
  FrameBufferType *FrameBuffer = NULL;
  int Bottom, Left, Top, Right;
  int BitsPerBand;
  char  Name[NameLength], Value[ValueLength];

  OpenFB(&FrameBuffer);
  assert(FrameBuffer);

  PassImageIn( stream, FrameBuffer);

  GetBounds(FrameBuffer, &Bottom, &Left, &Top, &Right);
  GetColorSystem(FrameBuffer, WhatBands,  Bits);

  *xsize = Right - Left + 1;
  *ysize = Top   - Bottom + 1;
    
  return FrameBuffer;
 }  


static void ReadWFFScanLine(wffdesc, xsize, ScanLine)
 FrameBufferType *wffdesc;
 int xsize;
 unsigned short *ScanLine;
 {
  assert (SUCCESS == NextNPixelsIn( wffdesc, xsize, ScanLine ));
 }


static void CloseWFFFile(wffdesc)
 FrameBufferType *wffdesc;
 {
  CloseFB(&wffdesc);
 }
