/*
   File: ColorMap.h
   Authors: James Painter
   Last Modified: 11 April 1989
   Purpose: ADT for WFF colormaps
*/

/* A data type for color maps */
typedef struct {
  int NBands, BitsIn, BitsOut;
  unsigned short **map;		/* Right index is channel, left is value */
} ColorMapType;


ColorMapType *CreateColorMap ( /* NBands, BitsIn, BitsOut */ );
ColorMapType *ReadColorMap   ( /* FILE *input; */ );
void WriteColorMap( /* ColorMapType *theMap, FILE *theFile */ );
void DisposeMap ( /* ColorMapType *theMap; */ );

