/*
   File: ColorMap.c
   Authors: James Painter
   Last Modified: 11 April 1989
   Purpose: ADT for WFF colormaps
*/
#include <stdio.h>
#include "ColorMap.h"

extern char *malloc(), *malloc_2d();

ColorMapType *
CreateColorMap( NBands, BitsIn, BitsOut )
int NBands, BitsIn, BitsOut;
{
  int InCount, OutCount, i, b;
  ColorMapType *result;

  result = (ColorMapType *)  malloc(sizeof(ColorMapType));
  if (result == 0) return 0;

  InCount  = (1 << BitsIn);
  OutCount = (1 << BitsOut);
  result->map = (unsigned short **) 
    malloc_2d(InCount, NBands, sizeof(unsigned short) );
  if (result->map == 0) { free(result); return 0; }
  
  /* Fill with the a ramp */
  for(i=0; i<InCount; i++)
    for(b=0; b<NBands; b++)
      result->map[i][b] = i*(InCount-1)/(OutCount-1);

  result->NBands = NBands;
  result->BitsIn = BitsIn;
  result->BitsOut = BitsOut;
  return result;
}

ColorMapType *
ReadColorMap( file )
     FILE *file;
{
  int NBands, BitsIn, BitsOut;
  ColorMapType *result;
  int i, MaxOut, InCount, b;

  fscanf( file, "%d %d %d",  &NBands, &BitsIn,  &BitsOut );
  result = CreateColorMap( NBands, BitsIn, BitsOut );
  if (result == 0) return 0;

  MaxOut = (1 << BitsOut) -1;
  InCount  = (1 << BitsIn);

  for(i=0; i< InCount; i++)
    for(b=0; b< result->NBands; b++)
      {
	int c;

	if (fscanf( file, "%d", &c) != 1) 
	  {
	    fprintf( stderr, "Bad colormap file\n" );
	    free( result->map );
	    free( result );
	    return (ColorMapType *) 0;
	}
	result->map[i][b] = c;
      }
  return result;
}


void 
WriteColorMap( theMap, theFile )
     ColorMapType *theMap;
     FILE *theFile;
{
  int i, n, b;

  fprintf( theFile, "%d %d %d\n", 
	 theMap->NBands, theMap->BitsIn, theMap->BitsOut );
  n = (1 << theMap->BitsIn);
  for(i=0; i<n; i++) 
    {
      for(b=0; b< theMap->NBands; b++) 
	fprintf( theFile, "%d ", (int) theMap->map[i][b] );
      putc('\n', theFile);
    }
}

void
DisposeMap( theMap )
ColorMapType *theMap;
{
  if (theMap == 0) return;
  if (theMap->map != 0)
    free(theMap->map);
  free(theMap);
}

