/*
 File: Circle.c
 Authors: K.R. Sloan
 Last Modified: 1 November 1992
 Purpose: produces a circle - suitable for input to
          a convexity tester.
 */
#include <stdio.h>
#include <math.h>
double atof();

#define PI (3.1415926)

static int VERBOSE = 0;
static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s [-h][-v][-O x y][-r r][-n n]\n",
               RoutineName);
 }

static void FatalError(s)
 char *s;
 {
  fprintf(stderr,"%s: FatalError(%s)\n",RoutineName,s);
  exit(-1);
 }

typedef struct Point { double x, y; } Point;

static void WritePoints(s,O,r,n)
 FILE *s;
 Point O;
 double r;
 int n;
 {
  int i;
  Point P;
  double theta;

  for(i=0;i<n;i++)
   {
    theta = 2.0*PI*(double)i/(double)n;
    P.x = r*cos(theta); P.y = r*sin(theta);
    fprintf(s,"%lf %lf\n",P.x,P.y);
   }
 }

int main (argc, argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed=0;
  Point O;
  double r;
  int n;

  RoutineName = argv[ArgsParsed++];

  O.x = 0.0; O.y = 0.0;
  r = 10000.0;
  n = (int)r;

  while (ArgsParsed < argc)
   {
    if ('-' == argv[ArgsParsed][0])
     switch (argv[ArgsParsed++][1])
      {
       case 'O': if (2 > (argc-ArgsParsed)) {usage();exit(-1);}
                 O.x = atof(argv[ArgsParsed++]);
                 O.y = atof(argv[ArgsParsed++]);
                 break;
       case 'r': if (1 > (argc-ArgsParsed)) {usage();exit(-1);}
                 r =  atof(argv[ArgsParsed++]);
                 break;
       case 'n': if (1 > (argc-ArgsParsed)) {usage();exit(-1);}
                 n =  atoi(argv[ArgsParsed++]);
                 break;
       case 'v': VERBOSE  = -1; break;
       default:
       case 'h': usage(); exit(-1);
      }
   }

  WritePoints(stdout,O,r,n);

  exit(0);
 }
