/*
  File: devT/DEVICE.c
  Author: K.R. Sloan
  Last Modified: 10 February 1991
  Purpose: definitions for the generic graphics device used by SGP
           this version uses the "image" abstraction to
           provide a framebuffer (see devInit) and draw Pixels (see
           devRect).  
  See also: devLine.c, devTriangle.c, devCircle.c, devClip.c.
           Some of the functions promised in DEVICE.h are implemented there.

           devPick always fails
 */
#include <stdio.h>
#include "DEVICE.h"
#include "image.h"
extern devClipLine();
extern devClipRectangle();

/*  Device state  - made global for convenience ... */
int devLeft, devBottom, devRight, devTop;
int devClipL, devClipT, devClipR, devClipB;
int devCurrentColor;
FILE *devOutputStream;
double devAspectRatio = 1.0;

/* private */
IMAGE *devImage;

/*
   devInit initializes the display, loading color maps if necessary
   There are two modes: color and mono.  Here, we assume a full-color
   display, and the two modes are identical

   devInit may also need to fill in the "physical" size of the display
   here, we output the "physical" limits to help your interpreter 
 */
int devInit(color, OutputStream)
 int color;
 FILE *OutputStream;
 {
  devOutputStream = OutputStream;
  devLeft = 0;  devTop = 399; devRight = 511; devBottom = 0;
  devSetClipWin(devLeft,devBottom,devRight,devTop);
  devCurrentColor = devColorCode(1.0, 1.0, 1.0);

  devImage = ImCreate(devRight-devLeft+1, devTop-devBottom+1);

  if ((IMAGE *)0 == devImage)
   {
    fprintf(stderr, "devInit:Couldn't create image structure\n");
    return(1); /* failure */
   }
  return(0); /* success */ 
 }

/*
  devClose insures that all operations are complete and closes up
 */
int devClose()
 {
  /* Write the image file out to our output stream */
  ImWrite(devImage, devOutputStream);
  ImDestroy(devImage);
  devImage = (IMAGE *)0;
 
  return(0); /* success */ 
 }

/*
  devSetClipWin establishes a clipping window
  restrictions such as (L<R) must be enforced here!
 */
int devSetClipWin(L, B, R, T)
 int L, B, R, T;
 {
  if (L<R) { devClipL=L; devClipR=R; } else { devClipL=R; devClipR=L;} 
  if (B<T) { devClipB=B; devClipT=T; } else { devClipB=T; devClipT=B;} 


  if (devLeft < devRight)
   {
    if (devClipL < devLeft)   devClipL = devLeft;
    if (devClipR > devRight)  devClipR = devRight;
   }
  else
   {
    if (devClipL < devRight)  devClipL = devRight;
    if (devClipR > devLeft)   devClipR = devLeft;
   }

  if (devBottom < devTop)
   {
    if (devClipB < devBottom) devClipB = devBottom;
    if (devClipT > devTop)    devClipT = devTop;
   }
  else 
   {
    if (devClipB < devTop)    devClipB = devTop;
    if (devClipT > devBottom) devClipT = devBottom;
   }

  return(0); /* success */
 }

/*
 devClearScreen fills the entire screen with a particular color
 */
int devClearScreen(color)
 int color;
 {
  int SavedColorCode;
  int SavedClipL, SavedClipT, SavedClipR, SavedClipB; 

  SavedColorCode = devCurrentColor;
  SavedClipL = devClipL;  SavedClipB = devClipB;
  SavedClipR = devClipR;  SavedClipT = devClipT;
  devSetClipWin(devLeft,devBottom,devRight,devTop);

  devCurrentColor = color;
  devRect(devLeft, devBottom, devRight, devTop);

  devCurrentColor = SavedColorCode;
  devSetClipWin(SavedClipL,SavedClipB,SavedClipR,SavedClipT);

  return(0); /* success */
 }

/*
   the following routines draw primitive shapes on the physical device
   All of them clip against the device's clipping window.
   All of them paint in the device's current color
 */

/*
  devLine draws a line - see devLine.c
 */

/*
 devRect fills a rectangle - we assume this is a primitive
 */
int devRect(L, B, R, T)
 int L, B, R, T;
 {
  int x,y;
  int r, g, b;

  if (devClipRectangle(&L, &B, &R, &T)) return(0); /* success */

  r = (devCurrentColor >> 16) & 0xff;
  g = (devCurrentColor >>  8) & 0xff;
  b = (devCurrentColor      ) & 0xff;

  for (y=B;y<=T;y++)
   for (x=L;x<=R;x++)
    ImSetPixel(devImage, x, y, r, g, b);

  return(0); /* success */
 }

/*
 devDisc fills a disc - see devCircle.c
 */

/*
 devCircle draws a circle - see devCircle.c
 */

/*
 devSolidTriangle fills a triangle - see devTriangle.c
 */

/*
 devShadeTriangle shades a triangle
   with color codes specified at each vertex - see devTriangle.c
 */

/*
 devSetColor establishes the current color
 */
int devSetColor(color)
 int color;
 {
  devCurrentColor = color;
  return(0); /* success */
 }

/*
   devColorCode returns a framebuffer value - here we assume a full-color
   display, with 8-bits each of rgb, packed as:
            [00000000rrrrrrrrggggggggbbbbbbbb]
 */ 
int devColorCode(R, G, B)
 double R,G,B; 
 {
  int devR, devG, devB;

  devR = 255.0 * R;
  devG = 255.0 * G;
  devB = 255.0 * B;
  return (  ((devR & 0xff) << 16)
          | ((devG & 0xff) <<  8)
          | ((devB & 0xff)      ) );
 }
/*
  devColorDecode generates r,g,b values in [0.0, 1.0] 
 */
int devColorDecode(code, R, G, B)
 int code;
 double *R, *G, *B;
 {
  int devR, devG, devB;

  devR = (code >> 16) & 0xff;
  devG = (code >>  8) & 0xff;
  devB = (code      ) & 0xff;
  *R = (double)devR / 255.0;
  *G = (double)devG / 255.0;
  *B = (double)devB / 255.0;
  return (0);
 }

int devPick(x,y,button)
 int *x,*y,*button;
 {
  *x = 0; *y = 0; *button = 0; return(-1); /* failure */
 }

/*       -30-         */
