/*
** Author:      James Painter
** Purpose:     Microcode interface 
**
** Copyright (c), 1988 GRAIL, University of Washington
**
** $Revision$
** $Date$
** $Locker$
** $Log$
*/
#include <stdio.h>
#include <graphics/const.h>
#include <graphics/ik_const.h>
#include <sys/time.h>
#include "uEngine.h"

#define CXB_HI_RES        00

/* Private variables */
Args *_uEArgs = 0;		/* Point to argument block */
int *_uEnext;			/* next pointer int _uEArgs->cmd */
int *_uEend;			/* end pointer for  _uEArgs->cmd */
int   _uEcolor = -1;		/* Current color */

/* Wait for all pending microcode to finish. DOES NOT flush buffer first */
uESync( )
{
  int done;
  static struct timeval timeout = { 0, 25000 };    /* 1/40 of a second */

  /* Wait for the bit slice to finish */
  for(;;) {
    Ik_diord(IK_WD_ADDR,IK_SCRATCHPAD,0,&done); 
    if (done != RUNNING) break;
    select( 0, 0, 0, 0, &timeout );
  }
}

/* Wait for all pending commands to finish, then write out buffered commands */
uEFlush()
{
   int size;
   
  /* Wait for the bit slice to finish */
   uESync();
  
  /* Send the new data down */
  _uEArgs->count = (_uEnext  - _uEArgs->cmd);
  size = 2 + _uEArgs->count;
  _uEArgs->running = WAITING;
  Ik_dmawr( IK_WD_ADDR, IK_SCRATCHPAD, 0, _uEArgs, size );

  /* Let it start working */
  Ik_diowr( IK_WD_ADDR, IK_SCRATCHPAD, 0, RUNNING );

  /* Reset args */
  _uEnext = _uEArgs->cmd;

  return 0; /* success */
}
  

/*
  Initalize uEngine.  Mode can be HighRes or LowRes.
 */
int uEInitialize(Mode)
 mode Mode;
 {
   extern char *malloc();
  /* Allocate memory for the microcode command buffer */
  _uEArgs = (Args *) malloc( sizeof(Args) + BUFFER_SIZE*sizeof(int) );
  if (_uEArgs == 0) 
    fprintf(stderr, "No memory for microcode command buffer!\n" );
  else {
    _uEnext = _uEArgs->cmd;
    _uEend  = _uEnext + BUFFER_SIZE;
  }


  /* Initialize the adage and set up the microcode support code */
  Ik_open ( );
  Ik_init ( );
  if (Mode == LowRes)
    {
      Ik_download( MICROCODE_PATH );
    } else {
      Ik_fbc_init( HR_FBC_INIT_PATH );
      Ik_download( HR_MICROCODE_PATH );
      Ik_diowr( IK_WD_ADDR, IK_CHANNEL_XBAR, 0, CXB_HI_RES );
    }

  Ik_reset_micro();
  Ik_diowr( IK_WD_ADDR, IK_SCRATCHPAD, 0, RUNNING );
  Ik_start_micro();

  return( 0 ); /* success */ 
 }

/*
  devClose insures that all operations are complete and closes up
 */
int uEFinalize()
 {
   /* Flush any pending commands out to the bit slice */
   uEFlush();

   /* Wait for the commands to finish */
   uESync();

   /* Now turn off the bit slice and close the device */
   Ik_reset_micro();
   Ik_close();
   if (_uEArgs != 0)
     free(_uEArgs);
   _uEArgs = 0;
  return(0); /* success */ 
 }

