/*
  File: devClip.c
  Authors: Walter Bender,
           K.R. Sloan
  Last Modified: 19 July 1989
  Purpose: Clip to the current clipping window:
            devClipL < devClipR
            devClipB < devClipT
           devClip{Point|Line|Rectangle} return
                 0            if the (modified) object is   visible
            something else    if the            object is invisible
  Reference: F&vD p. 148
 */

#include <stdio.h>
#include "DEVICE.h"

#define LeftCode  0x01
#define RightCode 0x02
#define BelowCode 0x04
#define AboveCode 0x08

static int devClipPoint(x, y)
 int x, y;
 {
  int code;
  code = 0;
  if (x < devClipL) code |= LeftCode;
  if (y < devClipB) code |= BelowCode;
  if (x > devClipR) code |= RightCode;
  if (y > devClipT) code |= AboveCode;
  return(code);
 }

int devClipLine(x1, y1, x2, y2)
 int *x1;
 int *x2;
 int *y1;
 int *y2;
 {
  int d;
  int outcode1, outcode2;
  int x, y, dx, dy, outcode; 
  
  outcode1 = devClipPoint(*x1, *y1); outcode2 = devClipPoint(*x2, *y2);
  for(;;)
   {
    if (outcode1 & outcode2)                return -1; /* invisible */
    if ((outcode1 == 0) && (outcode2 == 0)) return  0; /*   visible */
    if (outcode1 == 0)
     {
      x = *x2; y = *y2; dx = *x1-*x2; dy = *y1-*y2; outcode = outcode2;
     }
    else 
     {
      x = *x1; y = *y1; dx = *x2-*x1; dy = *y2-*y1; outcode = outcode1;
     }
    if (outcode & AboveCode) 
     {
      x = x + dx*(devClipT - y)/dy;
      y = devClipT;
     }
    else if (outcode & BelowCode) 
     {
      x = x + dx*(devClipB - y)/dy;
      y = devClipB;
     }
    else if (outcode & RightCode) 
     {
      y = y + dy*(devClipR - x)/dx;
      x = devClipR;
     }
    else if (outcode & LeftCode)
     {
      y = y + dy*(devClipL - x)/dx;
      x = devClipL;
     }
    if (outcode1 == 0)
     {
      *x2 = x; *y2 = y; outcode2 = devClipPoint(x, y);
     }
    else
     {
      *x1 = x; *y1 = y; outcode1 = devClipPoint(x, y);
     }
   }
 }

int devClipRectangle(L, B, R, T)
 int *L, *B, *R, *T;
 {
  int t;

  if (*L>*R) { t = *L; *L = *R; *R = t; }
  if (*B>*T) { t = *B; *B = *T; *T = t; }

  if (   (*R < devClipL)
      || (*L > devClipR)
      || (*T < devClipB)
      || (*B > devClipT)
     )
   return (-1); /* invisible */

  if (*L < devClipL) *L = devClipL;
  if (*B < devClipB) *B = devClipB;
  if (*R > devClipR) *R = devClipR;
  if (*T > devClipT) *T = devClipT;

  return (0);  /* visible - as modified */
 }
