/*
  File: 3D.h
  Author: K.R. Sloan
  Last Modified: 17 March 1989
  Purpose: definitions for a 3D extension to the Simple Graphics Package
 */

#include "SGP.h"

typedef struct P3D { double  x,  y,  z; } PointType3D;
typedef struct V3D { double dx, dy, dz; } VectorType3D;

extern int ClipLineHither();    /* int ClipLineHither(Point1, Point2)
                                    PointType3D *Point1, *Point2;       */

extern VectorType3D Cross3D(); /* Cross3D(a, b)
                                  VectorType3D a, b; */
extern double Dot3D();         /* Dot3D(a, b)
                                   VectorType3D a, b; */
extern void Normalize3D();     /* Normalize3D(V)  
                                   VectorType3D *V;   */
extern void Camera3D();       /* Camera3D(EyePoint, OpticalAxis, Up)
                                  PointType3D EyePoint;
                                  VectorType3D OpticalAxis, Up; */
extern void Lens3D();         /* Lens3D(FocalLength)
                                  double FocalLength; */
extern void SetHither();      /* SetHither(hither)
                                  double hither; */
extern void GetCamera3D();    /* GetCamera3D(EyePoint, OpticalAxis, Up)
                                  PointType3D *EyePoint;
                                  VectorType3D *OpticalAxis, *Up; */
extern void GetLens3D();      /* GetLens3D(FocalLength)
                                  double *FocalLength;          */
extern void GetHither();      /* GetHither(hither)
                                  double *hither;               */
extern void WorldToViewBox3D();
                              /* WorldToViewBox3D(World, Viewbox)
                                  PointType3D World;
                                  PointType3D *ViewBox;                    */ 
extern void World3DTosgpWorld();
                              /* WorldToScreen3D(World3D, sgpWorld)
                                   PointType3D World3D;
                                   sgpPointType *sgpWorld;                 */
extern void Point3D();        /* Point3D(Point)
                                   PointType3D Point;                      */
extern void Line3D();         /* Line3D(Point1, Point2)
                                   PointType3D Point1, Point2;             */
extern void ShadeTriangle3D();/* ShadeTriangle3D(Points, Colors)
                                   PointType3D Points[3],
                                   sgpColorType Colors[3];                 */
extern void SolidTriangle3D();    /* Triangle3D(Points)
                                   PointType3D Points[3];                 */
