/*
  File: 2D.h
  Authors: C.A. Curcio
           K.R. Sloan
  Last Modified: 18 November 1987
  Purpose: a set of procedures for two-dimensional transformations,
           implemented via 3x3 matrixes.
 */

/*
  The following routines support 3-dimensional homogeneous coordinate
  transforms (for doing actual 2D transforms--see Newman & Sproull,
  "Principles of interactive computer graphics". 
 */

typedef double TransformType3D [3][3];

/*
  Project implements  [x',y', 1.0] = [x, y, 1.0] T
 */

extern void Project ();          /* Project (x, y, T)
                                     double *x, *y;
                                     TransformType3D T;                 */
 
/* Identity makes T the identity transform matrix. */

extern void Identity();          /* Identity (T)
                                     TransformType3D T;                 */

/*
  The following routines change the current transformation matrix
  T by composing it with the appropriate new transform M to TM = T'.
  First, the compose and copy transforms.
 */

extern void Compose();           /* Compose (T0, T1, T2)
                                     TransformType3D T0, T1, T2;       */
extern void Copy();              /* Copy (T0, T1)
                                     TransformType3D T0, T1;           */

 /* Now the 2D manipulation routines */
 
extern void RotateZ();           /* RotateZ (angle, T)
                                     double angle;
                                     TransformType3D T;                */
extern void Translate();         /* Translate (x, y, T)
                                     double x, y;
                                     TransformType3D T;                */
extern void Scale();             /* Scale (s, T)
                                     double s;
                                     TransformType3D T;                */
 
extern void Similar();           /* Similar (x11, y11, x12, y12,
                                             x21, y21, x22, y22, T)    
                                     double x11, y11, x12, y12,
                                            x21, y21, x22, y22;
                                     TransformType3D T;                */

