/*
 * tif2rast/tifdump -- convert TIFF to SunRaster
 *
 * written by:
 * William W.C. Wu       wu@cs.buffalo.edu wu@sunybcs.bitnet
 *
 * Copyright (C) 1989 by the author.
 * Permission is granted to copy and distribute this program
 * without charge, provided this copyright notice is included
 * in the copy.
 * This Software is distributed on an as-is basis. There will be
 * ABSOLUTELY NO WARRANTY for any part of this software to work
 * correct. In no case will the author be liable to you for damages
 * caused by the usage of this software.
 */

#include <rasterfile.h>
#include <stdio.h>
#include "defs.h"
#include "tif.h"

struct rasterfile ras;

genrast(filename, picts)
char    *filename;
PICTURE *picts;
{
	int i, j, pad, nbr, nbits;
	int iw, ih;
	char *p;

	iw = picts[0].image.imWidth;
	ih = picts[0].image.imLength;
	nbits = picts[0].image.bitsPerSample;

	switch (nbits) {
	case 1 :
	  nbr = (iw-1)/8 + 1;
	  if ((nbr%2)==0)
	    pad = 0;
	  else
	    pad = 1;
	  ras.ras_magic = RAS_MAGIC;
	  ras.ras_width = iw;
	  ras.ras_height = ih;
	  ras.ras_depth = 1;
	  ras.ras_length = (nbr+pad)*ih;
	  ras.ras_type = RT_STANDARD;
	  ras.ras_maptype = RMT_NONE;
	  ras.ras_maplength = 0;
	  fwrite((char *) &ras,sizeof(struct rasterfile),1,stdout);

	  p = picts[0].image.strips[0].data;
	  for (j=0; j<ih; j++) {
	    for (i=0; i<nbr; i++) {
	      putchar(*p);
	      p++;
	    }
	    for (i=0; i<pad; i++)
	      putchar(0);
	  }
	  break;
	case 4 :
	case 8 :
	  nbr = iw;
	  if ((nbr%2)==0)
	    pad = 0;
	  else
	    pad = 1;
	  ras.ras_magic = RAS_MAGIC;
	  ras.ras_width = iw;
	  ras.ras_height = ih;
	  ras.ras_depth = 8;
	  ras.ras_length = (nbr+pad)*ih;
	  ras.ras_type = RT_STANDARD;
	  ras.ras_maptype = RMT_EQUAL_RGB;
	  if (nbits == 4) ras.ras_maplength = 48;
	  else           
	    ras.ras_maplength = 768;
	  fwrite((char *) &ras,sizeof(struct rasterfile),1,stdout);

	  if (nbits == 4) {
	    for (i=0; i<16; i++)    putchar((i*255)/15);
	    for (i=0; i<16; i++)    putchar((i*255)/15);
	    for (i=0; i<16; i++)    putchar((i*255)/15);
	  } 
	  else {
	    for (i=0; i<256; i++)   putchar(i);
	    for (i=0; i<256; i++)   putchar(i);
	    for (i=0; i<256; i++)   putchar(i);
	  }
	  p = picts[0].image.strips[0].data;
	  nbr += pad;
	  if (nbits == 4) nbr /= 2;
	  for (j=0; j<ih; j++) {
	    for (i=0; i<nbr; i++) {
	      if (nbits == 4) {
		putchar((*p >> 4) & 0x0f);
		putchar(*p & 0x0f);
	      }
	      else 
		putchar(*p);
	      p++;
	    }
	  }
	  break;
	default:
	  fprintf(stderr, "Sorry, unsupported bits_per_sample: %d\n", nbits);
	  exit(1);
	}
}


