;;; sun-eos-menu.el --- Implements the XEmacs/SPARCworks menubar

;; Copyright (C) 13 Jun 1995  Sun Microsystems, Inc.

;; Maintainer:	Eduardo Pelegri-Llopart <eduardo.pelegri-llopart@Eng.Sun.COM>
;; Author:      Eduardo Pelegri-Llopart <eduardo.pelegri-llopart@Eng.Sun.COM>
;; Version:	1.16
;; Header:	@(#) sun-eos-menubar.el: v1.16 95/06/15 19:02:12

;; Keywords:	SPARCworks EOS Era on SPARCworks menubar

;;; Commentary:
;; This file contains functions that populate a SPARCworks menu
;; Please send feedback to eduardo.pelegri-llopart@eng.sun.com

;;; Code:

(require 'eos-common "sun-eos-common")

(defun eos::toggle-sbrowser-selected-frame ()
  ;; Toggle whether this frame is selected for SBrowser
  (interactive)
  (if (equal eos::sbrowser-frame (selected-frame))
      (eos::select-sbrowser-frame nil)
    (eos::select-sbrowser-frame (selected-frame)))
  )

(defun eos::toggle-debugger-selected-frame ()
  ;; Toggle whether this frame is selected for Debugger
  (interactive)
  (if (equal eos::debugger-frame (selected-frame))
      (eos::select-debugger-frame nil)
    (eos::select-debugger-frame (selected-frame)))
  )

(defvar eos::long-menu
  '(
    ["Read and Execute a Dbx Command" eos::dbx-cmd (not (eq eos::key-mode 'none))]
    ["Run" eos::run (not (eq eos::key-mode 'none))]
    ["Fix" eos::fix (not (eq eos::key-mode 'none))]
    "-----"
    ["Print" eos::print (not (eq eos::key-mode 'none))]
    ["Print *" eos::print* (not (eq eos::key-mode 'none))]
    ["Dismiss Print" eos::dismiss-print-frame (not (eq eos::key-mode 'none))]
    "-----"
    ["Continue" eos::cont (not (eq eos::key-mode 'none))]
    ["Stop" eos::stop-at (not (eq eos::key-mode 'none))]
    ["Clear" eos::clear-at (not (eq eos::key-mode 'none))]
    ["Next" eos::next (not (eq eos::key-mode 'none))]
    ["Step" eos::step (not (eq eos::key-mode 'none))]
    ["Step Up" eos::step-up (not (eq eos::key-mode 'none))]
    ["Continue To" eos::cont-to (not (eq eos::key-mode 'none))]
    "-----"
    ["Stack Up" eos::up (not (eq eos::key-mode 'none))]
    ["Stack Down" eos::down (not (eq eos::key-mode 'none))]
    "-----"
    ("Start Tool and Enable Frame"
     ["Debugger" eos::start-debugger t]
     ["Dbx" eos::start-dbx t]
     ["SBrowser" eos::start-sbrowser t]
    )
    "-----"
    ["Enable Frame for SBrowser"
     eos::toggle-sbrowser-selected-frame
     :style toggle
     :selected (equal eos::sbrowser-frame
		      (selected-frame))]
    ["Enable Frame for Debugger and Dbx"
     eos::toggle-debugger-selected-frame
     :style toggle
     :selected (equal eos::debugger-frame
		      (selected-frame))]
    "-----"
    ["News..." eos::sw-news t]
    )
  )

(defvar eos::short-menu
  '(
    ("Start Tool and Enable Frame"
     ["Debugger" eos::start-debugger t]
     ["Dbx" eos::start-dbx t]
     ["SBrowser" eos::start-sbrowser t]
    )
    "-----"
    ["Enable Frame for SBrowser"
     eos::toggle-sbrowser-selected-frame
     :style toggle
     :selected (equal eos::sbrowser-frame
		      (selected-frame))]
    ["Enable Frame for Debugger and Dbx"
     eos::toggle-debugger-selected-frame
     :style toggle
     :selected (equal eos::debugger-frame
		      (selected-frame))]
    "-----"
    ["News..." eos::sw-news t]
    )
  )

(defun eos::menubar-startup ()
  ;; Actions to do at startup for eos-menubar.el
  (if (and (eq (device-type (selected-device)) 'x)
	   (or (not (local-variable-p 'current-menubar (current-buffer)))
	       (yes-or-no-p
		"SPARCworks menu will be local (menubar is buffer-local); proceed?")))
      (progn
	(add-menu-button '("Help") ["SPARCworks..." eos::sw-intro t])
	(add-submenu nil
		     (append '("SPARCworks") (copy-tree eos::short-menu))
		     "VC"
		     )
	)))

;;
;; Insertion of text with a font
;;

(defun eos::insert-italics (a-string)
  (eos::insert-with-font a-string 'italic))

(defun eos::insert-bold (a-string)
  (eos::insert-with-font a-string 'bold))

(defun eos::insert-with-font (a-string a-font)
  (interactive "")
  (let (a b ext)
    (setq a (point))
    (insert a-string)
    (setq b (point))
    (setq ext (make-extent a b))
    (set-extent-face ext (find-face a-font))
    ))

;;
;; Generic insert code
;;

(defun eos::insert (s)
  (let ((len (length s))
	(pos 0)
	(newpos 0)
	(state 'normal))
    (while (< pos len)
      (setq newpos (string-match "#[bnir]" s pos))
      (if (and newpos (> newpos pos))
	  (progn
	    (cond ((equal (aref s (+ newpos 1)) ?b) ; bold
		   (if (equal state 'normal)
		       (progn
			 (insert (substring s pos newpos))
			 (setq state 'bold))
		     (error "found bold when not in normal")))
		  ((equal (aref s (+ newpos 1)) ?r) ; red
		   (if (equal state 'normal)
		       (progn
			 (insert (substring s pos newpos))
			 (setq state 'red))
		     (error "found red when not in normal")))
		  ((equal (aref s (+ newpos 1)) ?i) ; italics
		   (if (equal state 'normal)
		       (progn
			 (insert (substring s pos newpos))
			 (setq state 'italics))
		     (error "found italics when not in normal")))
		  ((equal (aref s (+ newpos 1)) ?n) ; normal
		   (cond ((equal state 'italics)
			  (eos::insert-italics (substring s pos newpos))
			  (setq state 'normal))
			 ((equal state 'bold)
			  (eos::insert-bold (substring s pos newpos))
			  (setq state 'normal))
			 ((equal state 'normal)
			  (error "found normal when in normal"))))
		  (t
		   (error "internal error"))
		  )
	    (setq pos (+ newpos 2))
	    )
	(if (equal state 'normal)
	    (progn
	      (insert (substring s pos))
	      (setq pos len))
	  (error "eos::insert with unclosed special font"))
	))
    ))

;;
;; Introduction File
;;

(defun eos::sw-intro ()
  "Generate an intro buffer."
  (interactive)
  (let ((buffer1 (get-buffer-create " *SPARCworks Intro*"))
	)
    (switch-to-buffer buffer1)
    (setq buffer-read-only nil)
    (delete-region (point-min) (point-max))
    (eos::insert "
		#bSPARCworks Editor Integration#n
	    Eos is copyright (c) 1995 by Sun Microsystems.

#bIntroduction (to Eos 1.5)#n

#iSPARCworks#n is a set of integrated programming tools from SunSoft that
support the program development cycle. #iXEmacs#n is a version of the Emacs
editor that includes interfaces to the selection service and to the #iToolTalk#n
service.  The #iEos#n package uses these two interfaces to provide a simple yet
useful editor integration with three SPARCworks tools: the #iSourceBrowser#n,
the #iDebugger#n and #iDbx#n.

When using Eos, the SPARCworks tools will display their sources in an
XEmacs frame.  The user can then interact with the XEmacs frame in a way
very similar to how the source panes of the SW tools were used.  The
user can also start Dbx and request that sources be shown in XEmacs. 

#bNOTE#n: Only SW3.0.1 and later releases are supported.

#bSimple Startup#n

 (1) Start XEmacs
 (2) Load \"eos.el\". This will add a SPARCworks submenu to the menubar
 (3) On some XEmacs Frame use the SPARCworks submenu and start the
desired tool and simultaneously enable that frame to display sources.

Step (2) might not be needed if Eos is preloaded to your XEmacs binary.
After Step (3) the toolbar for the enabled frame will change.

From this point on, the enabled XEmacs frame behaves as the source
display for the SPARCworks tool.  For instance, a browser query can be
performed by selecting some text anywhere and then clicking on the
query button on the SBrowser tool; the source for the first match will
appear in the XEmacs frame, together with a glyph showing the match.

The Debugger and Dbx can also be driven from XEmacs.  Most frequently
this will be done using the ToolBar; thus, to set a breakpoint at some
line, select a position in that line and then click on the toolbar
icon with the stop with the arrow inside.  The user can also select the
keyboard tool icon on XEmacs and type a Dbx command to the prompt.

#bManual Startup#n

Tool startup and frame enabling can also be done independently.
The tools (Source Browser, Debugger, and Dbx) have to be started
with the \"-editor\" option.  The XEmacs frame can be enabled
manually.  For Debugger and Dbx, note that the #idebug#n command
has to be issued after having enable some frame for displaying
sources.

#bDetails#n

#iFrame Enabling#n

At any given time there can be at most one frame enabled to display
Source Browser sources, and at most one frame enabled to display
Debugger and Dbx sources.  The same XEmacs frame can be used for both
types of sources.  If no frames are enabled for a given tool, the
editor integration for that tool is disabled.

Frames that are enabled have their own toolbar.

#iA Visual Data Inspector in XEmacs#n

Users that choose to drive the debugger from XEmacs also have
available a #ivery simple#n but fast visual data inspector.  The results
of #iprint#n and #iprint*#n commands are formatted into an XEmacs
buffer and presented into a separate frame.  This frame is mapped and
unmapped so that, except for the first time, it appears quickly.

#iEos Buffers#n

Eos uses a buffer to log the interaction of debugger commands sent
from XEmacs.  These commands are stored in a buffer with name
#i\"*Eos Debugger Log*\"#n.  The user should consider this buffer as a
read-only buffer.

When starting dbx as a subprocess, a buffer will be created to
interact with dbx.  The name of this buffer depends on whether
dbx is given an argument at start time; if not the name is #i\"*Eos dbx*'\"#n.

The Eos print commands use a buffer with name #i\"*Eos Print Output*\"#n.

#iKey Bindings#n

There is a way to interact with Debugger/Dbx using key bindings;
this mechanism is not officially supported in 1.5, but it will likely
be supported in the time-frame of XEmacs 19.13 which will have
improved TTY support.  To activate key bindings, evaluate
(eos::set-key-mode 'prefix) or (eos::set-key-mode 'function).

#iTTY Support#n

Eos 1.5 supports dbx for tty (and xterm and commandtool).  Eos
requires a ToolTalk communication, the following steps can be used
to start one

 (0) Start a ToolTalk session, and a shell so that all processes
started from this shell will use the new TT session.  Do this by
executing \"ttsession -c /bin/csh\" - or whatever shell you use
 (1) In the resulting shell, start XEmacs.
 (2) Load \"eos.el\" if it is not preloaded.
 (3) On the only XEmacs Frame (a tty frame) start dbx and select the
frame by invoking the command eos::start-dbx.

From this point on, dbx will use this tty frame to show its sources.
The introduction and news messages can be generated using the commands
eos::sw-intro and eos::sw-news.  You can interact with the dbx subprocess
by typing to its associated input buffer, using some Eos key bindings
(see above) or using the gud.el key bindings.

Tty support is not an official part of Eos, but feedback is welcome, and
bugs will be fixed as time allows.

#iRestrictions#n

The current version of #iEos#n can only interact with a single instance
of each of SourceBrowser and Debugger.

#iEos#n cannot send commands to the Debugger until after the Debugger
has loaded a program.

#bFeedback#n

You are encouraged to send us feedback via the Comments button in
the About Box of either SPARCworks tool, or directly to
eos-comments@cs.uiuc.edu.

#bEnjoy.#n")
   (setq buffer-read-only t)
   (goto-char (point-min))
   (view-mode nil 'kill-buffer)		;; assume the new view-less
   ))

;;
;; Cheat Sheets for keyboard mappings
;;
;; This depends on the mapping being used!
;;

(defun eos::sw-cheat-sheet ()
  "Generate buffer that has a description of the key maps that can be
printed, cut and then taped somewhere (like on the keyboard or on your
monitor).  This is particularly useful for the function keys"
  (interactive)
  (let ((buffer1 (get-buffer-create " *Cheat Sheets*"))
	)
    (switch-to-buffer buffer1)
    (setq buffer-read-only nil)
    (delete-region (point-min) (point-max))
    (eos::insert "
		#bCheat Sheets for Eos#n

This buffer has a description of the key maps that can be printed, cut
and then taped somewhere (like on the keyboard or on your monitor).
This is particularly useful for the function keys since their numbers
don't any particular mnemonic value.


#bWhen using function keys#n #i[Options->SPARCworks->Use Function Keys]#n

----------------------------------------

F6      F7        F8             F9

Do      Print     Cont    ----   Next
Run     Print*    Stop   <Ctrl>  Step
Fix     Dismiss   Clear  <Shft>  Step Up


----------------------------------------

#bWhen using prefix map#n #i[Options->SPARCworks->Use C-c d Prefix Map]#n

----------------------------------------
Basic prefix: C-c d


	Do	 %
	Run	 r
	Fix	 f

	Print	 p
	Print*	 C-p

	Cont	 c
	Stop	 b (for breakpoint)
	Clear	 C-b

	Next	 n
	Step	 s
	Step up  C-s

	Up       u
	Down     d
----------------------------------------

")
   (setq buffer-read-only t)
   (goto-char (point-min))
   (view-mode nil 'kill-buffer)		;; assume the new view-less
   ))

;;
;; News files
;;

(defun eos::sw-news ()
  "Generate a News buffer."
  (interactive)
  (let ((buffer1 (get-buffer-create " *Eos News*"))
	)
    (switch-to-buffer buffer1)
    (setq buffer-read-only nil)
    (delete-region (point-min) (point-max))
    (eos::insert "
		#bEos News#n

See the #iHelp#n top-level menu for additional information on the
SPARCworks lightweight editor integration (Eos).  The current version
of Eos is available as the contents of the variable eos::version.

#bversion 1.5 beta 6#n

	Support for 19.12.  Works on TTYs. Uses real ToolBar.
	Toolbars for debugger & content inspector are frame-local.
	Better icons and glyphs.  Support for (load-library \"eos\").
	Ease-of-use: startup for tools.
	Icon files are now defined \"in-line\" to simplify administration.

	Removed the following to simplify use:
	 - Textual toolbar (from 1.4).
	 - Option submenu to add keymaps for debugger use.
	 - Popup menu.
	 - Any pretenses to support SW3.0; use SW3.0.1 instead.

#bversion 1.4.1#n

	Added eos::add-button interface.

#bversion 1.4#n

	Added toolbar like in dbxtool.  Toolbar uses echo-help to show
	meaning of buttons, (setq inhibit-help-echo t) if you don't
	want it.

	Selection now remains after \"print\"-like commands.  Now it
	is possible to have the	*debugger* buffer in the frame selected
	for displaying debugged	sources.

	Added a command to relayout debugger buffers so they show in
	a layout similar to that of dbxtool.

#bversion 1.3#n

	Provided popup-menu bindings for those debugger actions
	that operate on the contents of the selection or its position;
	selectable via options.

	The *debugger* buffer now support M-p and M-n.

#bversion 1.2#n

	Better support for interactions via *debugger* buffer and directly
	using a prefix map and function keys.

	Converted to use new toggle and radio menus, reorganizing
	SPARCworks menu to factor out help and options into submenus,
	which are now available under the Options and Help top-level menus.

#bversion 1.1#n

	Some internal cleanup.

	Eos now provides basic machinery to drive the debugger
	engine directly using ToolTalk messages.  This feature is
	not yet very well polished. You can try using it at your own risk,
	or await for release 1.2 (soon to come) that will provide a better
	interface and improved functionality, as well as documentation
	for the interface.

#bversion 1.0#n

	First widely available release.  Supports simple #iselect and click#n model.

#bPossible Future Enhancements#n

* Add a \"peek-in-source\" mechanism to show the values of
  expressions in the sources.

* The comint package should be generalized to allow for TT-based
  interpreters and it should be used in Eos.

* Key & popup bindings should probably be a minor mode (currently
  it conflicts with cc-mode).

* Should support locking a print frame to force new print frames.  Also,
  should allow for following fields in print frames.


#bFeedback#n

	Send feedback to #ieos-comments@cs.uiuc.edu#n")
   (setq buffer-read-only t)
   (goto-char (point-min))
   (view-mode nil 'kill-buffer)		;; assume the new view-less
   ))

(provide 'eos-menubar)

;;; sun-eos-debugger.el ends here
