/* External client widget internal header file.
   Copyright (C) 1993, 1994 Sun Microsystems, Inc.

This file is part of XEmacs.

XEmacs is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

XEmacs is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with XEmacs; see the file COPYING.  If not, write to the Free
Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Synched up with: Not in FSF. */

/* Written by Ben Wing. */

#ifndef _ExternalClientP_h
#define _ExternalClientP_h

#include "ExternalClient.h"
#ifdef EXTW_USES_MOTIF
#include <Xm/PrimitiveP.h>
#endif

typedef struct {		/* new fields for ExternalClient class */
   int dummy;
} ExternalClientClassPart;

typedef struct _ExternalClientClassRec {	/* full class record declaration */
    CoreClassPart core_class;
#ifdef EXTW_USES_MOTIF
    XmPrimitiveClassPart primitive_class;
#endif
    ExternalClientClassPart externalClient_class;
} ExternalClientClassRec;

typedef struct {		/* new fields for ExternalClient widget */
    Bool dead_shell;		/* is the shell dead? */
    unsigned long shell_timeout;/* how long to wait for shell's response */
    int shell_ready;		/* is the shell ready? */
    Window event_window;
    long event_mask;
    Bool has_focus;
    char *emacs_procid;         
    XtCallbackList shell_ready_callback;
    String shell_name;
    Bool use_tooltalk;
} ExternalClientPart;

typedef struct _ExternalClientRec {	/* full instance record */
    CorePart core;
#ifdef EXTW_USES_MOTIF
    XmPrimitivePart primitive;
#endif
    ExternalClientPart externalClient;
} ExternalClientRec;

extern ExternalClientClassRec externalClientClassRec;	 /* class pointer */

#endif /* _ExternalClientP_h */
