;;; ucs-hw-fw.el --- UCS table of Halfwidth and Fullwidth Forms

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE,
;;           Halfwidth and Fullwidth Forms

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

(require 'ucs-util)

(ucs-set-char #xFF01 ?$(C#!(B) ; KS0-C-2321
(ucs-set-char #xFF01 ?$(A#!(B) ; GB0-A-2321
(ucs-set-char #xFF01 ?$(G!*(B) ; C01-G-212A
(ucs-set-char #xFF01 ?$(@!*(B) ; J78-@-212A
(ucs-set-char #xFF01 ?$(B!*(B) ; J83-B-212A

(ucs-set-char #xFF02 ?$(C#"(B) ; KS0-C-2322
(ucs-set-char #xFF02 ?$(A#"(B) ; GB0-A-2322

(ucs-set-char #xFF03 ?$(G!l(B) ; C01-G-216C
(ucs-set-char #xFF03 ?$(C##(B) ; KS0-C-2323
(ucs-set-char #xFF03 ?$(A##(B) ; GB0-A-2323
(ucs-set-char #xFF03 ?$(@!t(B) ; J78-@-2174
(ucs-set-char #xFF03 ?$(B!t(B) ; J83-B-2174

(ucs-set-char #xFF04 ?$(C#$(B) ; KS0-C-2324
(ucs-set-char #xFF04 ?$(G"c(B) ; C01-G-2263
(ucs-set-char #xFF04 ?$(A!g(B) ; GB0-A-2167
(ucs-set-char #xFF04 ?$(@!p(B) ; J78-@-2170
(ucs-set-char #xFF04 ?$(B!p(B) ; J83-B-2170

(ucs-set-char #xFF05 ?$(G"h(B) ; C01-G-2268
(ucs-set-char #xFF05 ?$(C#%(B) ; KS0-C-2325
(ucs-set-char #xFF05 ?$(A#%(B) ; GB0-A-2325
(ucs-set-char #xFF05 ?$(@!s(B) ; J78-@-2173
(ucs-set-char #xFF05 ?$(B!s(B) ; J83-B-2173

(ucs-set-char #xFF06 ?$(G!m(B) ; C01-G-216D
(ucs-set-char #xFF06 ?$(C#&(B) ; KS0-C-2326
(ucs-set-char #xFF06 ?$(A#&(B) ; GB0-A-2326
(ucs-set-char #xFF06 ?$(@!u(B) ; J78-@-2175
(ucs-set-char #xFF06 ?$(B!u(B) ; J83-B-2175

(ucs-set-char #xFF07 ?$(C#'(B) ; KS0-C-2327
(ucs-set-char #xFF07 ?$(A#'(B) ; GB0-A-2327

(ucs-set-char #xFF08 ?$(G!>(B) ; C01-G-213E
(ucs-set-char #xFF08 ?$(C#((B) ; KS0-C-2328
(ucs-set-char #xFF08 ?$(A#((B) ; GB0-A-2328
(ucs-set-char #xFF08 ?$(@!J(B) ; J78-@-214A
(ucs-set-char #xFF08 ?$(B!J(B) ; J83-B-214A

(ucs-set-char #xFF09 ?$(G!?(B) ; C01-G-213F
(ucs-set-char #xFF09 ?$(C#)(B) ; KS0-C-2329
(ucs-set-char #xFF09 ?$(A#)(B) ; GB0-A-2329
(ucs-set-char #xFF09 ?$(@!K(B) ; J78-@-214B
(ucs-set-char #xFF09 ?$(B!K(B) ; J83-B-214B

(ucs-set-char #xFF0A ?$(C#*(B) ; KS0-C-232A
(ucs-set-char #xFF0A ?$(A#*(B) ; GB0-A-232A
(ucs-set-char #xFF0A ?$(@!v(B) ; J78-@-2176
(ucs-set-char #xFF0A ?$(B!v(B) ; J83-B-2176

(ucs-set-char #xFF0B ?$(G"0(B) ; C01-G-2230
(ucs-set-char #xFF0B ?$(C#+(B) ; KS0-C-232B
(ucs-set-char #xFF0B ?$(A#+(B) ; GB0-A-232B
(ucs-set-char #xFF0B ?$(@!\(B) ; J78-@-215C
(ucs-set-char #xFF0B ?$(B!\(B) ; J83-B-215C

(ucs-set-char #xFF0C ?$(G!"(B) ; C01-G-2122
(ucs-set-char #xFF0C ?$(C#,(B) ; KS0-C-232C
(ucs-set-char #xFF0C ?$(A#,(B) ; GB0-A-232C
(ucs-set-char #xFF0C ?$(@!$(B) ; J78-@-2124
(ucs-set-char #xFF0C ?$(B!$(B) ; J83-B-2124

(ucs-set-char #xFF0D ?$(G"1(B) ; C01-G-2231
(ucs-set-char #xFF0D ?$(C#-(B) ; KS0-C-232D
(ucs-set-char #xFF0D ?$(A#-(B) ; GB0-A-232D

;; FULLWIDTH FULL STOP;<wide> 002E
(ucs-set-char #xFF0E ?$(C#.(B) ; KS0-C-232E
(ucs-set-char #xFF0E ?$(A#.(B) ; GB0-A-232E
(ucs-set-char #xFF0E ?$(G!%(B) ; C01-G-2125
(ucs-set-char #xFF0E ?$(@!%(B) ; J78-@-2125
(ucs-set-char #xFF0E ?$(B!%(B) ; J83-B-2125

(ucs-set-char #xFF0F ?$(C#/(B) ; KS0-C-232F
(ucs-set-char #xFF0F ?$(A#/(B) ; GB0-A-232F
(ucs-set-char #xFF0F ?$(@!?(B) ; J78-@-213F
(ucs-set-char #xFF0F ?$(B!?(B) ; J83-B-213F

(ucs-set-char #xFF10 ?$(G$!(B) ; C01-G-2421
(ucs-set-char #xFF10 ?$(C#0(B) ; KS0-C-2330
(ucs-set-char #xFF10 ?$(@#0(B) ; J78-@-2330
(ucs-set-char #xFF10 ?$(A#0(B) ; GB0-A-2330
(ucs-set-char #xFF10 ?$(B#0(B) ; J83-B-2330

(ucs-set-char #xFF11 ?$(G$"(B) ; C01-G-2422
(ucs-set-char #xFF11 ?$(C#1(B) ; KS0-C-2331
(ucs-set-char #xFF11 ?$(@#1(B) ; J78-@-2331
(ucs-set-char #xFF11 ?$(A#1(B) ; GB0-A-2331
(ucs-set-char #xFF11 ?$(B#1(B) ; J83-B-2331

(ucs-set-char #xFF12 ?$(G$#(B) ; C01-G-2423
(ucs-set-char #xFF12 ?$(C#2(B) ; KS0-C-2332
(ucs-set-char #xFF12 ?$(@#2(B) ; J78-@-2332
(ucs-set-char #xFF12 ?$(A#2(B) ; GB0-A-2332
(ucs-set-char #xFF12 ?$(B#2(B) ; J83-B-2332

(ucs-set-char #xFF13 ?$(G$$(B) ; C01-G-2424
(ucs-set-char #xFF13 ?$(C#3(B) ; KS0-C-2333
(ucs-set-char #xFF13 ?$(@#3(B) ; J78-@-2333
(ucs-set-char #xFF13 ?$(A#3(B) ; GB0-A-2333
(ucs-set-char #xFF13 ?$(B#3(B) ; J83-B-2333

(ucs-set-char #xFF14 ?$(G$%(B) ; C01-G-2425
(ucs-set-char #xFF14 ?$(C#4(B) ; KS0-C-2334
(ucs-set-char #xFF14 ?$(@#4(B) ; J78-@-2334
(ucs-set-char #xFF14 ?$(A#4(B) ; GB0-A-2334
(ucs-set-char #xFF14 ?$(B#4(B) ; J83-B-2334

(ucs-set-char #xFF15 ?$(G$&(B) ; C01-G-2426
(ucs-set-char #xFF15 ?$(C#5(B) ; KS0-C-2335
(ucs-set-char #xFF15 ?$(@#5(B) ; J78-@-2335
(ucs-set-char #xFF15 ?$(A#5(B) ; GB0-A-2335
(ucs-set-char #xFF15 ?$(B#5(B) ; J83-B-2335

(ucs-set-char #xFF16 ?$(G$'(B) ; C01-G-2427
(ucs-set-char #xFF16 ?$(C#6(B) ; KS0-C-2336
(ucs-set-char #xFF16 ?$(@#6(B) ; J78-@-2336
(ucs-set-char #xFF16 ?$(A#6(B) ; GB0-A-2336
(ucs-set-char #xFF16 ?$(B#6(B) ; J83-B-2336

(ucs-set-char #xFF17 ?$(G$((B) ; C01-G-2428
(ucs-set-char #xFF17 ?$(C#7(B) ; KS0-C-2337
(ucs-set-char #xFF17 ?$(@#7(B) ; J78-@-2337
(ucs-set-char #xFF17 ?$(A#7(B) ; GB0-A-2337
(ucs-set-char #xFF17 ?$(B#7(B) ; J83-B-2337

(ucs-set-char #xFF18 ?$(G$)(B) ; C01-G-2429
(ucs-set-char #xFF18 ?$(C#8(B) ; KS0-C-2338
(ucs-set-char #xFF18 ?$(@#8(B) ; J78-@-2338
(ucs-set-char #xFF18 ?$(A#8(B) ; GB0-A-2338
(ucs-set-char #xFF18 ?$(B#8(B) ; J83-B-2338

(ucs-set-char #xFF19 ?$(G$*(B) ; C01-G-242A
(ucs-set-char #xFF19 ?$(C#9(B) ; KS0-C-2339
(ucs-set-char #xFF19 ?$(@#9(B) ; J78-@-2339
(ucs-set-char #xFF19 ?$(A#9(B) ; GB0-A-2339
(ucs-set-char #xFF19 ?$(B#9(B) ; J83-B-2339

(ucs-set-char #xFF1A ?$(G!((B) ; C01-G-2128
(ucs-set-char #xFF1A ?$(C#:(B) ; KS0-C-233A
(ucs-set-char #xFF1A ?$(A#:(B) ; GB0-A-233A
(ucs-set-char #xFF1A ?$(@!'(B) ; J78-@-2127
(ucs-set-char #xFF1A ?$(B!'(B) ; J83-B-2127

(ucs-set-char #xFF1B ?$(G!'(B) ; C01-G-2127
(ucs-set-char #xFF1B ?$(C#;(B) ; KS0-C-233B
(ucs-set-char #xFF1B ?$(A#;(B) ; GB0-A-233B
(ucs-set-char #xFF1B ?$(@!((B) ; J78-@-2128
(ucs-set-char #xFF1B ?$(B!((B) ; J83-B-2128

(ucs-set-char #xFF1C ?$(G"6(B) ; C01-G-2236
(ucs-set-char #xFF1C ?$(C#<(B) ; KS0-C-233C
(ucs-set-char #xFF1C ?$(A#<(B) ; GB0-A-233C
(ucs-set-char #xFF1C ?$(@!c(B) ; J78-@-2163
(ucs-set-char #xFF1C ?$(B!c(B) ; J83-B-2163

(ucs-set-char #xFF1D ?$(G"8(B) ; C01-G-2238
(ucs-set-char #xFF1D ?$(C#=(B) ; KS0-C-233D
(ucs-set-char #xFF1D ?$(A#=(B) ; GB0-A-233D
(ucs-set-char #xFF1D ?$(@!a(B) ; J78-@-2161
(ucs-set-char #xFF1D ?$(B!a(B) ; J83-B-2161

(ucs-set-char #xFF1E ?$(G"7(B) ; C01-G-2237
(ucs-set-char #xFF1E ?$(C#>(B) ; KS0-C-233E
(ucs-set-char #xFF1E ?$(A#>(B) ; GB0-A-233E
(ucs-set-char #xFF1E ?$(@!d(B) ; J78-@-2164
(ucs-set-char #xFF1E ?$(B!d(B) ; J83-B-2164

(ucs-set-char #xFF1F ?$(C#?(B) ; KS0-C-233F
(ucs-set-char #xFF1F ?$(A#?(B) ; GB0-A-233F
(ucs-set-char #xFF1F ?$(G!)(B) ; C01-G-2129
(ucs-set-char #xFF1F ?$(@!)(B) ; J78-@-2129
(ucs-set-char #xFF1F ?$(B!)(B) ; J83-B-2129

(ucs-set-char #xFF20 ?$(G"i(B) ; C01-G-2269
(ucs-set-char #xFF20 ?$(C#@(B) ; KS0-C-2340
(ucs-set-char #xFF20 ?$(A#@(B) ; GB0-A-2340
(ucs-set-char #xFF20 ?$(@!w(B) ; J78-@-2177
(ucs-set-char #xFF20 ?$(B!w(B) ; J83-B-2177

(ucs-set-char #xFF21 ?$(C#A(B) ; KS0-C-2341
(ucs-set-char #xFF21 ?$(G$A(B) ; C01-G-2441
(ucs-set-char #xFF21 ?$(@#A(B) ; J78-@-2341
(ucs-set-char #xFF21 ?$(A#A(B) ; GB0-A-2341
(ucs-set-char #xFF21 ?$(B#A(B) ; J83-B-2341

(ucs-set-char #xFF22 ?$(C#B(B) ; KS0-C-2342
(ucs-set-char #xFF22 ?$(G$B(B) ; C01-G-2442
(ucs-set-char #xFF22 ?$(@#B(B) ; J78-@-2342
(ucs-set-char #xFF22 ?$(A#B(B) ; GB0-A-2342
(ucs-set-char #xFF22 ?$(B#B(B) ; J83-B-2342

(ucs-set-char #xFF23 ?$(C#C(B) ; KS0-C-2343
(ucs-set-char #xFF23 ?$(G$C(B) ; C01-G-2443
(ucs-set-char #xFF23 ?$(@#C(B) ; J78-@-2343
(ucs-set-char #xFF23 ?$(A#C(B) ; GB0-A-2343
(ucs-set-char #xFF23 ?$(B#C(B) ; J83-B-2343

(ucs-set-char #xFF24 ?$(C#D(B) ; KS0-C-2344
(ucs-set-char #xFF24 ?$(G$D(B) ; C01-G-2444
(ucs-set-char #xFF24 ?$(@#D(B) ; J78-@-2344
(ucs-set-char #xFF24 ?$(A#D(B) ; GB0-A-2344
(ucs-set-char #xFF24 ?$(B#D(B) ; J83-B-2344

(ucs-set-char #xFF25 ?$(C#E(B) ; KS0-C-2345
(ucs-set-char #xFF25 ?$(G$E(B) ; C01-G-2445
(ucs-set-char #xFF25 ?$(@#E(B) ; J78-@-2345
(ucs-set-char #xFF25 ?$(A#E(B) ; GB0-A-2345
(ucs-set-char #xFF25 ?$(B#E(B) ; J83-B-2345

(ucs-set-char #xFF26 ?$(C#F(B) ; KS0-C-2346
(ucs-set-char #xFF26 ?$(G$F(B) ; C01-G-2446
(ucs-set-char #xFF26 ?$(@#F(B) ; J78-@-2346
(ucs-set-char #xFF26 ?$(A#F(B) ; GB0-A-2346
(ucs-set-char #xFF26 ?$(B#F(B) ; J83-B-2346

(ucs-set-char #xFF27 ?$(C#G(B) ; KS0-C-2347
(ucs-set-char #xFF27 ?$(G$G(B) ; C01-G-2447
(ucs-set-char #xFF27 ?$(@#G(B) ; J78-@-2347
(ucs-set-char #xFF27 ?$(A#G(B) ; GB0-A-2347
(ucs-set-char #xFF27 ?$(B#G(B) ; J83-B-2347

(ucs-set-char #xFF28 ?$(C#H(B) ; KS0-C-2348
(ucs-set-char #xFF28 ?$(G$H(B) ; C01-G-2448
(ucs-set-char #xFF28 ?$(@#H(B) ; J78-@-2348
(ucs-set-char #xFF28 ?$(A#H(B) ; GB0-A-2348
(ucs-set-char #xFF28 ?$(B#H(B) ; J83-B-2348

(ucs-set-char #xFF29 ?$(C#I(B) ; KS0-C-2349
(ucs-set-char #xFF29 ?$(G$I(B) ; C01-G-2449
(ucs-set-char #xFF29 ?$(@#I(B) ; J78-@-2349
(ucs-set-char #xFF29 ?$(A#I(B) ; GB0-A-2349
(ucs-set-char #xFF29 ?$(B#I(B) ; J83-B-2349

(ucs-set-char #xFF2A ?$(C#J(B) ; KS0-C-234A
(ucs-set-char #xFF2A ?$(G$J(B) ; C01-G-244A
(ucs-set-char #xFF2A ?$(@#J(B) ; J78-@-234A
(ucs-set-char #xFF2A ?$(A#J(B) ; GB0-A-234A
(ucs-set-char #xFF2A ?$(B#J(B) ; J83-B-234A

(ucs-set-char #xFF2B ?$(C#K(B) ; KS0-C-234B
(ucs-set-char #xFF2B ?$(G$K(B) ; C01-G-244B
(ucs-set-char #xFF2B ?$(@#K(B) ; J78-@-234B
(ucs-set-char #xFF2B ?$(A#K(B) ; GB0-A-234B
(ucs-set-char #xFF2B ?$(B#K(B) ; J83-B-234B

(ucs-set-char #xFF2C ?$(C#L(B) ; KS0-C-234C
(ucs-set-char #xFF2C ?$(G$L(B) ; C01-G-244C
(ucs-set-char #xFF2C ?$(@#L(B) ; J78-@-234C
(ucs-set-char #xFF2C ?$(A#L(B) ; GB0-A-234C
(ucs-set-char #xFF2C ?$(B#L(B) ; J83-B-234C

(ucs-set-char #xFF2D ?$(C#M(B) ; KS0-C-234D
(ucs-set-char #xFF2D ?$(G$M(B) ; C01-G-244D
(ucs-set-char #xFF2D ?$(@#M(B) ; J78-@-234D
(ucs-set-char #xFF2D ?$(A#M(B) ; GB0-A-234D
(ucs-set-char #xFF2D ?$(B#M(B) ; J83-B-234D

(ucs-set-char #xFF2E ?$(C#N(B) ; KS0-C-234E
(ucs-set-char #xFF2E ?$(G$N(B) ; C01-G-244E
(ucs-set-char #xFF2E ?$(@#N(B) ; J78-@-234E
(ucs-set-char #xFF2E ?$(A#N(B) ; GB0-A-234E
(ucs-set-char #xFF2E ?$(B#N(B) ; J83-B-234E

(ucs-set-char #xFF2F ?$(C#O(B) ; KS0-C-234F
(ucs-set-char #xFF2F ?$(G$O(B) ; C01-G-244F
(ucs-set-char #xFF2F ?$(@#O(B) ; J78-@-234F
(ucs-set-char #xFF2F ?$(A#O(B) ; GB0-A-234F
(ucs-set-char #xFF2F ?$(B#O(B) ; J83-B-234F

(ucs-set-char #xFF30 ?$(C#P(B) ; KS0-C-2350
(ucs-set-char #xFF30 ?$(G$P(B) ; C01-G-2450
(ucs-set-char #xFF30 ?$(@#P(B) ; J78-@-2350
(ucs-set-char #xFF30 ?$(A#P(B) ; GB0-A-2350
(ucs-set-char #xFF30 ?$(B#P(B) ; J83-B-2350

(ucs-set-char #xFF31 ?$(C#Q(B) ; KS0-C-2351
(ucs-set-char #xFF31 ?$(G$Q(B) ; C01-G-2451
(ucs-set-char #xFF31 ?$(@#Q(B) ; J78-@-2351
(ucs-set-char #xFF31 ?$(A#Q(B) ; GB0-A-2351
(ucs-set-char #xFF31 ?$(B#Q(B) ; J83-B-2351

(ucs-set-char #xFF32 ?$(C#R(B) ; KS0-C-2352
(ucs-set-char #xFF32 ?$(G$R(B) ; C01-G-2452
(ucs-set-char #xFF32 ?$(@#R(B) ; J78-@-2352
(ucs-set-char #xFF32 ?$(A#R(B) ; GB0-A-2352
(ucs-set-char #xFF32 ?$(B#R(B) ; J83-B-2352

(ucs-set-char #xFF33 ?$(C#S(B) ; KS0-C-2353
(ucs-set-char #xFF33 ?$(G$S(B) ; C01-G-2453
(ucs-set-char #xFF33 ?$(@#S(B) ; J78-@-2353
(ucs-set-char #xFF33 ?$(A#S(B) ; GB0-A-2353
(ucs-set-char #xFF33 ?$(B#S(B) ; J83-B-2353

(ucs-set-char #xFF34 ?$(C#T(B) ; KS0-C-2354
(ucs-set-char #xFF34 ?$(G$T(B) ; C01-G-2454
(ucs-set-char #xFF34 ?$(@#T(B) ; J78-@-2354
(ucs-set-char #xFF34 ?$(A#T(B) ; GB0-A-2354
(ucs-set-char #xFF34 ?$(B#T(B) ; J83-B-2354

(ucs-set-char #xFF35 ?$(C#U(B) ; KS0-C-2355
(ucs-set-char #xFF35 ?$(G$U(B) ; C01-G-2455
(ucs-set-char #xFF35 ?$(@#U(B) ; J78-@-2355
(ucs-set-char #xFF35 ?$(A#U(B) ; GB0-A-2355
(ucs-set-char #xFF35 ?$(B#U(B) ; J83-B-2355

(ucs-set-char #xFF36 ?$(C#V(B) ; KS0-C-2356
(ucs-set-char #xFF36 ?$(G$V(B) ; C01-G-2456
(ucs-set-char #xFF36 ?$(@#V(B) ; J78-@-2356
(ucs-set-char #xFF36 ?$(A#V(B) ; GB0-A-2356
(ucs-set-char #xFF36 ?$(B#V(B) ; J83-B-2356

(ucs-set-char #xFF37 ?$(C#W(B) ; KS0-C-2357
(ucs-set-char #xFF37 ?$(G$W(B) ; C01-G-2457
(ucs-set-char #xFF37 ?$(@#W(B) ; J78-@-2357
(ucs-set-char #xFF37 ?$(A#W(B) ; GB0-A-2357
(ucs-set-char #xFF37 ?$(B#W(B) ; J83-B-2357

(ucs-set-char #xFF38 ?$(C#X(B) ; KS0-C-2358
(ucs-set-char #xFF38 ?$(G$X(B) ; C01-G-2458
(ucs-set-char #xFF38 ?$(@#X(B) ; J78-@-2358
(ucs-set-char #xFF38 ?$(A#X(B) ; GB0-A-2358
(ucs-set-char #xFF38 ?$(B#X(B) ; J83-B-2358

(ucs-set-char #xFF39 ?$(C#Y(B) ; KS0-C-2359
(ucs-set-char #xFF39 ?$(G$Y(B) ; C01-G-2459
(ucs-set-char #xFF39 ?$(@#Y(B) ; J78-@-2359
(ucs-set-char #xFF39 ?$(A#Y(B) ; GB0-A-2359
(ucs-set-char #xFF39 ?$(B#Y(B) ; J83-B-2359

(ucs-set-char #xFF3A ?$(C#Z(B) ; KS0-C-235A
(ucs-set-char #xFF3A ?$(G$Z(B) ; C01-G-245A
(ucs-set-char #xFF3A ?$(@#Z(B) ; J78-@-235A
(ucs-set-char #xFF3A ?$(A#Z(B) ; GB0-A-235A
(ucs-set-char #xFF3A ?$(B#Z(B) ; J83-B-235A

(ucs-set-char #xFF3B ?$(C#[(B) ; KS0-C-235B
(ucs-set-char #xFF3B ?$(A#[(B) ; GB0-A-235B
(ucs-set-char #xFF3B ?$(@!N(B) ; J78-@-214E
(ucs-set-char #xFF3B ?$(B!N(B) ; J83-B-214E

;; FULLWIDTH REVERSE SOLIDUS;<wide> 005C
(ucs-set-char #xFF3C ?$(C!,(B) ; KS0-C-212C
(ucs-set-char #xFF3C ?$(G"`(B) ; C01-G-2260
(ucs-set-char #xFF3C ?$(A#\(B) ; GB0-A-235C
(ucs-set-char #xFF3C ?$(@!@(B) ; J78-@-2140
(ucs-set-char #xFF3C ?$(B!@(B) ; J83-B-2140

(ucs-set-char #xFF3D ?$(C#](B) ; KS0-C-235D
(ucs-set-char #xFF3D ?$(A#](B) ; GB0-A-235D
(ucs-set-char #xFF3D ?$(@!O(B) ; J78-@-214F
(ucs-set-char #xFF3D ?$(B!O(B) ; J83-B-214F

(ucs-set-char #xFF3E ?$(C#^(B) ; KS0-C-235E
(ucs-set-char #xFF3E ?$(A#^(B) ; GB0-A-235E
(ucs-set-char #xFF3E ?$(@!0(B) ; J78-@-2130
(ucs-set-char #xFF3E ?$(B!0(B) ; J83-B-2130

(ucs-set-char #xFF3F ?$(G"%(B) ; C01-G-2225
(ucs-set-char #xFF3F ?$(C#_(B) ; KS0-C-235F
(ucs-set-char #xFF3F ?$(A#_(B) ; GB0-A-235F
(ucs-set-char #xFF3F ?$(@!2(B) ; J78-@-2132
(ucs-set-char #xFF3F ?$(B!2(B) ; J83-B-2132

;;(ucs-set-char #x005F ?$(G"&(B) ; C01-G-2226

(ucs-set-char #xFF40 ?$(C#`(B) ; KS0-C-2360
(ucs-set-char #xFF40 ?$(A#`(B) ; GB0-A-2360
(ucs-set-char #xFF40 ?$(@!.(B) ; J78-@-212E
(ucs-set-char #xFF40 ?$(B!.(B) ; J83-B-212E

(ucs-set-char #xFF41 ?$(G$[(B) ; C01-G-245B
(ucs-set-char #xFF41 ?$(C#a(B) ; KS0-C-2361
(ucs-set-char #xFF41 ?$(@#a(B) ; J78-@-2361
(ucs-set-char #xFF41 ?$(A#a(B) ; GB0-A-2361
(ucs-set-char #xFF41 ?$(B#a(B) ; J83-B-2361

(ucs-set-char #xFF42 ?$(G$\(B) ; C01-G-245C
(ucs-set-char #xFF42 ?$(C#b(B) ; KS0-C-2362
(ucs-set-char #xFF42 ?$(@#b(B) ; J78-@-2362
(ucs-set-char #xFF42 ?$(A#b(B) ; GB0-A-2362
(ucs-set-char #xFF42 ?$(B#b(B) ; J83-B-2362

(ucs-set-char #xFF43 ?$(G$](B) ; C01-G-245D
(ucs-set-char #xFF43 ?$(C#c(B) ; KS0-C-2363
(ucs-set-char #xFF43 ?$(@#c(B) ; J78-@-2363
(ucs-set-char #xFF43 ?$(A#c(B) ; GB0-A-2363
(ucs-set-char #xFF43 ?$(B#c(B) ; J83-B-2363

(ucs-set-char #xFF44 ?$(G$^(B) ; C01-G-245E
(ucs-set-char #xFF44 ?$(C#d(B) ; KS0-C-2364
(ucs-set-char #xFF44 ?$(@#d(B) ; J78-@-2364
(ucs-set-char #xFF44 ?$(A#d(B) ; GB0-A-2364
(ucs-set-char #xFF44 ?$(B#d(B) ; J83-B-2364

(ucs-set-char #xFF45 ?$(G$_(B) ; C01-G-245F
(ucs-set-char #xFF45 ?$(C#e(B) ; KS0-C-2365
(ucs-set-char #xFF45 ?$(@#e(B) ; J78-@-2365
(ucs-set-char #xFF45 ?$(A#e(B) ; GB0-A-2365
(ucs-set-char #xFF45 ?$(B#e(B) ; J83-B-2365

(ucs-set-char #xFF46 ?$(G$`(B) ; C01-G-2460
(ucs-set-char #xFF46 ?$(C#f(B) ; KS0-C-2366
(ucs-set-char #xFF46 ?$(@#f(B) ; J78-@-2366
(ucs-set-char #xFF46 ?$(A#f(B) ; GB0-A-2366
(ucs-set-char #xFF46 ?$(B#f(B) ; J83-B-2366

(ucs-set-char #xFF47 ?$(G$a(B) ; C01-G-2461
(ucs-set-char #xFF47 ?$(C#g(B) ; KS0-C-2367
(ucs-set-char #xFF47 ?$(@#g(B) ; J78-@-2367
(ucs-set-char #xFF47 ?$(A#g(B) ; GB0-A-2367
(ucs-set-char #xFF47 ?$(B#g(B) ; J83-B-2367

(ucs-set-char #xFF48 ?$(G$b(B) ; C01-G-2462
(ucs-set-char #xFF48 ?$(C#h(B) ; KS0-C-2368
(ucs-set-char #xFF48 ?$(@#h(B) ; J78-@-2368
(ucs-set-char #xFF48 ?$(A#h(B) ; GB0-A-2368
(ucs-set-char #xFF48 ?$(B#h(B) ; J83-B-2368

(ucs-set-char #xFF49 ?$(G$c(B) ; C01-G-2463
(ucs-set-char #xFF49 ?$(C#i(B) ; KS0-C-2369
(ucs-set-char #xFF49 ?$(@#i(B) ; J78-@-2369
(ucs-set-char #xFF49 ?$(A#i(B) ; GB0-A-2369
(ucs-set-char #xFF49 ?$(B#i(B) ; J83-B-2369

(ucs-set-char #xFF4A ?$(G$d(B) ; C01-G-2464
(ucs-set-char #xFF4A ?$(C#j(B) ; KS0-C-236A
(ucs-set-char #xFF4A ?$(@#j(B) ; J78-@-236A
(ucs-set-char #xFF4A ?$(A#j(B) ; GB0-A-236A
(ucs-set-char #xFF4A ?$(B#j(B) ; J83-B-236A

(ucs-set-char #xFF4B ?$(G$e(B) ; C01-G-2465
(ucs-set-char #xFF4B ?$(C#k(B) ; KS0-C-236B
(ucs-set-char #xFF4B ?$(@#k(B) ; J78-@-236B
(ucs-set-char #xFF4B ?$(A#k(B) ; GB0-A-236B
(ucs-set-char #xFF4B ?$(B#k(B) ; J83-B-236B

(ucs-set-char #xFF4C ?$(G$f(B) ; C01-G-2466
(ucs-set-char #xFF4C ?$(C#l(B) ; KS0-C-236C
(ucs-set-char #xFF4C ?$(@#l(B) ; J78-@-236C
(ucs-set-char #xFF4C ?$(A#l(B) ; GB0-A-236C
(ucs-set-char #xFF4C ?$(B#l(B) ; J83-B-236C

(ucs-set-char #xFF4D ?$(G$g(B) ; C01-G-2467
(ucs-set-char #xFF4D ?$(C#m(B) ; KS0-C-236D
(ucs-set-char #xFF4D ?$(@#m(B) ; J78-@-236D
(ucs-set-char #xFF4D ?$(A#m(B) ; GB0-A-236D
(ucs-set-char #xFF4D ?$(B#m(B) ; J83-B-236D

(ucs-set-char #xFF4E ?$(G$h(B) ; C01-G-2468
(ucs-set-char #xFF4E ?$(C#n(B) ; KS0-C-236E
(ucs-set-char #xFF4E ?$(@#n(B) ; J78-@-236E
(ucs-set-char #xFF4E ?$(A#n(B) ; GB0-A-236E
(ucs-set-char #xFF4E ?$(B#n(B) ; J83-B-236E

(ucs-set-char #xFF4F ?$(G$i(B) ; C01-G-2469
(ucs-set-char #xFF4F ?$(C#o(B) ; KS0-C-236F
(ucs-set-char #xFF4F ?$(@#o(B) ; J78-@-236F
(ucs-set-char #xFF4F ?$(A#o(B) ; GB0-A-236F
(ucs-set-char #xFF4F ?$(B#o(B) ; J83-B-236F

(ucs-set-char #xFF50 ?$(G$j(B) ; C01-G-246A
(ucs-set-char #xFF50 ?$(C#p(B) ; KS0-C-2370
(ucs-set-char #xFF50 ?$(@#p(B) ; J78-@-2370
(ucs-set-char #xFF50 ?$(A#p(B) ; GB0-A-2370
(ucs-set-char #xFF50 ?$(B#p(B) ; J83-B-2370

(ucs-set-char #xFF51 ?$(G$k(B) ; C01-G-246B
(ucs-set-char #xFF51 ?$(C#q(B) ; KS0-C-2371
(ucs-set-char #xFF51 ?$(@#q(B) ; J78-@-2371
(ucs-set-char #xFF51 ?$(A#q(B) ; GB0-A-2371
(ucs-set-char #xFF51 ?$(B#q(B) ; J83-B-2371

(ucs-set-char #xFF52 ?$(G$l(B) ; C01-G-246C
(ucs-set-char #xFF52 ?$(C#r(B) ; KS0-C-2372
(ucs-set-char #xFF52 ?$(@#r(B) ; J78-@-2372
(ucs-set-char #xFF52 ?$(A#r(B) ; GB0-A-2372
(ucs-set-char #xFF52 ?$(B#r(B) ; J83-B-2372

(ucs-set-char #xFF53 ?$(G$m(B) ; C01-G-246D
(ucs-set-char #xFF53 ?$(C#s(B) ; KS0-C-2373
(ucs-set-char #xFF53 ?$(@#s(B) ; J78-@-2373
(ucs-set-char #xFF53 ?$(A#s(B) ; GB0-A-2373
(ucs-set-char #xFF53 ?$(B#s(B) ; J83-B-2373

(ucs-set-char #xFF54 ?$(G$n(B) ; C01-G-246E
(ucs-set-char #xFF54 ?$(C#t(B) ; KS0-C-2374
(ucs-set-char #xFF54 ?$(@#t(B) ; J78-@-2374
(ucs-set-char #xFF54 ?$(A#t(B) ; GB0-A-2374
(ucs-set-char #xFF54 ?$(B#t(B) ; J83-B-2374

(ucs-set-char #xFF55 ?$(G$o(B) ; C01-G-246F
(ucs-set-char #xFF55 ?$(C#u(B) ; KS0-C-2375
(ucs-set-char #xFF55 ?$(@#u(B) ; J78-@-2375
(ucs-set-char #xFF55 ?$(A#u(B) ; GB0-A-2375
(ucs-set-char #xFF55 ?$(B#u(B) ; J83-B-2375

(ucs-set-char #xFF56 ?$(G$p(B) ; C01-G-2470
(ucs-set-char #xFF56 ?$(C#v(B) ; KS0-C-2376
(ucs-set-char #xFF56 ?$(@#v(B) ; J78-@-2376
(ucs-set-char #xFF56 ?$(A#v(B) ; GB0-A-2376
(ucs-set-char #xFF56 ?$(B#v(B) ; J83-B-2376

(ucs-set-char #xFF57 ?$(G$q(B) ; C01-G-2471
(ucs-set-char #xFF57 ?$(C#w(B) ; KS0-C-2377
(ucs-set-char #xFF57 ?$(@#w(B) ; J78-@-2377
(ucs-set-char #xFF57 ?$(A#w(B) ; GB0-A-2377
(ucs-set-char #xFF57 ?$(B#w(B) ; J83-B-2377

(ucs-set-char #xFF58 ?$(G$r(B) ; C01-G-2472
(ucs-set-char #xFF58 ?$(C#x(B) ; KS0-C-2378
(ucs-set-char #xFF58 ?$(@#x(B) ; J78-@-2378
(ucs-set-char #xFF58 ?$(A#x(B) ; GB0-A-2378
(ucs-set-char #xFF58 ?$(B#x(B) ; J83-B-2378

(ucs-set-char #xFF59 ?$(G$s(B) ; C01-G-2473
(ucs-set-char #xFF59 ?$(C#y(B) ; KS0-C-2379
(ucs-set-char #xFF59 ?$(@#y(B) ; J78-@-2379
(ucs-set-char #xFF59 ?$(A#y(B) ; GB0-A-2379
(ucs-set-char #xFF59 ?$(B#y(B) ; J83-B-2379

(ucs-set-char #xFF5A ?$(G$t(B) ; C01-G-2474
(ucs-set-char #xFF5A ?$(C#z(B) ; KS0-C-237A
(ucs-set-char #xFF5A ?$(@#z(B) ; J78-@-237A
(ucs-set-char #xFF5A ?$(A#z(B) ; GB0-A-237A
(ucs-set-char #xFF5A ?$(B#z(B) ; J83-B-237A

(ucs-set-char #xFF5B ?$(G!B(B) ; C01-G-2142
(ucs-set-char #xFF5B ?$(C#{(B) ; KS0-C-237B
(ucs-set-char #xFF5B ?$(A#{(B) ; GB0-A-237B
(ucs-set-char #xFF5B ?$(@!P(B) ; J78-@-2150
(ucs-set-char #xFF5B ?$(B!P(B) ; J83-B-2150

(ucs-set-char #xFF5C ?$(G"^(B) ; C01-G-225E
(ucs-set-char #xFF5C ?$(C#|(B) ; KS0-C-237C
(ucs-set-char #xFF5C ?$(A#|(B) ; GB0-A-237C
(ucs-set-char #xFF5C ?$(@!C(B) ; J78-@-2143
(ucs-set-char #xFF5C ?$(B!C(B) ; J83-B-2143

(ucs-set-char #xFF5D ?$(G!C(B) ; C01-G-2143
(ucs-set-char #xFF5D ?$(C#}(B) ; KS0-C-237D
(ucs-set-char #xFF5D ?$(A#}(B) ; GB0-A-237D
(ucs-set-char #xFF5D ?$(@!Q(B) ; J78-@-2151
(ucs-set-char #xFF5D ?$(B!Q(B) ; J83-B-2151

;; FULLWIDTH TILDE;<wide> 007E
(ucs-set-char #xFF5E ?$(C"&(B) ; KS0-C-2226
(ucs-set-char #xFF5E ?$(D"7(B) ; J90-D-2237
(ucs-set-char #xFF5E ?$(A!+(B) ; GB0-A-212B

;; HALFWIDTH IDEOGRAPHIC FULL STOP;<narrow> 3002
(ucs-set-char #xFF61 ?)I) ; JIS-X-0201-A1-A

(ucs-set-char #xFF62 ?)I) ; JIS-X-0201-A2-A

(ucs-set-char #xFF63 ?)I) ; JIS-X-0201-A3-A

(ucs-set-char #xFF64 ?)I) ; JIS-X-0201-A4-A

(ucs-set-char #xFF65 ?)I) ; JIS-X-0201-A5-A

(ucs-set-char #xFF66 ?)I) ; JIS-X-0201-A6-A
(ucs-set-char #xFF67 ?)I) ; JIS-X-0201-A7-A
(ucs-set-char #xFF68 ?)I) ; JIS-X-0201-A8-A
(ucs-set-char #xFF69 ?)I) ; JIS-X-0201-A9-A
(ucs-set-char #xFF6A ?)I) ; JIS-X-0201-AA-A
(ucs-set-char #xFF6B ?)I) ; JIS-X-0201-AB-A
(ucs-set-char #xFF6C ?)I) ; JIS-X-0201-AC-A
(ucs-set-char #xFF6D ?)I) ; JIS-X-0201-AD-A
(ucs-set-char #xFF6E ?)I) ; JIS-X-0201-AE-A
(ucs-set-char #xFF6F ?)I) ; JIS-X-0201-AF-A
(ucs-set-char #xFF70 ?)I) ; JIS-X-0201-B0-A
(ucs-set-char #xFF71 ?)I) ; JIS-X-0201-B1-A
(ucs-set-char #xFF72 ?)I) ; JIS-X-0201-B2-A
(ucs-set-char #xFF73 ?)I) ; JIS-X-0201-B3-A
(ucs-set-char #xFF74 ?)I) ; JIS-X-0201-B4-A
(ucs-set-char #xFF75 ?)I) ; JIS-X-0201-B5-A
(ucs-set-char #xFF76 ?)I) ; JIS-X-0201-B6-A
(ucs-set-char #xFF77 ?)I) ; JIS-X-0201-B7-A
(ucs-set-char #xFF78 ?)I) ; JIS-X-0201-B8-A
(ucs-set-char #xFF79 ?)I) ; JIS-X-0201-B9-A
(ucs-set-char #xFF7A ?)I) ; JIS-X-0201-BA-A
(ucs-set-char #xFF7B ?)I) ; JIS-X-0201-BB-A
(ucs-set-char #xFF7C ?)I) ; JIS-X-0201-BC-A
(ucs-set-char #xFF7D ?)I) ; JIS-X-0201-BD-A
(ucs-set-char #xFF7E ?)I) ; JIS-X-0201-BE-A
(ucs-set-char #xFF7F ?)I) ; JIS-X-0201-BF-A
(ucs-set-char #xFF80 ?)I) ; JIS-X-0201-C0-A
(ucs-set-char #xFF81 ?)I) ; JIS-X-0201-C1-A
(ucs-set-char #xFF82 ?)I) ; JIS-X-0201-C2-A
(ucs-set-char #xFF83 ?)I) ; JIS-X-0201-C3-A
(ucs-set-char #xFF84 ?)I) ; JIS-X-0201-C4-A
(ucs-set-char #xFF85 ?)I) ; JIS-X-0201-C5-A
(ucs-set-char #xFF86 ?)I) ; JIS-X-0201-C6-A
(ucs-set-char #xFF87 ?)I) ; JIS-X-0201-C7-A
(ucs-set-char #xFF88 ?)I) ; JIS-X-0201-C8-A
(ucs-set-char #xFF89 ?)I) ; JIS-X-0201-C9-A
(ucs-set-char #xFF8A ?)I) ; JIS-X-0201-CA-A
(ucs-set-char #xFF8B ?)I) ; JIS-X-0201-CB-A
(ucs-set-char #xFF8C ?)I) ; JIS-X-0201-CC-A
(ucs-set-char #xFF8D ?)I) ; JIS-X-0201-CD-A
(ucs-set-char #xFF8E ?)I) ; JIS-X-0201-CE-A
(ucs-set-char #xFF8F ?)I) ; JIS-X-0201-CF-A
(ucs-set-char #xFF90 ?)I) ; JIS-X-0201-D0-A
(ucs-set-char #xFF91 ?)I) ; JIS-X-0201-D1-A
(ucs-set-char #xFF92 ?)I) ; JIS-X-0201-D2-A
(ucs-set-char #xFF93 ?)I) ; JIS-X-0201-D3-A
(ucs-set-char #xFF94 ?)I) ; JIS-X-0201-D4-A
(ucs-set-char #xFF95 ?)I) ; JIS-X-0201-D5-A
(ucs-set-char #xFF96 ?)I) ; JIS-X-0201-D6-A
(ucs-set-char #xFF97 ?)I) ; JIS-X-0201-D7-A
(ucs-set-char #xFF98 ?)I) ; JIS-X-0201-D8-A
(ucs-set-char #xFF99 ?)I) ; JIS-X-0201-D9-A
(ucs-set-char #xFF9A ?)I) ; JIS-X-0201-DA-A
(ucs-set-char #xFF9B ?)I) ; JIS-X-0201-DB-A
(ucs-set-char #xFF9C ?)I) ; JIS-X-0201-DC-A
(ucs-set-char #xFF9D ?)I) ; JIS-X-0201-DD-A

(ucs-set-char #xFF9E ?)I) ; JIS-X-0201-DE-A

;; HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK;<narrow> 309C
(ucs-set-char #xFF9F ?)I) ; JIS-X-0201-DF-A

;; FULLWIDTH CENT SIGN;<wide> 00A2
(ucs-set-char #xFFE0 ?$(G"f(B) ; C01-G-2266
(ucs-set-char #xFFE0 ?$(C!K(B) ; KS0-C-214B
(ucs-set-char #xFFE0 ?$(A!i(B) ; GB0-A-2169
(ucs-set-char #xFFE0 ?$(@!q(B) ; J78-@-2171
(ucs-set-char #xFFE0 ?$(B!q(B) ; J83-B-2171

;; FULLWIDTH POUND SIGN;<wide> 00A3
(ucs-set-char #xFFE1 ?$(G"g(B) ; C01-G-2267
(ucs-set-char #xFFE1 ?$(C!L(B) ; KS0-C-214C
(ucs-set-char #xFFE1 ?$(A!j(B) ; GB0-A-216A
(ucs-set-char #xFFE1 ?$(@!r(B) ; J78-@-2172
(ucs-set-char #xFFE1 ?$(B!r(B) ; J83-B-2172

;; FULLWIDTH NOT SIGN;<wide> 00AC
(ucs-set-char #xFFE2 ?$(C!~(B) ; KS0-C-217E
(ucs-set-char #xFFE2 ?$(B"L(B) ; J83-B-224C

;; FULLWIDTH MACRON;<wide> 00AF
(ucs-set-char #xFFE3 ?$(D"4(B) ; J90-D-2234
(ucs-set-char #xFFE3 ?$(C#~(B) ; KS0-C-237E
(ucs-set-char #xFFE3 ?$(A#~(B) ; GB0-A-237E

;; FULLWIDTH BROKEN BAR;<wide> 00A6
(ucs-set-char #xFFE4 ?$(D"C(B) ; J90-D-2243

;; FULLWIDTH YEN SIGN;<wide> 00A5
(ucs-set-char #xFFE5 ?$(A#$(B) ; GB0-A-2324
(ucs-set-char #xFFF5 ?$(G"d(B) ; C01-G-2264
(ucs-set-char #xFFE5 ?$(C!M(B) ; KS0-C-214D
(ucs-set-char #xFFE5 ?$(@!o(B) ; J78-@-216F
(ucs-set-char #xFFE5 ?$(B!o(B) ; J83-B-216F

;; FULLWIDTH WON SIGN;<wide> 20A9
(ucs-set-char #xFFE6 ?$(C#\(B) ; KS0-C-235C

;;; ucs-hw-fw.el ends here
