;;; locale-start.el --- Version francise de l'cran d'acceuil

;; Copyright (C) 1999 Didier Verna.

;; Author:        Didier Verna <didier@xemacs.org>
;; Maintainer:    Didier Verna <didier@xemacs.org>
;; Created:       Thu Mar 11 09:49:36 1999 under XEmacs 21.2 (beta 12)
;; Last Revision: Thu Mar 11 10:08:32 1999
;; Keywords:      internal

;; This file is part of XEmacs.

;; XEmacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; XEmacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


;;; Commentary:

;; Contents management by FCM version 0.1.


;;; TODO:


;;; Change Log:


;;; Code:

(defun splash-frame-body ()
  `[((face (blue bold underline)
	   "\nDistribution, license de reproduction, garanties:\n\n")
     "Visitez le site web d'XEmacs  http://www.xemacs.org !\n\n"
     ,@(if (featurep 'sparcworks)
	   `( "\
Sun fournit un support pour le paquet d'intgration Workshop/XEmacs seulement.
Tous les autres paquets d'XEmacs sont fournis TEL QUEL.\n"
	      ,@(let ((lang (or (getenv "LC_ALL") (getenv "LC_MESSAGES")
				(getenv "LANG"))))
		  (if (and
		       (not (featurep 'mule)) ;; Already got mule?
		       ;; No Mule support on tty's yet
		       (not (eq 'tty (console-type)))
		       lang ;; Non-English locale?
		       (not (string= lang "C"))
		       (not (string-match "^en" lang))
		       ;; Comes with Sun WorkShop
		       (locate-file "xemacs-mule" exec-path))
		      '( "\
Cette version d'XEmacs a t compile avec le support Latin-1 seul.
Pour manipuler d'autres langages, vous devez disposer d'une version
multi-lingue (`Mule') d'XEmacs, soit en utilisant la commande `xemacs-mule',
soit en positionnant la resource X `ESERVE*defaultXEmacsPath: xemacs-mule' en
dmarrant XEmacs depuis le WorkShop de Sun.
\n")))))
     ((key describe-no-warranty)
      ": "(face (red bold) "XEmacs est fournit SANS AUCUNE GARANTIE\n"))
     ((key describe-copying)
      ": conditions pour distribuer des copies d'XEmacs\n")
     ((key describe-distribution)
      ": comment obtenir la dernire version\n")
     "\n--\n"
     (face italic "\
Copyright (C) 1985-1998 Free Software Foundation, Inc.
Copyright (C) 1990-1994 Lucid, Inc.
Copyright (C) 1993-1997 Sun Microsystems, Inc. Tous droits rservs.
Copyright (C) 1994-1996 Board of Trustees, University of Illinois
Copyright (C) 1995-1996 Ben Wing\n"))

    ((face (blue bold underline) "\nInformation, aide en ligne:\n\n")
     "XEmacs vient avec une documentation fournie...\n\n"
     ,@(if (string-match "beta" emacs-version)
	   `((key describe-beta)
	     ": " (face (red bold)
			"Ceci est une version exprimentale d'XEmacs.\n"))
	 `( "\n"))
     ((key xemacs-local-faq)
      ": la FAQ d'XEmacs (un F " (face underline "majuscule") " !)\n")
     ((key help-with-tutorial)
      ": le tutoriel d'XEmacs (figure aussi dans le menu "
      (face bold "Aide") ")\n")
     ((key help-command)
      ": de l'aide sur l'utilisation d'XEmacs (figure aussi dans le menu "
      (face bold "Aide") ")\n")
     ((key info) ": la documentation en-ligne\n\n")
     ((key describe-project) ":  propos du projet GNU\n")
     ((key about-xemacs) ":  propos des dveloppeurs d'XEmacs\n"))

    ((face (blue bold underline) "\nLes choses utiles:\n\n")
     "Ce que vous devriez savoir rapidement...\n\n"
     ((key find-file) ": visiter un fichier\n")
     ((key save-buffer) ": sauvegarder les modifiactions\n")
     ((key advertised-undo) ": annuler les modifications\n")
     ((key save-buffers-kill-emacs) ": sortir d'XEmacs\n"))
    ])

(setq splash-frame-static-body
      `(,(emacs-version) "\n\n"
	(face italic
	      "`C-' signifie la touche Contrle,`M-' signifie la touche Mta\n\n")))

;;; locale-start.el ends here
