/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.spec;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidLineNumberException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import java.util.List;
import jde.debugger.DebuggeeProcess;
import jde.debugger.JDEException;
import jde.debugger.spec.BreakpointSpec;
import jde.debugger.spec.ReferenceTypeSpec;

public class LineBreakpointSpec
extends BreakpointSpec {
    private int lineNumber;

    public LineBreakpointSpec(DebuggeeProcess proc, ReferenceTypeSpec refSpec, int line) {
        super(proc, refSpec);
        this.lineNumber = line;
    }

    boolean resolve(ReferenceType refType) throws JDEException {
        if (!(refType instanceof ClassType)) {
            throw new JDEException("'" + refType + "' is not a Class");
        }
        Location location = this.getLocation((ClassType)refType);
        BreakpointRequest br = refType.virtualMachine().eventRequestManager().createBreakpointRequest(location);
        this.setRequest(br);
        return true;
    }

    private Location getLocation(ClassType clazz) throws JDEException {
        Location location = null;
        try {
            List<Location> locs = null;
            try {
                locs = clazz.locationsOfLine(this.lineNumber);
            }
            catch (InvalidLineNumberException ex) {
                throw new JDEException("Line #" + this.lineNumber + " does not exist in " + clazz + ".");
            }
            if (locs.size() == 0) {
                throw new JDEException("Line #" + this.lineNumber + " does not exist int " + clazz + ".");
            }
            location = locs.get(0);
            if (location.method() == null) {
                throw new JDEException("Line #" + this.lineNumber + " does not correspond to a method in " + clazz + ".");
            }
        }
        catch (AbsentInformationException e) {
            throw new JDEException("Line Information missing for Class '" + clazz + "'");
        }
        return location;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

