/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import java.lang.reflect.Array;

class BSHArrayInitializer
extends SimpleNode {
    BSHArrayInitializer(int n) {
        super(n);
    }

    public Object eval(NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        throw new EvalError("array initializer Internal error, no base type");
    }

    public Object eval(Class clazz, NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        int n = this.jjtGetNumChildren();
        Class clazz2 = null;
        Object object = null;
        int n2 = 0;
        while (n2 < n) {
            Object object2 = ((SimpleNode)this.jjtGetChild(n2)).eval(nameSpace, interpreter);
            if (object == null) {
                clazz2 = object2 instanceof Primitive ? ((Primitive)object2).getType() : object2.getClass();
                object = Array.newInstance(clazz2, this.jjtGetNumChildren());
            }
            try {
                if (clazz2.isArray() || !clazz2.isPrimitive()) {
                    ((Object[])object)[n2] = object2;
                } else {
                    Object object3 = ((Primitive)object2).getValue();
                    if (clazz2 == Boolean.TYPE) {
                        ((boolean[])object)[n2] = (Boolean)object3;
                    } else if (clazz2 == Character.TYPE) {
                        ((char[])object)[n2] = ((Character)object3).charValue();
                    } else if (clazz2 == Byte.TYPE) {
                        ((byte[])object)[n2] = (Byte)object3;
                    } else if (clazz2 == Short.TYPE) {
                        ((short[])object)[n2] = (Short)object3;
                    } else if (clazz2 == Integer.TYPE) {
                        ((int[])object)[n2] = (Integer)object3;
                    } else if (clazz2 == Long.TYPE) {
                        ((long[])object)[n2] = (Long)object3;
                    } else if (clazz2 == Float.TYPE) {
                        ((float[])object)[n2] = ((Float)object3).floatValue();
                    } else if (clazz2 == Double.TYPE) {
                        ((double[])object)[n2] = (Double)object3;
                    }
                }
            }
            catch (Exception exception) {
                String string = Reflect.normalizeClassName(clazz2);
                String string2 = object2 instanceof Primitive ? ((Primitive)object2).getType().getName() : Reflect.normalizeClassName(object2.getClass());
                throw new EvalError("Incompatible types in initializer. Initializer contains both " + string + " and " + string2, this);
            }
            ++n2;
        }
        if (object == null) {
            object = Array.newInstance(clazz, 0);
        }
        return object;
    }
}

