/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jde.wizards.DefaultNameFactory;
import jde.wizards.MethodFactory;
import jde.wizards.NameFactory;
import jde.wizards.NotAnInterfaceException;
import jde.wizards.Signature;

public class InterfaceFactory
extends MethodFactory {
    private Hashtable interfaces = new Hashtable();
    static InterfaceFactory interfaceFactory;

    public InterfaceFactory() {
    }

    public InterfaceFactory(NameFactory factory) {
        super(factory);
    }

    private final void sortByDeclaringClass(Signature sig) {
        String declaring = sig.getDeclaringClass().getName();
        if (this.interfaces.containsKey(declaring)) {
            Vector v = (Vector)this.interfaces.get(declaring);
            if (!v.contains(sig)) {
                v.addElement(sig);
            }
        } else {
            Vector<Signature> v = new Vector<Signature>();
            v.addElement(sig);
            this.interfaces.put(declaring, v);
        }
    }

    public void flush() {
        super.flush();
        this.interfaces.clear();
    }

    public void process(String interfaceName) throws ClassNotFoundException, NotAnInterfaceException {
        this.process(interfaceName, true);
    }

    public void process(String name, boolean truncate) throws ClassNotFoundException, NotAnInterfaceException {
        Class<?> aclass;
        if (null == this.namefactory) {
            this.namefactory = new DefaultNameFactory();
        }
        if (!(aclass = Class.forName(name)).isInterface()) {
            throw new NotAnInterfaceException(name);
        }
        Method[] methods = aclass.getMethods();
        int i = 0;
        while (i < methods.length) {
            this.sortByDeclaringClass(new Signature(methods[i], this, truncate));
            ++i;
        }
    }

    public static void makeInterface(String name, boolean javadoc, boolean truncate, boolean newline) {
        if (interfaceFactory == null) {
            interfaceFactory = new InterfaceFactory();
        }
        interfaceFactory.flush();
        interfaceFactory.makeInterfaceInternal(name, javadoc, truncate, newline);
    }

    private void makeInterfaceInternal(String name, boolean javadoc, boolean truncate, boolean newline) {
        try {
            this.process(name, truncate);
        }
        catch (ClassNotFoundException e) {
            MethodFactory.println("(error \"Error: could not find interface named: " + name + ". " + "Note: name must be qualified.\")");
            return;
        }
        catch (NotAnInterfaceException e) {
            MethodFactory.println("(error \"Error: " + name + " is not an interface.\")");
            return;
        }
        catch (Exception e) {
            MethodFactory.println("(error \"Error: unknown type.\")");
            return;
        }
        this.dump(new PrintWriter(System.out, true), javadoc, truncate, newline);
    }

    public static void getImportedClasses() {
        String res = "(list ";
        Enumeration i = InterfaceFactory.interfaceFactory.imports.keys();
        while (i.hasMoreElements()) {
            Class c = (Class)i.nextElement();
            res = res + "\"" + c.getName() + "\" ";
        }
        res = res + ")";
        MethodFactory.println(res);
    }

    public void dump(PrintWriter out, boolean javadoc, boolean truncate, boolean newline) {
        StringBuffer buf = new StringBuffer("\"");
        Enumeration declaring_classes = this.interfaces.keys();
        while (declaring_classes.hasMoreElements()) {
            String interf = (String)declaring_classes.nextElement();
            Vector v = (Vector)this.interfaces.get(interf);
            buf.append("// implementation of ");
            buf.append(interf);
            buf.append(" interface\n");
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                Signature sig = (Signature)e.nextElement();
                String todo = "  // TODO: implement this " + interf + " method\n";
                buf.append(this.getMethodSkeleton(sig, javadoc, newline, todo));
            }
        }
        buf.append("\"");
        MethodFactory.println(buf.toString());
    }
}

