#!/bin/ksh

PATH=${PATH}:/local/bin
export PATH

REQUESTDIRS="request-info-bbdb request-xemacs request-xemacs-beta \
	     request-xemacs-beta-discuss request-xemacs-beta-patches"
INFODIRS="info-bbdb-archive"
XEMACSDIRS="xemacs-archive xemacs-beta-archive \
	    xemacs-beta-discuss-archive xemacs-beta-patches-archive"

cd /mounts/kaplan/xemacs

for i in $REQUESTDIRS $INFODIRS $XEMACSDIRS ; do
  if [ $i != "" ]; then
    echo $i
    ls -l $i
    echo "--------------------------------------------------------------------"

    if [ ! -f ${i}/${i}-1.gz ]; then
      last=0
    else
      last=`ls ${i}/${i}-*.gz | sort -n | tail -1 | sed 's/^.*\([0-9][0-9]*\).*/\1/'`
    fi
    (( next = last + 1 ))

    if [ -f ${i}/archive ] && [ ! -z ${i}/archive ]; then
      mv ${i}/archive ${i}/${i}-${next}
      touch ${i}/archive
      chmod 660 ${i}/archive
      chown xemacs ${i}/archive
      chgrp xemacs ${i}/archive
      gzip --best ${i}/${i}-$next
      chmod 440 ${i}/${i}-${next}.gz
    fi

    ls -l $i
    echo "===================================================================="
    echo " "
    echo " "
    echo " "
  fi
done
