;;; locale-start.el --- startup.el customized for ja locale.

;; Copyright (C) 1985-6, 1990, 1992-1995, 1997 Free Software Foundation, Inc.
;; Copyright (c) 1993-1997 Sun Microsystems, Inc.
;; Copyright (C) 1995 Board of Trustees, University of Illinois

;; Maintainer: XEmacs Development Team
;; Keywords: internal

;; This file is part of XEmacs.

;; XEmacs is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XEmacs is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.


;;; Synched up with:  Not in FSF

;;; Commentary:

;;			This file, being an .el file, 
;;			must be in ISO 2022 encoding after installation.
;; @(#)locale-start.el.euc	1.7 97/03/06 13:43:21

;;; Code:

(if (fboundp 'splash-frame-body)

;; old way

(defun splash-frame-body ()
  `("\n" ,(emacs-version) "\n"
    (face bold-italic "\
Copyright (C) 1985-1997 Free Software Foundation, Inc.
Copyright (C) 1990-1994 Lucid, Inc.
Copyright (C) 1993-1997 Sun Microsystems, Inc. All Rights Reserved.
Copyright (C) 1994-1996 Board of Trustees, University of Illinois
Copyright (C) 1995-2004 Ben Wing\n\n")
    
    ,@(if (featurep 'sparcworks)
          `( "\
$B%5%s$O!"(BWorkShop/Emacs $BE}9g2=%Q%C%1!<%8$N$_$r%5%]!<%H$7$^$9!#(B
$BB>$N(B XEmacs $B%Q%C%1!<%8$O$9$Y$F!"!V8=>u$N$^$^!W$G6!5k$5$l$^$9!#(B
$B>\:Y(B ($B1QJ8(B) $B$O(B" (key describe-no-warranty) "$B$H%?%$%W$7$F!"(B
1991 $BG/(B 6 $B7nHG(B GPL $B%P!<%8%g%s(B 2 $B$r$4Mw$/$@$5$$!#(B
$BK\(B XEmacs $B$O4pK\%a%K%e!<$K8B$jF|K\8l2=$5$l$F$$$^$9!#AH$_9~$^$l$?(B
$B%a!<%k(B (VM$B!"(BMH) $B$d%K%e!<%9$rFI$`$?$a$N%Q%C%1!<%8(B (Gnus) $BEy$O!"(B
$BF|K\8l$r40`z$K$O=hM}$G$-$^$;$s$N$G!"$4;HMQ$K$J$k>l9g$O==J,$4Cm0U(B
$B$/$@$5$$!#(B\n")

        '("XEmacs $B$K$O(B *$B$^$C$?$/2?$N(B* $BJ]>c$b$"$j$^$;$s!#>\:Y$O!"(B"
          (key describe-no-warranty) "$B$r%?%$%W$7$F$/$@$5$$!#(B\n"))

    "XEmacs $B$NJ#@=$O5v2D$5$l$F$$$^$9!#5v2D$N>r7o$r8+$k$K$O!"(B\n"
    (key describe-copying) " $B$H%?%$%W$7$F$/$@$5$$!#(B\n"
    "$B:G?7HG$N<hF@J}K!$K$D$$$F$O!"(B" (key describe-distribution)
    " $B$H%?%$%W$7$F$/$@$5$$!#(B\n\n"
    
    "$B%X%k%W>pJs$r8+$k$K$O!"(B" (key help-command) " $B$H%?%$%W!"$^$?$O(B" 
    (face bold "$B%X%k%W(B") "$B%a%K%e!<$r;HMQ(B\n"
    "$B$7$F$/$@$5$$(B\n"
    (key advertised-undo) " $B$K$h$jJQ99$r<h$j>C$;$^$9!#(B(C- $B$O!"(BControl $B%-!<$G$9!#(B)\n"
    "XEmacs $B$r=*N;$9$k$K$O!"(B" (key save-buffers-kill-emacs) " $B$H%?%$%W$7$F$/$@$5$$!#(B\n"
    (key help-with-tutorial) " $B$G(B XEmacs $B$N;HMQJ}K!$N<B=,$r3+;O$G$-$^$9!#(B\n"
    (key info) " $B$K$h$j!"(BInfo $B%b!<%I$KF~$j!"%*%s%i%$%s$N%I%-%e%a%s%H$r(B\n"
    "$BFI$`$3$H$,$G$-$^$9!#(B\n"
    (face (bold red) ( "\
$BIQHK$K?R$M$i$l$k<ALd$H$=$NEz$($O!"(BXEmacs $BLdEz=8$K$"$j$^$9!#(B\n"
    "$B%X%k%W%a%K%e!<$r;HMQ$9$k$+!"(B"(key xemacs-local-faq) " $B$H%?%$%W$7$F$/$@$5$$!#(B"))))

;; new way

(defun splash-screen-window-body ()
  `(
     (face (blue bold underline)
	   "#### Entries utiles dans le menu Aide:\n\n")
     ,@(if (string-match "beta" emacs-version)
	   `((face bold "Beta Info:")
	     (face (red bold)
		   "                      Ceci est une version exp,Ai(Brimentale d'XEmacs.\n"))
	 `( ""))
     (face bold "XEmacs FAQ:")
     "                     Lisez la FAQ d'XEmacs.\n"
     (face bold "Info (Online Docs):")
     "             $B$K$h$j!"(BInfo $B%b!<%I$KF~$j!"%*%s%i%$%s$N%I%-%e%a%s%H$r(B.\n"
     (face bold "Tutorial:")
     "                       Lisez le tutoriel d'XEmacs.\n"
     (face bold "Samples->View Sample init.el:") ;; #### translation
     "   Un fichier utile d'initialization.\n"
     (face bold "About XEmacs:")
     "                   ,A@(B propos des d,Ai(Bveloppeurs d'XEmacs.\n"
     "\n"
     (face (bold blue) "Site web d'XEmacs:")
     "                 http://www.xemacs.org/\n\n"
     ,@(if (featurep 'sparcworks)
	   `( "\
$B%5%s$O!"(BWorkShop/Emacs $BE}9g2=%Q%C%1!<%8$N$_$r%5%]!<%H$7$^$9!#(B
$BB>$N(B XEmacs $B%Q%C%1!<%8$O$9$Y$F!"!V8=>u$N$^$^!W$G6!5k$5$l$^$9!#(B
$B>\:Y(B ($B1QJ8(B) $B$O(B" (key describe-no-warranty) "$B$H%?%$%W$7$F!"(B
1991 $BG/(B 6 $B7nHG(B GPL $B%P!<%8%g%s(B 2 $B$r$4Mw$/$@$5$$!#(B
$BK\(B XEmacs $B$O4pK\%a%K%e!<$K8B$jF|K\8l2=$5$l$F$$$^$9!#AH$_9~$^$l$?(B
$B%a!<%k(B (VM$B!"(BMH) $B$d%K%e!<%9$rFI$`$?$a$N%Q%C%1!<%8(B (Gnus) $BEy$O!"(B
$BF|K\8l$r40`z$K$O=hM}$G$-$^$;$s$N$G!"$4;HMQ$K$J$k>l9g$O==J,$4Cm0U(B
$B$/$@$5$$!#(B\n"))

     (face italic "\
Copyright (C) 1985-1999 Free Software Foundation, Inc.
Copyright (C) 1990-1994 Lucid, Inc.
Copyright (C) 1993-1997 Sun Microsystems, Inc. Tous droits r,Ai(Bserv,Ai(Bs.
Copyright (C) 1994-1996 Board of Trustees, University of Illinois.
Copyright (C) 1995-2004 Ben Wing.\n")
     ))

(defun splash-screen-tty-body ()
  `(
    (face italic "[`C-' signifie la touche Contr,At(Ble,`M-' signifie la touche M,Ai(Bta]\n\n")
     ,@(if (string-match "beta" emacs-version)
	   `((key describe-beta)
	     ": " (face (red bold)
			"Ceci est une version exp,Ai(Brimentale d'XEmacs.\n"))
	 `( "\n"))
     (face (bold red) ( "\
$BIQHK$K?R$M$i$l$k<ALd$H$=$NEz$($O!"(BXEmacs $BLdEz=8$K$"$j$^$9!#(B\n"
			"$B%X%k%W%a%K%e!<$r;HMQ$9$k$+!"(B"(key xemacs-local-faq) " $B$H%?%$%W$7$F$/$@$5$$!#(B"))
     ((key info) " $B$K$h$j!"(BInfo $B%b!<%I$KF~$j!"%*%s%i%$%s$N%I%-%e%a%s%H$r(B\n")
     ((key help-command)
      ": De l'aide sur l'utilisation d'XEmacs.\n")
     ((key help-with-tutorial)
      " $B$G(B XEmacs $B$N;HMQJ}K!$N<B=,$r3+;O$G$-$^$9!#(B\n")
     ((key view-sample-init-el) ;; #### translation?
      ": Regardez le fichier sample init.el.\n")
     ((key about-xemacs) ": ,A@(B propos des d,Ai(Bveloppeurs d'XEmacs.\n\n")
     (face (bold blue) "Site web d'XEmacs: ") 
     "http://www.xemacs.org/\n\n"
     (face italic "\
Copyright (C) 1985-1999 Free Software Foundation, Inc.
Copyright (C) 1990-1994 Lucid, Inc.
Copyright (C) 1993-1997 Sun Microsystems, Inc. Tous droits r,Ai(Bserv,Ai(Bs.
Copyright (C) 1994-1996 Board of Trustees, University of Illinois.
Copyright (C) 1995-2004 Ben Wing.")
;      ((key find-file) ": visiter un fichier\n")
;      ((key save-buffer) ": sauvegarder les modifiactions\n")
;      ((key advertised-undo) ": annuler les modifications\n")
;      ((key save-buffers-kill-emacs) ": sortir d'XEmacs\n")
     ))
)

(defun command-line-do-help (arg)
  "Print the XEmacs usage message and exit."
  (let ((charmap (shell-command-to-string "locale charmap")))
    (cond ((string-match "UTF-8" charmap)
	   (require 'un-define)
	   (set-terminal-coding-system 'utf-8))
	  ((string-match "EUC-JP" charmap)
	   (set-terminal-coding-system 'euc-jp))
	  ((string-match "SHIFT_JIS" charmap)
	   (set-terminal-coding-system 'shift_jis))))
  (let ((standard-output 'external-debugging-output))
    (princ (concat "\n" (emacs-version) "\n\n"))
    (princ
     (if (featurep 'x)
	 (concat "X $B$N2hLL$K%&%#%s%I%&$r:n@.$7$F$$$k$H$-$O!"(B"
		 (emacs-name)
		 " $B$O0J2<$N$b$N$H!"(BX $B%D!<%k%-%C%H$NI8=`%3%^%s%I%*%W%7%g%s$r$9$Y$FG'<1$7$^$9(B:
  -iconame <$B%?%$%H%k(B>   $B%?%$%H%k$r%"%$%3%s$NL>A0$H$7$F;H$&!#(B
  -mc <$B?'(B>              $B?'$r%^%&%9MQ$N?'$H$7$F;H$&!#(B
  -cr <$B?'(B>              $B?'$r%F%-%9%H%+!<%=%k$NA0LL?'$H$7$F;H$&!#(B
  -private              $B%W%i%$%Y!<%H%+%i!<%^%C%W$r;H$&!#(B

$B$=$l$K2C$($F!"(B")))
    (princ "XEmacs $B$O!"0J2<$N%*%W%7%g%s$rG'<1$7$^$9(B:

  -t <$B%G%P%$%9L>(B>       $BC<Kv$NBe$o$j$K;XDj$N(B TTY $B%G%P%$%9$r;HMQ$7$FF~=PNO$r(B
			$B9T$J$&!#(B-nw $B$,<+F0E*$K2>Dj$5$l$k!#(B
  -nw                   $B%&%#%s%I%&%7%9%F%`$r;HMQ$;$:!"8=(B TTY $B$r;HMQ!#(B
  -batch                $BHsBPOCE*;HMQ!#%a%C%;!<%8$O!"I8=`%(%i!<(B (stderr) $B%X!#(B
  -debug-init           $B=i4|2=%U%!%$%k$G$N%(%i!<H/@8;~$K$O%G%P%C%,$r5/F0!#(B
  -unmapped             $B=i4|%U%l!<%`$N%^%C%W$r$7$J$$!#(B
  -no-site-file         $B%5%$%HFC2==i4|2=%U%!%$%k(B (site-start.el) $B$rFI$_9~$^$J$$!#(B
  -no-init-file         $B%f!<%6!<FC2==i4|2=%U%!%$%k(B (~/.emacs) $B$rFI$_9~$^$J$$!#(B
  -no-early-packages    $BAa4|%Q%C%1!<%8$r<B9T$7$J$$!#(B
  -no-autoloads         $BA4BN%7%s%\%k%U%!%$%k(B (auto-autoloads) $B$r3+;O;~$K(B
                        $BFI$_9~$^$J$$!#(B`-vanilla' $B$,2>Dj$5$l$k!#(B
  -vanilla              -q -no-site-file -no-early-packages $B$HF15A!#(B
  -q                    -no-init-file $B$HF15A!#(B
  -user-init-file <$B%U%!%$%k(B> <$B%U%!%$%k(B> $B$r=i4|2=%U%!%$%k$H$7$F;HMQ!#(B
  -user-init-directory <$B%G%#%l%/%H%j(B> <$B%G%#%l%/%H%j(B> $B$r=i4|2=%G%#%l%/%H%j$H$7$F(B
                        $B;HMQ!#(B
  -user <$B%f!<%6!<L>(B>    $B<+J,$N=i4|2=%U%!%$%k$NBe$o$j$K;XDj%f!<%6!<$N(B
                        $B%U%!%$%k$r;HMQ!#0J2<$N$b$N$HF15A!#(B
                        -user-init-file ~<$B%f!<%6!<L>(B>/.emacs
                        -user-init-directory ~<$B%f!<%6!<L>(B>/.xemacs/
  -u <$B%f!<%6!<L>(B>       -user $B$HF15A!#(B\n")
;; $B1Q8lHG$G$O!"0J2<$N$h$&$J%3!<%I$K$h$j!"%I%-%e%a%s%H$N0lIt$,I=<($5$l$F$$$?$,!"(B
;; $B$3$l$G$O!"1Q8l$N%I%-%e%a%s%H$7$+I=<($G$-$J$$$N$G!"$3$N%3!<%I$O%3%a%s%H%"%&%H$7!"(B
;; $BC1=c$K@bL@$r0u;z$9$k%3!<%I$HCV$-49$($k!#(B
;;   (let ((l command-switch-alis\nt)
;;	  (insert (lambda (&rest x)
;;		    (princ "  ")
;;		    (let ((len 2))
;;		      (while x
;;			(princ (car x))
;;			(incf len (length (car x)))
;;			(setq x (cdr x)))
;;		      (when (>= len 24)
;;			(terpri) (setq len 0))
;;		      (while (< len 24)
;;			(princ " ")
;;			(incf len))))))
;;      (while l
;;        (let ((name (car (car l)))
;;              (fn (cdr (car l)))
;;	      doc arg cons)
;;	  (cond
;;	   ((and (symbolp fn) (get fn 'undocumented)) nil)
;;	   (t
;;	    (setq doc (documentation fn))
;;	    (if (member doc '(nil "")) (setq doc "(undocumented)"))
;;	    (cond ((string-match "\n\\(<.*>\\)\n?\\'" doc)
;;		   ;; Doc of the form "The frobber switch\n<arg1> <arg2>"
;;		   (setq arg (substring doc (match-beginning 1) (match-end 1))
;;			 doc (substring doc 0 (match-beginning 0))))
;;		  ((string-match "\n+\\'" doc)
;;		   (setq doc (substring doc 0 (match-beginning 0)))))
;;	    (if (and (setq cons (rassq fn command-switch-alist))
;;		     (not (eq cons (car l))))
;;		(setq doc (format "Same as %s." (car cons))))
;;
;;	    (if arg
;;		(funcall insert name " " arg)
;;	      (funcall insert name))
;;	    (princ doc)
;;	    (terpri))))
;;        (setq l (cdr l))))
;; $BCV$-49$(ItJ,3+;O(B
  (princ "\
  -help                 XEmacs $B;HMQK!$rI=<($7$F=*N;!#(B
  -version              $B%P!<%8%g%s>pJs$rI=<($7$F=*N;!#(B
  -V                    -version $B$HF15A!#(B
  -funcall <$B4X?tL>(B>     $B;XDj$N(B lisp $B4X?t$r0z?t$J$7$G5/F0!#(B
  -f <$B4X?tL>(B>           -funcall $B$HF15A!#(B
  -eval <$B%U%)!<%`(B>      lisp $B$N%U%)!<%`$rI>2A!#0zMQ(B (quote) $B$OCm0U?<$/9T$J$C$F$/$@$5$$!#(B
  -load <$B%U%!%$%kL>(B>    $B;XDj$N(B lisp $B%3!<%I$r(B XEmacs $B$KFI$_9~$`!#(B
  -l <$B%U%!%$%kL>(B>       -load $B$HF15A!#(B
  -insert <$B%U%!%$%kL>(B>  $B8=%P%C%U%!$K%U%!%$%k$rA^F~!#(B
  -i <$B%U%!%$%kL>(B>       -insert $B$HF15A!#(B
  -kill                 XEmacs $B$r=*N;!#(B
")
;; $BCV$-49$(ItJ,=*N;(B
  (princ (concat "\
  +N $B%U%!%$%kL>(B         $B;XDj%U%!%$%k$r(B N $B9TL\$+$iI=<(!#(B

$BB>$N$9$Y$F7A<0$N0z?t$O%U%!%$%kL>$H2r<a$5$l!"JT=8$N$?$a$K%P%C%U%!$KFI$_9~$^(B
$B$l$^$9!#(B

" (emacs-name) "$B$K$O!"%*%s%i%$%s$N<+=,=q$H%^%K%e%"%k(B ($B%^%K%e%"%k$OF|K\8lHG$N$_(B)
$B$,IUB0$7$F$$$^$9!#<+=,=q$r3+;O$9$k$K$O!"(BXEmacs $B3+;O8e$K!"(B^Ht (Control-h t) $B$r(B
$B%?%$%W$7$F$/$@$5$$!#%^%K%e%"%k$rFI$`$K$O!"(B^Hi$B!"$5$i$K>\$7$$%X%k%W>pJs$O!"(B
^H^H^H (Control-h $B$r(B 3 $B2s(B) $B$r%?%$%W$7$F$/$@$5$$!#(B\n"))
  (kill-emacs 0)))

;;; locale-start.el ends here
