;;; ucs-puncture.el --- UCS table of General Punctuation

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, General Punctuation

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

(require 'ucs-util)

;; EM SPACE;<compat> 0020
(ucs-set-char #x2003 ?$(G%m(B) ; C01-G-256D

;; HYPHEN
(ucs-set-char #x2010 ?$(@!>(B) ; J78-@-213E
(ucs-set-char #x2010 ?$(B!>(B) ; J83-B-213E

;; EN DASH
(ucs-set-char #x2013 ?$(G!9(B) ; C01-G-2139

;; EM DASH
(ucs-set-char #x2014 ?$(G!7(B) ; C01-G-2137
(ucs-set-char #x2014 ?$(@!=(B) ; J78-@-213D
(ucs-set-char #x2014 ?$(B!=(B) ; J83-B-213D

;; HORIZONTAL BAR
(ucs-set-char #x2015 ?$(C!*(B) ; KS0-C-212A
(ucs-set-char #x2015 ?$(A!*(B) ; GB0-A-212A
(ucs-set-char #x2015 ?-F) ; ISO-8859-7-AF-A

;; DOUBLE VERTICAL LINE
(ucs-set-char #x2016 ?$(G"](B) ; C01-G-225D
(ucs-set-char #x2016 ?$(A!,(B) ; GB0-A-212C
(ucs-set-char #x2016 ?$(@!B(B) ; J78-@-2142
(ucs-set-char #x2016 ?$(B!B(B) ; J83-B-2142

;; DOUBLE LOW LINE
(ucs-set-char #x2017 ?2]-Hߛ0]) ; ISO-8859-8-DF-A

;; LEFT SINGLE QUOTATION MARK
(ucs-set-char #x2018 ?$(G!d(B) ; C01-G-2164
(ucs-set-char #x2018 ?$(C!.(B) ; KS0-C-212E
(ucs-set-char #x2018 ?$(A!.(B) ; GB0-A-212E
(ucs-set-char #x2018 ?$(@!F(B) ; J78-@-2146
(ucs-set-char #x2018 ?$(B!F(B) ; J83-B-2146

;; RIGHT SINGLE QUOTATION MARK
(ucs-set-char #x2019 ?$(G!e(B) ; C01-G-2165
(ucs-set-char #x2019 ?$(C!/(B) ; KS0-C-212F
(ucs-set-char #x2019 ?$(A!/(B) ; GB0-A-212F
(ucs-set-char #x2019 ?$(@!G(B) ; J78-@-2147
(ucs-set-char #x2019 ?$(B!G(B) ; J83-B-2147

;; LEFT DOUBLE QUOTATION MARK
(ucs-set-char #x201C ?$(G!f(B) ; C01-G-2166
(ucs-set-char #x201C ?$(C!0(B) ; KS0-C-2130
(ucs-set-char #x201C ?$(A!0(B) ; GB0-A-2130
(ucs-set-char #x201C ?$(@!H(B) ; J78-@-2148
(ucs-set-char #x201C ?$(B!H(B) ; J83-B-2148

;; RIGHT DOUBLE QUOTATION MARK
(ucs-set-char #x201D ?$(G!g(B) ; C01-G-2167
(ucs-set-char #x201D ?$(C!1(B) ; KS0-C-2131
(ucs-set-char #x201D ?$(A!1(B) ; GB0-A-2131
(ucs-set-char #x201D ?$(@!I(B) ; J78-@-2149
(ucs-set-char #x201D ?$(B!I(B) ; J83-B-2149

;; DAGGER
(ucs-set-char #x2020 ?$(C"S(B) ; KS0-C-2253
(ucs-set-char #x2020 ?$(B"w(B) ; J83-B-2277

;; DOUBLE DAGGER
(ucs-set-char #x2021 ?$(C"T(B) ; KS0-C-2254
(ucs-set-char #x2021 ?$(B"x(B) ; J83-B-2278

;; TWO DOT LEADER
(ucs-set-char #x2025 ?$(C!%(B) ; KS0-C-2125
(ucs-set-char #x2025 ?$(G!-(B) ; C01-G-212D
(ucs-set-char #x2025 ?$(@!E(B) ; J78-@-2145
(ucs-set-char #x2025 ?$(B!E(B) ; J83-B-2145

;; HORIZONTAL ELLIPSIS
(ucs-set-char #x2026 ?$(G!,(B) ; C01-G-212C
(ucs-set-char #x2026 ?$(C!&(B) ; KS0-C-2126
(ucs-set-char #x2026 ?$(A!-(B) ; GB0-A-212D
(ucs-set-char #x2026 ?$(@!D(B) ; J78-@-2144
(ucs-set-char #x2026 ?$(B!D(B) ; J83-B-2144

;; HYPHENATION POINT
(ucs-set-char #x2027 ?$(G!1(B) ; C01-G-2131

;; PER MILLE SIGN
(ucs-set-char #x2030 ?$(C"6(B) ; KS0-C-2236
(ucs-set-char #x2030 ?$(A!k(B) ; GB0-A-216B
(ucs-set-char #x2030 ?$(B"s(B) ; J83-B-2273

;; PRIME
(ucs-set-char #x2032 ?$(G!k(B) ; C01-G-216B
(ucs-set-char #x2032 ?$(C!G(B) ; KS0-C-2147
(ucs-set-char #x2032 ?$(A!d(B) ; GB0-A-2164
(ucs-set-char #x2032 ?$(@!l(B) ; J78-@-216C
(ucs-set-char #x2032 ?$(B!l(B) ; J83-B-216C

;; DOUBLE PRIME
(ucs-set-char #x2033 ?$(C!H(B) ; KS0-C-2148
(ucs-set-char #x2033 ?$(A!e(B) ; GB0-A-2165
(ucs-set-char #x2033 ?$(@!m(B) ; J78-@-216D
(ucs-set-char #x2033 ?$(B!m(B) ; J83-B-216D

;; REVERSED PRIME
(ucs-set-char #x2035 ?$(G!j(B) ; C01-G-216A

;; REFERENCE MARK
(ucs-set-char #x203B ?$(G!o(B) ; C01-G-216F
(ucs-set-char #x203B ?$(C!X(B) ; KS0-C-2158
(ucs-set-char #x203B ?$(A!y(B) ; GB0-A-2179
(ucs-set-char #x203B ?$(@"((B) ; J78-@-2228
(ucs-set-char #x203B ?$(B"((B) ; J83-B-2228

;; OVERLINE
(ucs-set-char #x203E (make-char 'latin-jisx0201 (char-int ?~)))
(ucs-set-char #x203E ?2]-H0]) ; ISO-8859-8-AF-A
(ucs-set-char #x203E ?$(G"#(B) ; C01-G-2223
(ucs-set-char #x203E ?$(@!1(B) ; J78-@-2131
(ucs-set-char #x203E ?$(B!1(B) ; J83-B-2131

;;(ucs-set-char #x203E ?$(G"$(B) ; C01-G-2224

;; FRACTION SLASH
(ucs-set-char #x2044 ?$(G"_(B) ; C01-G-225F

;;; ucs-puncture.el ends here
