;;; uni-cjk-compat.el --- UCS table of CJK Compatibility

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, CJK Compatibility

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

(require 'ucs-util)

(ucs-set-char #x3380 ?$(C'I(B) ; KS0-C-2749

(ucs-set-char #x3381 ?$(C'J(B) ; KS0-C-274A

(ucs-set-char #x3382 ?$(C'K(B) ; KS0-C-274B

(ucs-set-char #x3383 ?$(C'L(B) ; KS0-C-274C

(ucs-set-char #x3384 ?$(C'M(B) ; KS0-C-274D

(ucs-set-char #x3388 ?$(C':(B) ; KS0-C-273A

(ucs-set-char #x3389 ?$(C';(B) ; KS0-C-273B

(ucs-set-char #x338A ?$(C'\(B) ; KS0-C-275C

(ucs-set-char #x338B ?$(C'](B) ; KS0-C-275D

(ucs-set-char #x338C ?$(C'^(B) ; KS0-C-275E

(ucs-set-char #x338D ?$(C'6(B) ; KS0-C-2736

(ucs-set-char #x338E ?$(C'7(B) ; KS0-C-2737
(ucs-set-char #x338E ?$(G"u(B) ; C01-G-2275

(ucs-set-char #x338F ?$(C'8(B) ; KS0-C-2738
(ucs-set-char #x338F ?$(G"v(B) ; C01-G-2276

(ucs-set-char #x3390 ?$(C'T(B) ; KS0-C-2754

(ucs-set-char #x3391 ?$(C'U(B) ; KS0-C-2755

(ucs-set-char #x3392 ?$(C'V(B) ; KS0-C-2756

(ucs-set-char #x3393 ?$(C'W(B) ; KS0-C-2757

(ucs-set-char #x3394 ?$(C'X(B) ; KS0-C-2758

(ucs-set-char #x3395 ?$(C'!(B) ; KS0-C-2721

(ucs-set-char #x3396 ?$(C'"(B) ; KS0-C-2722

(ucs-set-char #x3397 ?$(C'#(B) ; KS0-C-2723

(ucs-set-char #x3398 ?$(C'%(B) ; KS0-C-2725

(ucs-set-char #x3399 ?$(C'+(B) ; KS0-C-272B

(ucs-set-char #x339A ?$(C',(B) ; KS0-C-272C

(ucs-set-char #x339B ?$(C'-(B) ; KS0-C-272D

(ucs-set-char #x339C ?$(C'.(B) ; KS0-C-272E
(ucs-set-char #x339C ?$(G"p(B) ; C01-G-2270

(ucs-set-char #x339D ?$(G"q(B) ; C01-G-2271
(ucs-set-char #x339D ?$(C'/(B) ; KS0-C-272F

(ucs-set-char #x339E ?$(C'0(B) ; KS0-C-2730
(ucs-set-char #x339E ?$(G"r(B) ; C01-G-2272

(ucs-set-char #x339F ?$(C'1(B) ; KS0-C-2731

(ucs-set-char #x33A0 ?$(C'2(B) ; KS0-C-2732

(ucs-set-char #x33A1 ?$(C'3(B) ; KS0-C-2733
(ucs-set-char #x33A1 ?$(G"t(B) ; C01-G-2274

(ucs-set-char #x33A2 ?$(C'4(B) ; KS0-C-2734

(ucs-set-char #x33A3 ?$(C''(B) ; KS0-C-2727

(ucs-set-char #x33A4 ?$(C'((B) ; KS0-C-2728

(ucs-set-char #x33A5 ?$(C')(B) ; KS0-C-2729

(ucs-set-char #x33A6 ?$(C'*(B) ; KS0-C-272A

(ucs-set-char #x33A7 ?$(C'=(B) ; KS0-C-273D

(ucs-set-char #x33A8 ?$(C'>(B) ; KS0-C-273E

(ucs-set-char #x33A9 ?$(C'e(B) ; KS0-C-2765

(ucs-set-char #x33AA ?$(C'f(B) ; KS0-C-2766

(ucs-set-char #x33AB ?$(C'g(B) ; KS0-C-2767

(ucs-set-char #x33AC ?$(C'h(B) ; KS0-C-2768

(ucs-set-char #x33AD ?$(C'a(B) ; KS0-C-2761

(ucs-set-char #x33AE ?$(C'b(B) ; KS0-C-2762

(ucs-set-char #x33AF ?$(C'c(B) ; KS0-C-2763

(ucs-set-char #x33B0 ?$(C'?(B) ; KS0-C-273F

(ucs-set-char #x33B1 ?$(C'@(B) ; KS0-C-2740

(ucs-set-char #x33B2 ?$(C'A(B) ; KS0-C-2741

(ucs-set-char #x33B3 ?$(C'B(B) ; KS0-C-2742

(ucs-set-char #x33B4 ?$(C'C(B) ; KS0-C-2743

(ucs-set-char #x33B5 ?$(C'D(B) ; KS0-C-2744

(ucs-set-char #x33B6 ?$(C'E(B) ; KS0-C-2745

(ucs-set-char #x33B7 ?$(C'F(B) ; KS0-C-2746

(ucs-set-char #x33B8 ?$(C'G(B) ; KS0-C-2747

(ucs-set-char #x33B9 ?$(C'H(B) ; KS0-C-2748

(ucs-set-char #x33BA ?$(C'N(B) ; KS0-C-274E

(ucs-set-char #x33BB ?$(C'O(B) ; KS0-C-274F

(ucs-set-char #x33BC ?$(C'P(B) ; KS0-C-2750

(ucs-set-char #x33BD ?$(C'Q(B) ; KS0-C-2751

(ucs-set-char #x33BE ?$(C'R(B) ; KS0-C-2752

(ucs-set-char #x33BF ?$(C'S(B) ; KS0-C-2753

(ucs-set-char #x33C0 ?$(C'Z(B) ; KS0-C-275A

(ucs-set-char #x33C1 ?$(C'[(B) ; KS0-C-275B

(ucs-set-char #x33C2 ?$(C"c(B) ; KS0-C-2263

(ucs-set-char #x33C3 ?$(C'l(B) ; KS0-C-276C

(ucs-set-char #x33C4 ?$(C'&(B) ; KS0-C-2726
(ucs-set-char #x33C4 ?$(G"w(B) ; C01-G-2277

(ucs-set-char #x33C5 ?$(C'`(B) ; KS0-C-2760

(ucs-set-char #x33C6 ?$(C'o(B) ; KS0-C-276F

(ucs-set-char #x33C7 ?$(C"a(B) ; KS0-C-2261

(ucs-set-char #x33C8 ?$(C'<(B) ; KS0-C-273C

(ucs-set-char #x33C9 ?$(C'm(B) ; KS0-C-276D

(ucs-set-char #x33CA ?$(C'5(B) ; KS0-C-2735

(ucs-set-char #x33CE ?$(G"s(B) ; C01-G-2273

(ucs-set-char #x33CF ?$(C'9(B) ; KS0-C-2739

(ucs-set-char #x33D0 ?$(C'j(B) ; KS0-C-276A

(ucs-set-char #x33D1 ?$(G"L(B) ; C01-G-224C

(ucs-set-char #x33D2 ?$(G"K(B) ; C01-G-224B

(ucs-set-char #x33D3 ?$(C'k(B) ; KS0-C-276B

(ucs-set-char #x33D5 ?$(G"o(B) ; C01-G-226F

(ucs-set-char #x33D6 ?$(C'_(B) ; KS0-C-275F

(ucs-set-char #x33D8 ?$(C"d(B) ; KS0-C-2264

(ucs-set-char #x33DB ?$(C'd(B) ; KS0-C-2764

(ucs-set-char #x33DC ?$(C'n(B) ; KS0-C-276E

(ucs-set-char #x33DD ?$(C'i(B) ; KS0-C-2769

;;; uni-cjk-compat.el ends here
