;;; ucs-arrows.el --- UCS table of Arrows

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, Arrows

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

(require 'ucs-util)

;; LEFTWARDS ARROW
(ucs-set-char #x2190 ?$(G"X(B) ; C01-G-2258
(ucs-set-char #x2190 ?$(C!g(B) ; KS0-C-2167
(ucs-set-char #x2190 ?$A!{(B) ; GB0-A-217B
(ucs-set-char #x2190 ?$@"+(B) ; J78-@-222B
(ucs-set-char #x2190 ?$B"+(B) ; J83-B-222B

;; UPWARDS ARROW
(ucs-set-char #x2191 ?$(G"U(B) ; C01-G-2255
(ucs-set-char #x2191 ?$(C!h(B) ; KS0-C-2168
(ucs-set-char #x2191 ?$A!|(B) ; GB0-A-217C
(ucs-set-char #x2191 ?$@",(B) ; J78-@-222C
(ucs-set-char #x2191 ?$B",(B) ; J83-B-222C

;; RIGHTWARDS ARROW
(ucs-set-char #x2192 ?$(G"W(B) ; C01-G-2257
(ucs-set-char #x2192 ?$(C!f(B) ; KS0-C-2166
(ucs-set-char #x2192 ?$A!z(B) ; GB0-A-217A
(ucs-set-char #x2192 ?$@"*(B) ; J78-@-222A
(ucs-set-char #x2192 ?$B"*(B) ; J83-B-222A

;; DOWNWARDS ARROW
(ucs-set-char #x2193 ?$(G"V(B) ; C01-G-2256
(ucs-set-char #x2193 ?$(C!i(B) ; KS0-C-2169
(ucs-set-char #x2193 ?$A!}(B) ; GB0-A-217D
(ucs-set-char #x2193 ?$@"-(B) ; J78-@-222D
(ucs-set-char #x2193 ?$B"-(B) ; J83-B-222D

;; LEFT RIGHT ARROW
(ucs-set-char #x2194 ?$(C!j(B) ; KS0-C-216A

;; UP DOWN ARROW
(ucs-set-char #x2195 ?$(C"U(B) ; KS0-C-2255

;; NORTH WEST ARROW
(ucs-set-char #x2196 ?$(G"Y(B) ; C01-G-2259
(ucs-set-char #x2196 ?$(C"X(B) ; KS0-C-2258

;; NORTH EAST ARROW
(ucs-set-char #x2197 ?$(G"Z(B) ; C01-G-225A
(ucs-set-char #x2197 ?$(C"V(B) ; KS0-C-2256

;; SOUTH EAST ARROW
(ucs-set-char #x2198 ?$(G"\(B) ; C01-G-225C
(ucs-set-char #x2198 ?$(C"Y(B) ; KS0-C-2259

;; SOUTH WEST ARROW
(ucs-set-char #x2199 ?$(G"[(B) ; C01-G-225B
(ucs-set-char #x2199 ?$(C"W(B) ; KS0-C-2257

;; RIGHTWARDS DOUBLE ARROW
(ucs-set-char #x21D2 ?$(C"!(B) ; KS0-C-2221
(ucs-set-char #x21D2 ?$B"M(B) ; J83-B-224D

;; LEFT RIGHT DOUBLE ARROW
(ucs-set-char #x21D4 ?$(C""(B) ; KS0-C-2222
(ucs-set-char #x21D4 ?$B"N(B) ; J83-B-224E

;;; ucs-arrows.el ends here
