/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.puppycrawl.tools.checkstyle.AuditEvent;
import com.puppycrawl.tools.checkstyle.AuditListener;
import com.puppycrawl.tools.checkstyle.Configuration;
import com.puppycrawl.tools.checkstyle.Defn;
import com.puppycrawl.tools.checkstyle.GeneratedJava14Lexer;
import com.puppycrawl.tools.checkstyle.GeneratedJava14Recognizer;
import com.puppycrawl.tools.checkstyle.GeneratedJavaLexer;
import com.puppycrawl.tools.checkstyle.GeneratedJavaRecognizer;
import com.puppycrawl.tools.checkstyle.LineText;
import com.puppycrawl.tools.checkstyle.PropertyCacheFile;
import com.puppycrawl.tools.checkstyle.StringArrayReader;
import com.puppycrawl.tools.checkstyle.Verifier;
import com.puppycrawl.tools.checkstyle.VerifierSingleton;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.regexp.RESyntaxException;

public class Checker
implements Defn {
    private final Configuration mConfig;
    private final PropertyCacheFile mCache;
    private final ArrayList mListeners = new ArrayList();
    static /* synthetic */ Class class$com$puppycrawl$tools$checkstyle$MyCommonAST;

    public Checker(Configuration aConfig) throws RESyntaxException {
        this.mConfig = aConfig;
        this.mCache = new PropertyCacheFile(aConfig);
        Verifier v = new Verifier(aConfig);
        VerifierSingleton.setInstance(v);
    }

    public void destroy() {
        this.mCache.destroy();
        this.mListeners.clear();
    }

    public void addListener(AuditListener aListener) {
        this.mListeners.add(aListener);
    }

    public int process(String[] aFiles) {
        int total = 0;
        this.fireAuditStarted();
        total += this.checkPackageHtml(aFiles);
        int i = 0;
        while (i < aFiles.length) {
            total += this.process(aFiles[i]);
            ++i;
        }
        this.fireAuditFinished();
        return total;
    }

    private int process(String aFileName) {
        LineText[] errors;
        String stripped;
        File f = new File(aFileName);
        long timestamp = f.lastModified();
        if (this.mCache.alreadyChecked(aFileName, timestamp)) {
            return 0;
        }
        String basedir = this.mConfig.getBasedir();
        if (basedir == null || !aFileName.startsWith(basedir)) {
            stripped = aFileName;
        } else {
            int skipSep = basedir.endsWith(File.separator) ? 0 : 1;
            stripped = aFileName.substring(basedir.length() + skipSep);
        }
        try {
            this.fireFileStarted(stripped);
            String[] lines = this.getLines(aFileName);
            try {
                VerifierSingleton.getInstance().clearMessages();
                VerifierSingleton.getInstance().setLines(lines);
                StringArrayReader sar = new StringArrayReader(lines);
                GeneratedJava14Lexer jl = new GeneratedJava14Lexer(sar);
                jl.setFilename(aFileName);
                SilentJava14Recognizer jr = new SilentJava14Recognizer(jl);
                jr.setFilename(aFileName);
                jr.setASTNodeClass((class$com$puppycrawl$tools$checkstyle$MyCommonAST == null ? (class$com$puppycrawl$tools$checkstyle$MyCommonAST = Checker.class$("com.puppycrawl.tools.checkstyle.MyCommonAST")) : class$com$puppycrawl$tools$checkstyle$MyCommonAST).getName());
                jr.compilationUnit();
            }
            catch (RecognitionException re) {
                VerifierSingleton.getInstance().clearMessages();
                VerifierSingleton.getInstance().setLines(lines);
                StringArrayReader sar = new StringArrayReader(lines);
                GeneratedJavaLexer jl = new GeneratedJavaLexer(sar);
                jl.setFilename(aFileName);
                GeneratedJavaRecognizer jr = new GeneratedJavaRecognizer(jl);
                jr.setFilename(aFileName);
                jr.setASTNodeClass((class$com$puppycrawl$tools$checkstyle$MyCommonAST == null ? (class$com$puppycrawl$tools$checkstyle$MyCommonAST = Checker.class$("com.puppycrawl.tools.checkstyle.MyCommonAST")) : class$com$puppycrawl$tools$checkstyle$MyCommonAST).getName());
                jr.compilationUnit();
            }
            errors = VerifierSingleton.getInstance().getMessages();
        }
        catch (FileNotFoundException fnfe) {
            errors = new LineText[]{new LineText(0, "File not found!")};
        }
        catch (IOException ioe) {
            errors = new LineText[]{new LineText(0, "Got an IOException -" + ioe.getMessage())};
        }
        catch (RecognitionException re) {
            errors = new LineText[]{new LineText(0, "Got a RecognitionException -" + re.getMessage())};
        }
        catch (TokenStreamException te) {
            errors = new LineText[]{new LineText(0, "Got a TokenStreamException -" + te.getMessage())};
        }
        if (errors.length == 0) {
            this.mCache.checkedOk(aFileName, timestamp);
        } else {
            this.fireErrors(stripped, errors);
        }
        this.fireFileFinished(stripped);
        return errors.length;
    }

    private int checkPackageHtml(String[] aFiles) {
        if (!this.mConfig.isRequirePackageHtml()) {
            return 0;
        }
        int packageHtmlErrors = 0;
        HashSet<File> checkedPackages = new HashSet<File>();
        int i = 0;
        while (i < aFiles.length) {
            File file = new File(aFiles[i]);
            File packageDir = file.getParentFile();
            if (!checkedPackages.contains(packageDir)) {
                File packageDoc = new File(packageDir, "package.html");
                String docFile = packageDoc.toString();
                this.fireFileStarted(docFile);
                if (!packageDoc.exists()) {
                    LineText error = new LineText(0, "missing package documentation file.");
                    this.fireErrors(docFile, new LineText[]{error});
                    ++packageHtmlErrors;
                }
                this.fireFileFinished(docFile);
                checkedPackages.add(packageDir);
            }
            ++i;
        }
        return packageHtmlErrors;
    }

    private String[] getLines(String aFileName) throws IOException {
        String l;
        LineNumberReader lnr = new LineNumberReader(new FileReader(aFileName));
        ArrayList<String> lines = new ArrayList<String>();
        while ((l = lnr.readLine()) != null) {
            lines.add(l);
        }
        return lines.toArray(new String[0]);
    }

    protected void fireAuditStarted() {
        AuditEvent evt = new AuditEvent(this);
        Iterator it = ((AbstractList)this.mListeners).iterator();
        while (it.hasNext()) {
            AuditListener listener = (AuditListener)it.next();
            listener.auditStarted(evt);
        }
    }

    protected void fireAuditFinished() {
        AuditEvent evt = new AuditEvent(this);
        Iterator it = ((AbstractList)this.mListeners).iterator();
        while (it.hasNext()) {
            AuditListener listener = (AuditListener)it.next();
            listener.auditFinished(evt);
        }
    }

    protected void fireFileStarted(String aFileName) {
        AuditEvent evt = new AuditEvent(this, aFileName);
        Iterator it = ((AbstractList)this.mListeners).iterator();
        while (it.hasNext()) {
            AuditListener listener = (AuditListener)it.next();
            listener.fileStarted(evt);
        }
    }

    protected void fireFileFinished(String aFileName) {
        AuditEvent evt = new AuditEvent(this, aFileName);
        Iterator it = ((AbstractList)this.mListeners).iterator();
        while (it.hasNext()) {
            AuditListener listener = (AuditListener)it.next();
            listener.fileFinished(evt);
        }
    }

    protected void fireErrors(String aFileName, LineText[] aErrors) {
        int i = 0;
        while (i < aErrors.length) {
            AuditEvent evt = new AuditEvent(this, aFileName, aErrors[i].getLineNo(), aErrors[i].getColumnNo(), aErrors[i].getText());
            Iterator it = ((AbstractList)this.mListeners).iterator();
            while (it.hasNext()) {
                AuditListener listener = (AuditListener)it.next();
                listener.addError(evt);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SilentJava14Recognizer
    extends GeneratedJava14Recognizer {
        private SilentJava14Recognizer(GeneratedJava14Lexer aLexer) {
            super(aLexer);
        }

        public void reportError(RecognitionException aRex) {
        }

        public void reportError(String aMsg) {
        }

        public void reportWarning(String aMsg) {
        }
    }
}

