;;; xlib-xtest.el --- XTEST extension for xlib.

;; Copyright (C) 2003 by Free Software Foundation, Inc.

;; Author: Zajcev Evgeny <zevlg@yandex.ru>
;; Created: 18 October 2003
;; Keywords: xlib, xwem
;; X-CVS: $Id: xlib-xtest.el,v 1.4 2005/01/01 04:40:17 youngs Exp $
;; X-URL: http://lgarc.narod.ru/xwem/index.html

;; This file is part of XWEM.

;; XWEM is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XWEM is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Synched up with: Not in FSF

;;; Commentary:

;; 

;;; TODO:

;;    * add X-XTestGetVersion, X-XTestCompareCursor, X-XTestGrabControl

;;; Code:

(require 'xlib-xlib)

(defconst X-XTest-op-GetVersion	0)
(defconst X-XTest-op-CompareCursor	1)
(defconst X-XTest-op-FakeInput		2)
(defconst X-XTest-op-GrabControl	3)

(defconst X-Xtest-KeyPress 2)
(defconst X-Xtest-KeyRelease 3)
(defconst X-Xtest-ButtonPress 4)
(defconst X-Xtest-ButtonRelease 5)
(defconst X-Xtest-MotionNotify 6)

(defun X-XTest-FakeInput (xdpy evtype detail root rootx rooty &optional time)
  "On display XDPY send fake event of EVTYPE with DETAIL at TIME."
  (X-Dpy-p xdpy 'X-XTest-FakeInput)

  (let* ((test-ext (X-Dpy-get-extension xdpy "XTEST" 'X-XTest-FakeInput))
	 (ListOfFields
	  (list (vector 1 (nth 4 test-ext)) ; opcode
		[1 X-XTest-op-FakeInput]
		[2 (+ 1 (* 1 8))]	;length

		[1 evtype]
		[1 detail]
		[2 nil]			;pad
		[4 (or time X-CurrentTime)]
		[4 (if (X-Win-p root) (X-Win-id root) root)]
		[8 nil]
		[2 rootx]
		[2 rooty]
		[8 nil]
		))
	 (msg (X-Create-message ListOfFields)))
    (X-Dpy-send xdpy msg)))

(provide 'xlib-xtest)

;;; xlib-xtest.el ends here
