/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHBinaryExpression;
import bsh.BSHLHSPrimaryExpression;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterConstants;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.SimpleNode;

class BSHAssignment
extends SimpleNode
implements InterpreterConstants {
    public int operator;

    BSHAssignment(int n) {
        super(n);
    }

    public Object eval(NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        LHS lHS = ((BSHLHSPrimaryExpression)this.jjtGetChild(0)).toLHS(nameSpace, interpreter);
        Object object = ((SimpleNode)this.jjtGetChild(1)).eval(nameSpace, interpreter);
        if (object == Primitive.VOID) {
            throw new EvalError("Void assignment.", this);
        }
        if (lHS == null) {
            throw new EvalError("Error, can't assign to null...??", this);
        }
        switch (this.operator) {
            case 70: {
                return lHS.assign(object);
            }
            case 107: {
                return lHS.assign(this.operation(lHS.getValue(), object, 91));
            }
            case 108: {
                return lHS.assign(this.operation(lHS.getValue(), object, 92));
            }
            case 109: {
                return lHS.assign(this.operation(lHS.getValue(), object, 93));
            }
            case 110: {
                return lHS.assign(this.operation(lHS.getValue(), object, 94));
            }
            case 111: 
            case 112: {
                return lHS.assign(this.operation(lHS.getValue(), object, 95));
            }
            case 113: 
            case 114: {
                return lHS.assign(this.operation(lHS.getValue(), object, 97));
            }
            case 115: {
                return lHS.assign(this.operation(lHS.getValue(), object, 99));
            }
            case 116: {
                return lHS.assign(this.operation(lHS.getValue(), object, 100));
            }
            case 117: 
            case 118: {
                return lHS.assign(this.operation(lHS.getValue(), object, 101));
            }
            case 119: 
            case 120: {
                return lHS.assign(this.operation(lHS.getValue(), object, 103));
            }
            case 121: 
            case 122: {
                return lHS.assign(this.operation(lHS.getValue(), object, 105));
            }
        }
        throw new InterpreterError("unimplemented operator in assignment BSH");
    }

    private Object operation(Object object, Object object2, int n) throws EvalError {
        if (object instanceof Primitive || object2 instanceof Primitive) {
            if (object == Primitive.VOID || object2 == Primitive.VOID) {
                throw new EvalError("Illegal use of undefined object or 'void' literal", this);
            }
            if (object == Primitive.NULL || object2 == Primitive.NULL) {
                throw new EvalError("Illegal use of null object or 'null' literal", this);
            }
        }
        if ((object instanceof Boolean || object instanceof Character || object instanceof Number || object instanceof Primitive) && (object2 instanceof Boolean || object2 instanceof Character || object2 instanceof Number || object2 instanceof Primitive)) {
            return BSHBinaryExpression.primitiveBinaryOperation(object, object2, n);
        }
        if (object instanceof String && object2 instanceof String) {
            return (String)object + (String)object2;
        }
        throw new EvalError("Non primitive value in operator: " + object.getClass() + " " + InterpreterConstants.tokenImage[n] + " " + object2.getClass(), this);
    }
}

