/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.util.Map;
import jde.debugger.Application;
import jde.debugger.Debug;
import jde.debugger.JDEException;
import jde.debugger.Jdebug;
import jde.debugger.command.DebugSessionCommand;

public class AttachShmem
extends DebugSessionCommand {
    protected void doCommand() throws JDEException {
        String connectSpec = null;
        connectSpec = "com.sun.jdi.SharedMemoryAttach";
        AttachingConnector connector = (AttachingConnector)this.getConnector(connectSpec);
        if (connector == null) {
            throw new JDEException("No such connector is available: " + connectSpec);
        }
        if (this.args.size() < 1) {
            throw new JDEException("Missing name");
        }
        try {
            Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
            Connector.Argument nameArg = argumentMap.get("name");
            nameArg.setValue(this.args.remove(0).toString());
            VirtualMachine vm = connector.attach(argumentMap);
            Application app = new Application(Jdebug.theDebugger, this.appID, vm);
            if (Jdebug.theDebugger.appExists(this.appID)) {
                app.shutdown();
                throw new JDEException("An application with the ID" + this.appID + " already exists.");
            }
            Jdebug.theDebugger.addApplication(this.appID, app);
            app.signalCommandResult(this.cmdID);
            app.signal("message", "Attached VM (shmem) " + vm.description());
        }
        catch (IOException ex) {
            Debug.printIf(ex);
            throw new JDEException("Error attempting to attach to process via shared memory.");
        }
        catch (IllegalConnectorArgumentsException ex) {
            throw new JDEException("Illegal connector arguments for connector '" + connector);
        }
    }

    public Object clone() {
        return new AttachShmem();
    }
}

