/*
 * Decompiled with CFR 0.152.
 */
package jde.parser;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import jde.parser.JavaParser;
import jde.parser.ParseException;
import jde.parser.syntaxtree.CompilationUnit;
import jde.parser.syntaxtree.Expression;
import jde.parser.visitor.GetVariablesVisitor;
import jde.parser.visitor.TreeDumper;

public class ParserMain {
    static JavaParser parser;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Java Parser Version 1.1:  Reading from standard input . . .");
            JavaParser javaParser = new JavaParser(System.in);
        } else if (stringArray.length == 1) {
            System.out.println("Java Parser Version 1.1:  Reading from file " + stringArray[0] + " . . .");
            try {
                JavaParser javaParser = new JavaParser(new FileInputStream(stringArray[0]));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Java Parser Version 1.1:  File " + stringArray[0] + " not found.");
                return;
            }
        } else {
            System.out.println("Java Parser Version 1.1:  Usage is one of:");
            System.out.println("         java JavaParser < inputfile");
            System.out.println("OR");
            System.out.println("         java JavaParser inputfile");
            return;
        }
        try {
            Expression expression = JavaParser.Expression();
            System.out.println("Java Parser Version 1.1:  Java program parsed successfully.");
            expression.accept(new TreeDumper());
        }
        catch (ParseException parseException) {
            System.out.println(parseException.getMessage());
            System.out.println("Java Parser Version 1.1:  Encountered errors during parse.");
        }
    }

    public static void parseFile(String string) {
        try {
            if (parser == null) {
                parser = new JavaParser(new FileInputStream(string));
            } else {
                JavaParser.ReInit(new FileInputStream(string));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            ParserMain.println("\"Parser error:  File " + string + " not found.\"");
            return;
        }
        try {
            JavaParser.CompilationUnit();
            ParserMain.println("nil");
        }
        catch (ParseException parseException) {
            String string2 = parseException.getMessage().replace('\"', '\'');
            ParserMain.println("\"" + string2 + "\"");
        }
    }

    public static void println(String string) {
        System.out.print(string + "\n");
        System.out.flush();
    }

    public static void getVariables(String string) {
        try {
            if (parser == null) {
                parser = new JavaParser(new FileInputStream(string));
            } else {
                JavaParser.ReInit(new FileInputStream(string));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            ParserMain.println("\"Parser error:  File " + string + " not found.\"");
            return;
        }
        try {
            CompilationUnit compilationUnit = JavaParser.CompilationUnit();
            ParserMain.println("nil");
            compilationUnit.accept(new GetVariablesVisitor());
        }
        catch (ParseException parseException) {
            String string2 = parseException.getMessage().replace('\"', '\'');
            ParserMain.println("\"" + string2 + "\"");
        }
    }
}

