/*
 This file is part of GNU Taler
 (C) 2021-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */
import { TalerMerchantApi } from "@gnu-taler/taler-util";
import { Query } from "@gnu-taler/web-util/testing";

////////////////////
// ORDER
////////////////////

export const API_CREATE_ORDER: Query<
  TalerMerchantApi.PostOrderRequest,
  TalerMerchantApi.PostOrderResponse
> = {
  method: "POST",
  url: "http://backend/instances/default/private/orders",
};

export const API_GET_ORDER_BY_ID = (
  id: string,
): Query<unknown, TalerMerchantApi.MerchantOrderStatusResponse> => ({
  method: "GET",
  url: `http://backend/instances/default/private/orders/${id}`,
});

export const API_LIST_ORDERS: Query<unknown, TalerMerchantApi.OrderHistory> = {
  method: "GET",
  url: "http://backend/instances/default/private/orders",
};

export const API_REFUND_ORDER_BY_ID = (
  id: string,
): Query<
  TalerMerchantApi.RefundRequest,
  TalerMerchantApi.MerchantRefundResponse
> => ({
  method: "POST",
  url: `http://backend/instances/default/private/orders/${id}/refund`,
});

export const API_FORGET_ORDER_BY_ID = (
  id: string,
): Query<TalerMerchantApi.ForgetRequest, unknown> => ({
  method: "PATCH",
  url: `http://backend/instances/default/private/orders/${id}/forget`,
});

export const API_DELETE_ORDER = (
  id: string,
): Query<TalerMerchantApi.ForgetRequest, unknown> => ({
  method: "DELETE",
  url: `http://backend/instances/default/private/orders/${id}`,
});

////////////////////
// TRANSFER
////////////////////

export const API_LIST_TRANSFERS: Query<unknown, TalerMerchantApi.TransferList> =
  {
    method: "GET",
    url: "http://backend/instances/default/private/transfers",
  };

export const API_INFORM_TRANSFERS: Query<
  TalerMerchantApi.TransferInformation,
  {}
> = {
  method: "POST",
  url: "http://backend/instances/default/private/transfers",
};

////////////////////
// PRODUCT
////////////////////

export const API_CREATE_PRODUCT: Query<
  TalerMerchantApi.ProductAddDetail,
  unknown
> = {
  method: "POST",
  url: "http://backend/instances/default/private/products",
};

export const API_LIST_PRODUCTS: Query<
  unknown,
  TalerMerchantApi.InventorySummaryResponse
> = {
  method: "GET",
  url: "http://backend/instances/default/private/products",
};

export const API_GET_PRODUCT_BY_ID = (
  id: string,
): Query<unknown, TalerMerchantApi.ProductDetail> => ({
  method: "GET",
  url: `http://backend/instances/default/private/products/${id}`,
});

export const API_UPDATE_PRODUCT_BY_ID = (
  id: string,
): Query<
  TalerMerchantApi.ProductPatchDetail,
  TalerMerchantApi.InventorySummaryResponse
> => ({
  method: "PATCH",
  url: `http://backend/instances/default/private/products/${id}`,
});

export const API_DELETE_PRODUCT = (id: string): Query<unknown, unknown> => ({
  method: "DELETE",
  url: `http://backend/instances/default/private/products/${id}`,
});

////////////////////
// INSTANCE ADMIN
////////////////////

export const API_CREATE_INSTANCE: Query<
  TalerMerchantApi.InstanceConfigurationMessage,
  unknown
> = {
  method: "POST",
  url: "http://backend/management/instances",
};

export const API_GET_INSTANCE_BY_ID = (
  id: string,
): Query<unknown, TalerMerchantApi.QueryInstancesResponse> => ({
  method: "GET",
  url: `http://backend/management/instances/${id}`,
});

export const API_GET_INSTANCE_KYC_BY_ID = (
  id: string,
): Query<unknown, TalerMerchantApi.MerchantAccountKycRedirectsResponse> => ({
  method: "GET",
  url: `http://backend/management/instances/${id}/kyc`,
});

export const API_LIST_INSTANCES: Query<
  unknown,
  TalerMerchantApi.InstancesResponse
> = {
  method: "GET",
  url: "http://backend/management/instances",
};

export const API_UPDATE_INSTANCE_BY_ID = (
  id: string,
): Query<TalerMerchantApi.InstanceReconfigurationMessage, unknown> => ({
  method: "PATCH",
  url: `http://backend/management/instances/${id}`,
});

export const API_UPDATE_INSTANCE_AUTH_BY_ID = (
  id: string,
): Query<TalerMerchantApi.InstanceAuthConfigurationMessage, unknown> => ({
  method: "POST",
  url: `http://backend/management/instances/${id}/auth`,
});

export const API_DELETE_INSTANCE = (id: string): Query<unknown, unknown> => ({
  method: "DELETE",
  url: `http://backend/management/instances/${id}`,
});

////////////////////
// INSTANCE
////////////////////

export const API_GET_CURRENT_INSTANCE: Query<
  unknown,
  TalerMerchantApi.QueryInstancesResponse
> = {
  method: "GET",
  url: `http://backend/instances/default/private/`,
};

export const API_GET_CURRENT_INSTANCE_KYC: Query<
  unknown,
  TalerMerchantApi.MerchantAccountKycRedirectsResponse
> = {
  method: "GET",
  url: `http://backend/instances/default/private/kyc`,
};

export const API_UPDATE_CURRENT_INSTANCE: Query<
  TalerMerchantApi.InstanceReconfigurationMessage,
  unknown
> = {
  method: "PATCH",
  url: `http://backend/instances/default/private/`,
};

export const API_UPDATE_CURRENT_INSTANCE_AUTH: Query<
  TalerMerchantApi.InstanceAuthConfigurationMessage,
  unknown
> = {
  method: "POST",
  url: `http://backend/instances/default/private/auth`,
};

export const API_DELETE_CURRENT_INSTANCE: Query<unknown, unknown> = {
  method: "DELETE",
  url: `http://backend/instances/default/private`,
};
