/*
 This file is part of GNU Taler
 (C) 2025 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Imports.
 */
import { ContactEntry, j2s } from "@gnu-taler/taler-util";
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { GlobalTestState } from "../harness/harness.js";
import {
  createSimpleTestkudosEnvironmentV3,
  createWalletDaemonWithClient,
  withdrawViaBankV3,
} from "../harness/environments.js";

/**
 * Run test for basic contact operations.
 */
export async function runWalletContactsBasicTest(t: GlobalTestState) {
  // Set up test environment

  const { commonDb, merchant, walletClient, bankClient, exchange } =
    await createSimpleTestkudosEnvironmentV3(t);

  const contactBob: ContactEntry = {
    alias: "bobexample.com",
    aliasType: "email",
    petname: "",
    mailboxBaseUri: "https://mailbox.example.com",
    mailboxAddress: "BOBPKEY",
    source: "test"
  };
  const contactAlice: ContactEntry = {
    alias: "@alice",
    aliasType: "social",
    petname: "",
    mailboxBaseUri: "https://mailbox.example.com",
    mailboxAddress: "ALICEPKEY",
    source: "test"
  };
   await walletClient.call(WalletApiOperation.AddContact, {
    contact: contactAlice,
  });
   await walletClient.call(WalletApiOperation.AddContact, {
    contact: contactBob,
  });


  {
    const bi = await walletClient.call(WalletApiOperation.GetContacts, {});
    t.assertDeepEqual(bi.contacts.length, 2);
  }

  await walletClient.call(WalletApiOperation.DeleteContact, {
    contact: contactBob,
  });

  {
    const bi = await walletClient.call(WalletApiOperation.GetContacts, {});
    t.assertDeepEqual(bi.contacts.length, 1);
    t.assertDeepEqual(bi.contacts[0].alias, "@alice");
  }

}

runWalletContactsBasicTest.suites = ["wallet", "wallet-contacts"];
runWalletContactsBasicTest.experimental = true;
