/* access to the X toolkit for Sather
 * (c) 1995/01/16 - 1995/01/31 by Erik Schnetter
 */

#include <System/header.h>
#include <X11/Intrinsic.h>
#include <alloca.h>



Widget Xt_CreateManagedWidget
  (CHAR* name, WidgetClass widget_class, Widget parent,
   CHAR** arg_name, void** arg_val_ptr, INT* arg_val_int, INT nargs)
{
  int i;
  ArgList args = (ArgList) alloca (nargs * sizeof(Arg));
  if (!args)
    fprintf (stderr, "C_XT_WIDGET::Xt_CreateManagedWidget: "
	     "could not allocate memory\n");
  for (i=nargs; i--;) {
    args[i].name  = arg_name[i];
    args[i].value =
      (arg_val_int[i] ? (XtArgVal) arg_val_int[i] : (XtArgVal) arg_val_ptr[i]);
  }
  return XtCreateManagedWidget (name, widget_class, parent, args, nargs);
}

void Xt_RealizeWidget (Widget widget)
{
  XtRealizeWidget (widget);
}

void Xt_UnrealizeWidget (Widget widget)
{
  XtUnrealizeWidget (widget);
}

void Xt_DestroyWidget (Widget widget)
{
  XtDestroyWidget (widget);
}

void C_XT_WIDGET_Xt_HandleCallback
  (Widget widget, INT callback, EXT_OB call_data);

void XtHandleCallback (Widget widget, XtPointer closure, XtPointer call_data)
{
  C_XT_WIDGET_Xt_HandleCallback (widget, (INT)closure, call_data);
}

void Xt_AddCallback (Widget widget, CHAR* name, INT callback)
{
  XtAddCallback (widget, name, XtHandleCallback, (XtPointer)callback);
}
