/* -*-C-*-
 * access to the X Window System for Sather
 * (c) 1995/01/12 - 1995/02/19 by Erik Schnetter
 */

#include <malloc.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "header.h"



INT X_IconSize_size (void)
{ return (sizeof(XIconSize)+sizeof(INT)-1)/sizeof(INT); }



void X_IconSize_min_width_set (XIconSize* icon_size, INT min_width)
{ icon_size->min_width = min_width; }

void X_IconSize_min_height_set (XIconSize* icon_size, INT min_height)
{ icon_size->min_height = min_height; }

void X_IconSize_max_width_set (XIconSize* icon_size, INT max_width)
{ icon_size->max_width = max_width; }

void X_IconSize_max_height_set (XIconSize* icon_size, INT max_height)
{ icon_size->max_height = max_height; }

void X_IconSize_width_inc_set (XIconSize* icon_size, INT width_inc)
{ icon_size->width_inc = width_inc; }

void X_IconSize_height_inc_set (XIconSize* icon_size, INT height_inc)
{ icon_size->height_inc = height_inc; }



INT X_IconSize_min_width_get (XIconSize* icon_size)
{ return icon_size->min_width; }

INT X_IconSize_min_height_get (XIconSize* icon_size)
{ return icon_size->min_height; }

INT X_IconSize_max_width_get (XIconSize* icon_size)
{ return icon_size->max_width; }

INT X_IconSize_max_height_get (XIconSize* icon_size)
{ return icon_size->max_height; }

INT X_IconSize_width_inc_get (XIconSize* icon_size)
{ return icon_size->width_inc; }

INT X_IconSize_height_inc_get (XIconSize* icon_size)
{ return icon_size->height_inc; }



XIconSize* X_SetIconSizes_first (INT count)
{
  return (XIconSize*) malloc (count * sizeof(XIconSize));
}

void X_SetIconSizes_loop (XIconSize* list, INT index, XIconSize* icon_size)
{
  list[index] = *icon_size;
}

void X_SetIconSizes_last
  (Display* display, INT window, XIconSize* icon_size_list, INT count)
{
  XSetIconSizes (display, window, icon_size_list, count);
  free (icon_size_list);
}



BOOL X_GetIconSizes_first
  (Display* display, INT window, XIconSize** list, INT* ints)
{
  Status res;
  int count;
  res = XGetIconSizes (display, window, list, &count);
  ints[0] = count;
  return res;
}

void X_GetIconSizes_loop (XIconSize* list, INT index, XIconSize* icon_size)
{
  *icon_size = list[index];
}
