/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "BoardTest.h"
#include "Board.h"
#include "Case.h"
#include "Player.h"
#include "BoardException.h"
#include <iostream>


int BoardTest::testAll(){return testAddCase()+testWhoISTheCurrentUser();}

BoardTest::BoardTest(void)
{
}


BoardTest::~BoardTest(void)
{
}

int BoardTest::testAddCase(){
	Board bBoard(10,10);
	Case cCase;
	cCase.setCityCenter(true);
	cCase.setCaseType(Case::SELECTED);
	Player player("JoueurTest");
	cCase.setPlayer(&player);
	bBoard.setCase(5,5,cCase);
	bool errorDetected=false;
	bool badPool=true;
	try {
		bBoard.setCase(50,50,cCase);
		badPool=false;
	}catch (BoardException bo)
	{
	
	}
	if (!badPool)
	{
		std::cout << "ERROR : testAddCase SetCase Exception not detected"<<std::endl;
		errorDetected=true;
	}
	badPool=true;

	try {
		bBoard.getCaseNoThrow(50,50);
		badPool=false;
	}catch (BoardException bo)
	{
	}
	
	//std::cout << bBoard.toString()<<std::endl;
	if (bBoard.getCaseNoThrow(5,5)->getPlayer()!=&player)
	{
		std::cout << "ERROR : testAddCase player not good on 5x5"<<std::endl;
		errorDetected=true;
	}
	if (bBoard.getCaseNoThrow(4,4)->getPlayer()!=NULL)
	{
		std::cout << "ERROR : testAddCase player not good on 4x4"<<std::endl;
		errorDetected=true;
	}
	if (!errorDetected)
	{
		std::cout << "OK : testAddCase testAddCase"<<std::endl;
	}
	
	return errorDetected;
	
	

}

int BoardTest::testWhoISTheCurrentUser(){
	Board bBoard(10,10);
	Player * pla=bBoard.getOrCreatePlayerByName("Felix");
	bBoard.setActualPlayer(pla);
	if (bBoard.getActualPlayer()==NULL)
	{
		std::cout << "ERROR : player not good "<<bBoard.getActualPlayer()<<std::endl;
		
	}else
	if (bBoard.getActualPlayer()->getName()!="Felix")
	{
		return 1;
		std::cout << "ERROR : player not good "<<bBoard.getActualPlayer()->getName()<<std::endl;
	}
		
	else
	{
		return 0;
		std::cout << "OK : testWhoISTheCurrentUser"<<std::endl;
	}
    return 1;
}
