'use strict';


var NIL  = require('../common').NIL;
var Type = require('../type');


var YAML_IMPLICIT_BOOLEAN_MAP = {
  'true'  : true,
  'True'  : true,
  'TRUE'  : true,
  'false' : false,
  'False' : false,
  'FALSE' : false
};

var YAML_EXPLICIT_BOOLEAN_MAP = {
  'true'  : true,
  'True'  : true,
  'TRUE'  : true,
  'false' : false,
  'False' : false,
  'FALSE' : false,
  'y'     : true,
  'Y'     : true,
  'yes'   : true,
  'Yes'   : true,
  'YES'   : true,
  'n'     : false,
  'N'     : false,
  'no'    : false,
  'No'    : false,
  'NO'    : false,
  'on'    : true,
  'On'    : true,
  'ON'    : true,
  'off'   : false,
  'Off'   : false,
  'OFF'   : false
};


function resolveYamlBoolean(object, explicit) {
  if (explicit) {
    if (YAML_EXPLICIT_BOOLEAN_MAP.hasOwnProperty(object)) {
      return YAML_EXPLICIT_BOOLEAN_MAP[object];
    } else {
      return NIL;
    }
  } else {
    if (YAML_IMPLICIT_BOOLEAN_MAP.hasOwnProperty(object)) {
      return YAML_IMPLICIT_BOOLEAN_MAP[object];
    } else {
      return NIL;
    }
  }
}


module.exports = new Type('tag:yaml.org,2002:bool', {
  loader: {
    kind: 'string',
    resolver: resolveYamlBoolean
  },
  dumper: {
    kind: 'boolean',
    defaultStyle: 'lowercase',
    representer: {
      lowercase: function (object) { return object ? 'true' : 'false'; },
      uppercase: function (object) { return object ? 'TRUE' : 'FALSE'; },
      camelcase: function (object) { return object ? 'True' : 'False'; }
    }
  }
});
