/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- 
 * $Id: OPload.java,v 1.1 2000/02/11 22:08:18 metlov Exp $
 *
 * This file is part of the Java Expressions Library (JEL).
 *   For more information about JEL visit :
 *    http://galaxy.fzu.cz/JEL/
 *
 * (c) 1998 -- 2000 by Konstantin Metlov(metlov@fzu.cz);
 *
 * JEL is Distributed under the terms of GNU General Public License.
 *    This code comes with ABSOLUTELY NO WARRANTY.
 *  For license details see COPYING file in this directory.
 */

package gnu.jel;

import gnu.jel.debug.Debug;

public class OPload extends OP {
  protected Object what;
  
  public OPload(TypesStack typesStk, Class resType, Object what) {
    this.what=what;
    this.resID=TypesStack.primitiveID(resType);
    this.resType=resType;
    if (typesStk!=null) typesStk.pushID(resID,resType);
  };

  public OPload(TypesStack typesStk, Object what) {
    this.what=what;
    this.resID=TypesStack.primitiveID(what);

    if (Debug.enabled)
      Debug.assert((resID!=8) || (what instanceof String));
    
    if (resID!=8)
      this.resType=TypesStack.primitiveTypes[resID];
    else
      this.resType=what.getClass();


    if (typesStk!=null) typesStk.pushID(resID,resType);
  };
  
  protected void compile(ClassFile cf) {
    cf.codeLDC(what,resID);
  };

  public String toString() {
    if (resID==8) return "\""+what+"\"";
    return what.toString()+TypesStack.primitiveCodes[resID];
  };
};
