/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Instrumentation;
import android.graphics.Bitmap;
import android.os.Message;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import com.jayway.android.robotium.solo.WebElementCreator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RobotiumWebClient
extends WebChromeClient {
    WebElementCreator webElementCreator;
    private Instrumentation inst;
    private WebChromeClient robotiumWebClient;
    private WebChromeClient originalWebChromeClient = null;

    public RobotiumWebClient(Instrumentation inst, WebElementCreator webElementCreator) {
        this.inst = inst;
        this.webElementCreator = webElementCreator;
        this.robotiumWebClient = this;
    }

    public void enableJavascriptAndSetRobotiumWebClient(List<WebView> webViews, WebChromeClient originalWebChromeClient) {
        this.originalWebChromeClient = originalWebChromeClient;
        for (final WebView webView : webViews) {
            if (webView == null) continue;
            this.inst.runOnMainSync(new Runnable(){

                public void run() {
                    webView.getSettings().setJavaScriptEnabled(true);
                    webView.setWebChromeClient(RobotiumWebClient.this.robotiumWebClient);
                }
            });
        }
    }

    public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult r) {
        if (message != null && (message.contains(";,") || message.contains("robotium-finished"))) {
            if (message.equals("robotium-finished")) {
                this.webElementCreator.setFinished(true);
            } else {
                this.webElementCreator.createWebElementAndAddInList(message, view);
            }
            r.confirm();
            return true;
        }
        if (this.originalWebChromeClient != null) {
            return this.originalWebChromeClient.onJsPrompt(view, url, message, defaultValue, r);
        }
        return true;
    }

    public Bitmap getDefaultVideoPoster() {
        if (this.originalWebChromeClient != null) {
            return this.originalWebChromeClient.getDefaultVideoPoster();
        }
        return null;
    }

    public View getVideoLoadingProgressView() {
        if (this.originalWebChromeClient != null) {
            return this.originalWebChromeClient.getVideoLoadingProgressView();
        }
        return null;
    }

    public void getVisitedHistory(ValueCallback<String[]> callback) {
        if (this.originalWebChromeClient != null) {
            this.originalWebChromeClient.getVisitedHistory(callback);
        }
    }

    public void onCloseWindow(WebView window) {
        if (this.originalWebChromeClient != null) {
            this.originalWebChromeClient.onCloseWindow(window);
        }
    }

    public void onConsoleMessage(String message, int lineNumber, String sourceID) {
        if (this.originalWebChromeClient != null) {
            this.originalWebChromeClient.onConsoleMessage(message, lineNumber, sourceID);
        }
    }

    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        if (this.originalWebChromeClient != null) {
            return this.originalWebChromeClient.onConsoleMessage(consoleMessage);
        }
        return true;
    }

    public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
        if (this.originalWebChromeClient != null) {
            return this.originalWebChromeClient.onCreateWindow(view, isDialog, isUserGesture, resultMsg);
        }
        return true;
    }

    public void onExceededDatabaseQuota(String url, String databaseIdentifier, long quota, long estimatedDatabaseSize, long totalQuota, WebStorage.QuotaUpdater quotaUpdater) {
        if (this.originalWebChromeClient != null) {
            this.originalWebChromeClient.onExceededDatabaseQuota(url, databaseIdentifier, quota, estimatedDatabaseSize, totalQuota, quotaUpdater);
        }
    }

    public void onGeolocationPermissionsHidePrompt() {
        if (this.originalWebChromeClient != null) {
            this.originalWebChromeClient.onGeolocationPermissionsHidePrompt();
        }
    }

    public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
        if (this.originalWebChromeClient != null) {
            this.originalWebChromeClient.onGeolocationPermissionsShowPrompt(origin, callback);
        }
    }

    public void onHideCustomView() {
        if (this.originalWebChromeClient != null) {
            this.originalWebChromeClient.onHideCustomView();
        }
    }

    public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
        if (this.originalWebChromeClient != null) {
            return this.originalWebChromeClient.onJsAlert(view, url, message, result);
        }
        return true;
    }

    public boolean onJsBeforeUnload(WebView view, String url, String message, JsResult result) {
        if (this.originalWebChromeClient.onJsBeforeUnload(view, url, message, result)) {
            return this.originalWebChromeClient.onJsBeforeUnload(view, url, message, result);
        }
        return true;
    }

    public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
        if (this.originalWebChromeClient != null) {
            return this.originalWebChromeClient.onJsConfirm(view, url, message, result);
        }
        return true;
    }

    public boolean onJsTimeout() {
        if (this.originalWebChromeClient != null) {
            return this.originalWebChromeClient.onJsTimeout();
        }
        return true;
    }

    public void onProgressChanged(WebView view, int newProgress) {
        if (this.originalWebChromeClient != null) {
            this.originalWebChromeClient.onProgressChanged(view, newProgress);
        }
    }

    public void onReachedMaxAppCacheSize(long requiredStorage, long quota, WebStorage.QuotaUpdater quotaUpdater) {
        if (this.originalWebChromeClient != null) {
            this.originalWebChromeClient.onReachedMaxAppCacheSize(requiredStorage, quota, quotaUpdater);
        }
    }

    public void onReceivedIcon(WebView view, Bitmap icon) {
        if (this.originalWebChromeClient != null) {
            this.originalWebChromeClient.onReceivedIcon(view, icon);
        }
    }

    public void onReceivedTitle(WebView view, String title) {
        if (this.originalWebChromeClient != null) {
            this.originalWebChromeClient.onReceivedTitle(view, title);
        }
    }

    public void onReceivedTouchIconUrl(WebView view, String url, boolean precomposed) {
        if (this.originalWebChromeClient != null) {
            this.originalWebChromeClient.onReceivedTouchIconUrl(view, url, precomposed);
        }
    }

    public void onRequestFocus(WebView view) {
        if (this.originalWebChromeClient != null) {
            this.originalWebChromeClient.onRequestFocus(view);
        }
    }

    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        if (this.originalWebChromeClient != null) {
            this.originalWebChromeClient.onShowCustomView(view, callback);
        }
    }
}

