/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * This class gathers together all the test cases for the gr
 * directory into a single test suite.  As you create new test cases,
 * add them here.
 */

#include <qa_gr.h>
#include <qa_gr_fir.h>
#include <qa_gr_fir_CCF.h>
#include <qa_gr_fir_FFF.h>
#include <qa_gr_fir_FCC.h>
#include <qa_gr_fir_SCC.h>
#include <qa_gr_firdes.h>
#include <qa_dotprod.h>
#include <qa_gr_mmse_fir_interpolator.h>
#include <qa_gr_circular_file.h>

CppUnit::TestSuite *
qa_gr::suite ()
{
  CppUnit::TestSuite	*s = new CppUnit::TestSuite ("gr");

  qa_dotprod_register_tests (s);
  qa_gr_fir::register_tests (s);
  qa_gr_fir_FFF::register_tests (s);
  qa_gr_fir_FCC::register_tests (s);
  qa_gr_fir_SCC::register_tests (s);
  qa_gr_fir_CCF::register_tests (s);
  qa_gr_firdes::register_tests (s);
  qa_gr_mmse_fir_interpolator::register_tests (s);
  qa_gr_circular_file::register_tests (s);
  
  return s;
}
