/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2018 (c)
 * 
 *    file: module_f77.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    
#include "modules.h"

char *ext_f77[] = { "f", "for", "F", "FOR" };
char *keyword_f77[] = {
      //FORTRAN 77 4.0 language keywords
      "accept",
      "assignment",
      "assign",
      "automatic",
      "backspace",
      "block",
      "data",
      "byte",
      "call",
      "character",
      "close",
      "common",
      "complex",
      "continue",
      "decode",
      "dimension",
      "double",
      "do",
      "else",
      "encode",
      "endfile",
      "end",
      "entry",
      "if",
      "map",
      "structure",
      "union",
      "equivalence",
      "external",
      "format",
      "function",
      "go",
      "to",
      "then",
      "implicit",
      "include",
      "inquire",
      "integer",
      "intrinsic",
      "logical",
      "namelist",
      "open",
      "options",
      "parameter",
      "pause",
      "pointer",
      "pragma",
      "program",
      "print",
      "read",
      "real",
      "record",
      "return",
      "rewind",
      "save",
      "static",
      "stop",
      "structure",
      "subroutine",
      "type",
      "union",
      "virtual",
      "volatile",
      "write",
      "precision",
      "file",
      "abort",
      "access",
      "alarm",
      "bit",
      "and",
      "or",
      "setbit",
      "xor",
      "not",
      "rshift",
      "lshift",
      "bic",
      "bis",
      "chdir",
      "chmod",
      "date",
      "dtime",
      "etime",
      "exit",
      "f77_floatingpoint",
      "f77_ieee_environment",
      "fdate",
      "flush",
      "fork",
      "free",
      "fseek",
      "ftell",
      "getarg",
      "iargc",
      "getcwd",
      "fgetc",
      "getc",
      "getenv",
      "getfd",
      "getfile",
      "getlog",
      "getpid",
      "getuid",
      "getgid",
      "hostnm",
      "idate",
      "itime",
      "index",
      "rindex",
      "lnblnk",
      "len",
      "inmax",
      "ioinit",
      "kill",
      "libm_double",
      "libm_quadruple",
      "libm_single",
      "link",
      "symlnk",
      "loc",
      "long",
      "short",
      "longjmp",
      "isetjmp",
      "malloc",
      "mvbits",
      "perror",
      "gerror",
      "ierrno",
      "putc",
      "fputc",
      "qsort",
      "drand",
      "irand",
      "rand",
      "rename",
      "secnds",
      "sh",
      "signal",
      "sleep",
      "fstat",
      "lstat",
      "stat",
      "system",
      "ctime",
      "ltime",
      "gmtime",
      "time",
      "topen",
      "tclose",
      "twrite",
      "tread",
      "trewin",
      "tskipf",
      "tstate",
      "ttynam",
      "isatty",
      "unlink",
      "wait",
};

struct modulestruct module_f77 =
{
    .extsCount      = 4,
    .exts           = ext_f77,
    .keywordCount   = 160,
    .keywords       = keyword_f77,
    .mlCommentStart = NULL,
    .mlCommentEnd   = NULL,
    .slCommentStart = "C",      /* TODO: we should support all F77 comments, i.e. lines 
                                 *       starting with a, c, C, *, d, D, and ! are all
                                 *       comments.
                                 */
    .caseSensitive  = 1,
};
