/* -*- mode: c++ -*- 
*/
/* 

    GIFT, a flexible content based image retrieval system.
    Copyright (C) 1998, 1999, 2000 CUI, University of Geneva

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
/**
*
* CAccessor - a base class for everything
* accessing a GIFT database.
* at present this will be either an inverted file
* or a TrackingGIFT accessor.
* in the future this might be an SQL database or Monet??
*
*
*
* modification history:
*
* WM 19990804 created file
*
*
*
* compiler defines used:
*
*/
#ifndef _CACURL2FTS
#define _CACURL2FTS

#include <string>
#include "TID.h"
#include <iostream.h>
#include <fstream.h>
#include <map>
#include <hash_map>
#include "CAccessorImplementation.h"

class CXMLElement;//constructor

/** 
    This accessor is a base class for accessors which use an URL2FTS file to 
    implement the interface of the CAccessor base class.
 */
class CAcURL2FTS:public CAccessorImplementation{
 private:
  bool mWellConstructed;
 protected:
  /** map from the url of an image to the name of the feature file for this image */
  string_string_map mURLToFFN;
  /** map from the id of an image to the name of the feature file for this image */
  TID_string_map mIDToFFN;
  /** URL -> FeatureFileName */
  mutable ifstream mURLToFeatureFile;
  /** 
      Name of the file that contains pairs of  URL and the Feature file that belongs to the URL 
   */
  string mURLToFeatureFileName;
public:
  /** gives back the content of mURLToFeatureFileName */
  const string& getURLToFeatureFileName()const;

  /**
   *
   * Constructor: slurp in an url2fts file 
   * and fill the maps.
   * 
   */
  CAcURL2FTS(const CXMLElement& inContentElement);
  
  /**
   *
   * Is this accessor up and working?
   *
   */
  virtual operator bool()const;
  /**
   *
   * Give the number of elements stored in this accessor
   *
   */
  virtual int size()const;
  /**
   *
   * gives the feature file name which corresponds to a given URL
   * return value: pair of bool   (does the feature file exsist)
                           string (the feature file name)
   */
  pair<bool,string> URLToFFN(const string& inURL)const;
  /**
   *
   * gives the feature file name which corresponds to a given URL
   * return value: pair of bool   (does the feature file exsist)
                           string (the feature file name)
   */
  pair<bool,string> IDToFFN(TID inID)const;
};

#endif
