/*
 * Copyright (C) 2003-2015 FreeIPMI Core Team
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IPMI_FRU_DIMMSPD_RECORD_FORMAT_H
#define IPMI_FRU_DIMMSPD_RECORD_FORMAT_H

#ifdef __cplusplus
extern "C" {
#endif

#include <freeipmi/fiid/fiid.h>

/* 
 * see freeipmi/templates/ for template definitions 
 */

/* From "Annex K: Serial Presence Detect (SPD) for DDR3 SDRAM Modules"
 * and
 * "Annex L: Serial Presence Detect (SPD) for DDR4 SDRAM Modules"
 * 
 * Released by JEDEC
 */

#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_RESERVED                 0x00
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_STANDARD_FPM_DRAM        0x01 /* Fast Page Mode */
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_EDO                      0x02
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_PIPELINED_NIBBLE         0x03
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_SDRAM                    0x04
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_ROM                      0x05
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_DDR_SGRAM                0x06
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_DDR_SDRAM                0x07
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_DDR2_SDRAM               0x08
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_DDR2_SDRAM_FB_DIMM       0x09
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_DDR2_SDRAM_FB_DIMM_PROBE 0x0A
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_DDR3_SDRAM               0x0B
#define IPMI_FRU_DIMMSPD_DRAM_DEVICE_TYPE_DDR4_SDRAM               0x0C

/* From "Annex K: Serial Presence Detect (SPD) for DDR3 SDRAM Modules"
 * 
 * Released by JEDEC
 */

#define IPMI_FRU_DIMMSPD_SPD_BYTES_USED_UNDEFINED 0x0
#define IPMI_FRU_DIMMSPD_SPD_BYTES_USED_128       0x1
#define IPMI_FRU_DIMMSPD_SPD_BYTES_USED_176       0x2
#define IPMI_FRU_DIMMSPD_SPD_BYTES_USED_256       0x3

#define IPMI_FRU_DIMMSPD_SPD_BYTES_TOTAL_UNDEFINED 0x0
#define IPMI_FRU_DIMMSPD_SPD_BYTES_TOTAL_256       0x1

#define IPMI_FRU_DIMMSPD_CRC_COVERAGE_0_TO_125     0x0
#define IPMI_FRU_DIMMSPD_CRC_COVERAGE_0_TO_116     0x1

/* RDIMM - Registered Dual In-Line Memory Module 
 * LRDIMM - Load Reduction DIMM 
 * UDIMM - Unbuffered DIMM
 * SO-DIMM - Unbuffered 64-bit Small Outline DIMM 
 * Micro-DIMM - Micro DIMM 
 * Mini-RDIMM - Mini RDIMM
 * Mini-UDIMM - Mini UDIMM
 * Mini-CDIMM - Clocked 72-bit Mini DIMM
 * 72b-SO-UDIMM - Unbuffered 72-bit SO-DIMM
 * 72b-SO-RDIMM - Registered 72-bit SO-DIMM
 * 72b-SO-CDIMM - Clocked 72-bit SO-DIMM
 * 16b-SO-DIMM - Unbuffered 16-bit SO-DIMM
 * 32b-SO-DIMM - Unbuffered 32-bit SO-DIMM
 */
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_UNDEFINED    0x0
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_RDIMM        0x1
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_UDIMM        0x2
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_SO_DIMM      0x3
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_MICRO_DIMM   0x4
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_MINI_RDIMM   0x5
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_MINI_UDIMM   0x6
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_MINI_CDIMM   0x7
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_72B_SO_UDIMM 0x8
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_72B_SO_RDIMM 0x9
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_72B_SO_CDIMM 0xA 
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_LRDIMM       0xB
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_16B_SO_DIMM  0xC
#define IPMI_FRU_DIMMSPD_DRAM_MODULE_TYPE_32B_SO_DIMM  0xD

/* In megabits / gigabits */
#define IPMI_FRU_DIMMSPD_TOTAL_SDRAM_CAPACITY_256_MB 0x0
#define IPMI_FRU_DIMMSPD_TOTAL_SDRAM_CAPACITY_512_MB 0x1
#define IPMI_FRU_DIMMSPD_TOTAL_SDRAM_CAPACITY_1_GB   0x2
#define IPMI_FRU_DIMMSPD_TOTAL_SDRAM_CAPACITY_2_GB   0x3
#define IPMI_FRU_DIMMSPD_TOTAL_SDRAM_CAPACITY_4_GB   0x4
#define IPMI_FRU_DIMMSPD_TOTAL_SDRAM_CAPACITY_8_GB   0x5
#define IPMI_FRU_DIMMSPD_TOTAL_SDRAM_CAPACITY_16_GB  0x6

#define IPMI_FRU_DIMMSPD_BANK_ADDRESS_BITS_3 0x0 /* 8 banks */
#define IPMI_FRU_DIMMSPD_BANK_ADDRESS_BITS_4 0x1 /* 16 banks */
#define IPMI_FRU_DIMMSPD_BANK_ADDRESS_BITS_5 0x2 /* 32 banks */
#define IPMI_FRU_DIMMSPD_BANK_ADDRESS_BITS_6 0x3 /* 64 banks */

#define IPMI_FRU_DIMMSPD_COLUMN_ADDRESS_BITS_9  0x0
#define IPMI_FRU_DIMMSPD_COLUMN_ADDRESS_BITS_10 0x1
#define IPMI_FRU_DIMMSPD_COLUMN_ADDRESS_BITS_11 0x2
#define IPMI_FRU_DIMMSPD_COLUMN_ADDRESS_BITS_12 0x3

#define IPMI_FRU_DIMMSPD_ROW_ADDRESS_BITS_12    0x0
#define IPMI_FRU_DIMMSPD_ROW_ADDRESS_BITS_13    0x1
#define IPMI_FRU_DIMMSPD_ROW_ADDRESS_BITS_14    0x2
#define IPMI_FRU_DIMMSPD_ROW_ADDRESS_BITS_15    0x3
#define IPMI_FRU_DIMMSPD_ROW_ADDRESS_BITS_16    0x4

/* Yes, flags are opposite of normal logic for 1.5V */
#define IPMI_FRU_DIMMSPD_VOLTAGE_1_5_OPERABLE     0x0
#define IPMI_FRU_DIMMSPD_VOLTAGE_1_5_NOT_OPERABLE 0x1

#define IPMI_FRU_DIMMSPD_VOLTAGE_1_35_OPERABLE     0x1
#define IPMI_FRU_DIMMSPD_VOLTAGE_1_35_NOT_OPERABLE 0x0

#define IPMI_FRU_DIMMSPD_VOLTAGE_1_25_OPERABLE     0x1
#define IPMI_FRU_DIMMSPD_VOLTAGE_1_25_NOT_OPERABLE 0x0

#define IPMI_FRU_DIMMSPD_DEVICE_WIDTH_4_BITS  0x0
#define IPMI_FRU_DIMMSPD_DEVICE_WIDTH_8_BITS  0x1
#define IPMI_FRU_DIMMSPD_DEVICE_WIDTH_16_BITS 0x2
#define IPMI_FRU_DIMMSPD_DEVICE_WIDTH_32_BITS 0x3

#define IPMI_FRU_DIMMSPD_NUMBER_OF_RANKS_1    0x0
#define IPMI_FRU_DIMMSPD_NUMBER_OF_RANKS_2    0x1
#define IPMI_FRU_DIMMSPD_NUMBER_OF_RANKS_3    0x2
#define IPMI_FRU_DIMMSPD_NUMBER_OF_RANKS_4    0x3

#define IPMI_FRU_DIMMSPD_PRIMARY_BUS_WIDTH_8_BITS  0x0
#define IPMI_FRU_DIMMSPD_PRIMARY_BUS_WIDTH_16_BITS 0x1
#define IPMI_FRU_DIMMSPD_PRIMARY_BUS_WIDTH_32_BITS 0x2
#define IPMI_FRU_DIMMSPD_PRIMARY_BUS_WIDTH_64_BITS 0x3

#define IPMI_FRU_DIMMSPD_BUS_WIDTH_EXTENSION_0_BITS 0x0
#define IPMI_FRU_DIMMSPD_BUS_WIDTH_EXTENSION_8_BITS 0x1

#define IPMI_FRU_DIMMSPD_CAS_NOT_SUPPORTED 0x0
#define IPMI_FRU_DIMMSPD_CAS_SUPPORTED     0x1

#define IPMI_FRU_DIMMSPD_RZQ_6_NOT_SUPPORTED 0x0
#define IPMI_FRU_DIMMSPD_RZQ_6_SUPPORTED     0x1

#define IPMI_FRU_DIMMSPD_RZQ_7_NOT_SUPPORTED 0x0
#define IPMI_FRU_DIMMSPD_RZQ_7_SUPPORTED     0x1

#define IPMI_FRU_DIMMSPD_DLL_OFF_MODE_NOT_SUPPORTED 0x0
#define IPMI_FRU_DIMMSPD_DLL_OFF_MODE_SUPPORTED     0x1

#define IPMI_FRU_DIMMSPD_EXTENDED_TEMPERATURE_RANGE_NORMAL_RANGE              0x0 /* 0-85 C */
#define IPMI_FRU_DIMMSPD_EXTENDED_TEMPERATURE_RANGE_NORMAL_AND_EXTENDED_RANGE 0x1 /* 0-95 C */

#define IPMI_FRU_DIMMSPD_EXTENDED_TEMPERATURE_RANGE_REFRESH_RATE_2X 0x0
#define IPMI_FRU_DIMMSPD_EXTENDED_TEMPERATURE_RANGE_REFRESH_RATE_1X 0x1

#define IPMI_FRU_DIMMSPD_AUTO_SELF_REFRESH_NOT_SUPPORTED 0x0
#define IPMI_FRU_DIMMSPD_AUTO_SELF_REFRESH_SUPPORTED     0x1

#define IPMI_FRU_DIMMSPD_ON_DIE_THERMAL_SENSOR_READOUT_NOT_SUPPORTED 0x0
#define IPMI_FRU_DIMMSPD_ON_DIE_THERMAL_SENSOR_READOUT_SUPPORTED     0x1

#define IPMI_FRU_DIMMSPD_PARTIAL_ARRAY_SELF_REFRESH_NOT_SUPPORTED 0x0
#define IPMI_FRU_DIMMSPD_PARTIAL_ARRAY_SELF_REFRESH_SUPPORTED     0x1

#define IPMI_FRU_DIMMSPD_THERMAL_SENSOR_NOT_INCORPORATED 0x0
#define IPMI_FRU_DIMMSPD_THERMAL_SENSOR_INCORPORATED     0x1

#define IPMI_FRU_DIMMSPD_SIGNAL_LOADING_NOT_SPECIFIED     0x0
#define IPMI_FRU_DIMMSPD_SIGNAL_LOADING_MULTI_LOAD_STACK  0x1
#define IPMI_FRU_DIMMSPD_SIGNAL_LOADING_SINGLE_LOAD_STACK 0x2
#define IPMI_FRU_DIMMSPD_SIGNAL_LOADING_RESERVED          0x3

#define IPMI_FRU_DIMMSPD_DIE_COUNT_NOT_SPECIFIED     0x0
#define IPMI_FRU_DIMMSPD_DIE_COUNT_SINGLE_DIE        0x1
#define IPMI_FRU_DIMMSPD_DIE_COUNT_2_DIE             0x2
#define IPMI_FRU_DIMMSPD_DIE_COUNT_4_DIE             0x3
#define IPMI_FRU_DIMMSPD_DIE_COUNT_8_DIE             0x4

#define IPMI_FRU_DIMMSPD_SDRAM_DEVICE_TYPE_STANDARD_MONOLITHIC_DRAM_DEVICE 0x0
#define IPMI_FRU_DIMMSPD_SDRAM_DEVICE_TYPE_NON_STANDARD_DEVICE             0x1

/* From "Annex L: Serial Presence Detect (SPD) for DDR4 SDRAM Modules"
 * 
 * Released by JEDEC
 */

#define IPMI_FRU_DIMMSPD_DDR4_SPD_BYTES_USED_UNDEFINED 0x0
#define IPMI_FRU_DIMMSPD_DDR4_SPD_BYTES_USED_128       0x1
#define IPMI_FRU_DIMMSPD_DDR4_SPD_BYTES_USED_256       0x2
#define IPMI_FRU_DIMMSPD_DDR4_SPD_BYTES_USED_384       0x3
#define IPMI_FRU_DIMMSPD_DDR4_SPD_BYTES_USED_512       0x4

#define IPMI_FRU_DIMMSPD_DDR4_SPD_BYTES_TOTAL_UNDEFINED 0x0
#define IPMI_FRU_DIMMSPD_DDR4_SPD_BYTES_TOTAL_256       0x1
#define IPMI_FRU_DIMMSPD_DDR4_SPD_BYTES_TOTAL_512       0x2

/* RDIMM - Registered Dual In-Line Memory Module 
 * UDIMM - Unbuffered Dual In-Line Memory Module 
 * SO-DIMM - Unbuffered Small Outline Dual In-Line Memory Module, 64-bit data bus
 * LRDIMM - Load Reduced Dual In-Line Memory Module 
 * Mini-RDIMM - Mini RDIMM
 * Mini-UDIMM - Mini UDIMM
 * 72b-SO-RDIMM - Small Outline Registered DIMM, 72-bit data bus
 * 72b-SO-UDIMM - Small Outline Unbuffered DIMM, 72-bit data bus
 * 16b-SO-DIMM - Small Outline Unbuffered DIMM, 16-bit data bus
 * 32b-SO-DIMM - Small Outline Unbuffered DIMM, 32-bit data bus
 */
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_MODULE_TYPE_EXTENDED_MODULE        0x0
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_MODULE_TYPE_RDIMM                  0x1
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_MODULE_TYPE_UDIMM                  0x2
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_MODULE_TYPE_SO_DIMM                0x3
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_MODULE_TYPE_LR_DIMM                0x4
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_MODULE_TYPE_MINI_RDIMM             0x5
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_MODULE_TYPE_MINI_UDIMM             0x6
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_MODULE_TYPE_72B_SO_RDIMM           0x8
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_MODULE_TYPE_72B_SO_UDIMM           0x9
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_MODULE_TYPE_16B_SO_DIMM            0xC
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_MODULE_TYPE_32B_SO_DIMM            0xD
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_MODULE_TYPE_NO_BASE_MEMORY_PRESENT 0xF

/* In megabits / gigabits */
#define IPMI_FRU_DIMMSPD_DDR4_TOTAL_SDRAM_CAPACITY_256_MB 0x0
#define IPMI_FRU_DIMMSPD_DDR4_TOTAL_SDRAM_CAPACITY_512_MB 0x1
#define IPMI_FRU_DIMMSPD_DDR4_TOTAL_SDRAM_CAPACITY_1_GB   0x2
#define IPMI_FRU_DIMMSPD_DDR4_TOTAL_SDRAM_CAPACITY_2_GB   0x3
#define IPMI_FRU_DIMMSPD_DDR4_TOTAL_SDRAM_CAPACITY_4_GB   0x4
#define IPMI_FRU_DIMMSPD_DDR4_TOTAL_SDRAM_CAPACITY_8_GB   0x5
#define IPMI_FRU_DIMMSPD_DDR4_TOTAL_SDRAM_CAPACITY_16_GB  0x6
#define IPMI_FRU_DIMMSPD_DDR4_TOTAL_SDRAM_CAPACITY_32_GB  0x7

#define IPMI_FRU_DIMMSPD_DDR4_BANK_ADDRESS_BITS_2 0x0 /* 4 banks */
#define IPMI_FRU_DIMMSPD_DDR4_BANK_ADDRESS_BITS_3 0x1 /* 8 banks */

#define IPMI_FRU_DIMMSPD_DDR4_BANK_GROUP_BITS_0 0x0 /* no bank groups */
#define IPMI_FRU_DIMMSPD_DDR4_BANK_GROUP_BITS_1 0x1 /* 2 bank groups */
#define IPMI_FRU_DIMMSPD_DDR4_BANK_GROUP_BITS_2 0x2 /* 4 bank groups */

#define IPMI_FRU_DIMMSPD_DDR4_COLUMN_ADDRESS_BITS_9  0x0
#define IPMI_FRU_DIMMSPD_DDR4_COLUMN_ADDRESS_BITS_10 0x1
#define IPMI_FRU_DIMMSPD_DDR4_COLUMN_ADDRESS_BITS_11 0x2
#define IPMI_FRU_DIMMSPD_DDR4_COLUMN_ADDRESS_BITS_12 0x3

#define IPMI_FRU_DIMMSPD_DDR4_ROW_ADDRESS_BITS_12    0x0
#define IPMI_FRU_DIMMSPD_DDR4_ROW_ADDRESS_BITS_13    0x1
#define IPMI_FRU_DIMMSPD_DDR4_ROW_ADDRESS_BITS_14    0x2
#define IPMI_FRU_DIMMSPD_DDR4_ROW_ADDRESS_BITS_15    0x3
#define IPMI_FRU_DIMMSPD_DDR4_ROW_ADDRESS_BITS_16    0x4
#define IPMI_FRU_DIMMSPD_DDR4_ROW_ADDRESS_BITS_17    0x5
#define IPMI_FRU_DIMMSPD_DDR4_ROW_ADDRESS_BITS_18    0x6

#define IPMI_FRU_DIMMSPD_DDR4_SIGNAL_LOADING_NOT_SPECIFIED     0x00
#define IPMI_FRU_DIMMSPD_DDR4_SIGNAL_LOADING_MULTI_LOAD_STACK  0x01
#define IPMI_FRU_DIMMSPD_DDR4_SIGNAL_LOADING_SINGLE_LOAD_STACK 0x02

#define IPMI_FRU_DIMMSPD_DDR4_DIE_COUNT_SINGLE_DIE 0x0
#define IPMI_FRU_DIMMSPD_DDR4_DIE_COUNT_2_DIE      0x1
#define IPMI_FRU_DIMMSPD_DDR4_DIE_COUNT_3_DIE      0x2
#define IPMI_FRU_DIMMSPD_DDR4_DIE_COUNT_4_DIE      0x3
#define IPMI_FRU_DIMMSPD_DDR4_DIE_COUNT_5_DIE      0x4
#define IPMI_FRU_DIMMSPD_DDR4_DIE_COUNT_6_DIE      0x5
#define IPMI_FRU_DIMMSPD_DDR4_DIE_COUNT_7_DIE      0x6
#define IPMI_FRU_DIMMSPD_DDR4_DIE_COUNT_8_DIE      0x7

#define IPMI_FRU_DIMMSPD_DDR4_SDRAM_PACKAGE_TYPE_MONOLITHIC_DRAM_DEVICE     0x0
#define IPMI_FRU_DIMMSPD_DDR4_SDRAM_PACKAGE_TYPE_NON_MONOLITHIC_DRAM_DEVICE 0x1

#define IPMI_FRU_DIMMSPD_DDR4_SDRAM_MAXIMUM_ACTIVATE_COUNT_UNTESTED_MAC  0x0
#define IPMI_FRU_DIMMSPD_DDR4_SDRAM_MAXIMUM_ACTIVATE_COUNT_700_K         0x1
#define IPMI_FRU_DIMMSPD_DDR4_SDRAM_MAXIMUM_ACTIVATE_COUNT_600_K         0x2
#define IPMI_FRU_DIMMSPD_DDR4_SDRAM_MAXIMUM_ACTIVATE_COUNT_500_K         0x3
#define IPMI_FRU_DIMMSPD_DDR4_SDRAM_MAXIMUM_ACTIVATE_COUNT_400_K         0x4
#define IPMI_FRU_DIMMSPD_DDR4_SDRAM_MAXIMUM_ACTIVATE_COUNT_300_K         0x5
#define IPMI_FRU_DIMMSPD_DDR4_SDRAM_MAXIMUM_ACTIVATE_COUNT_200_K         0x6
#define IPMI_FRU_DIMMSPD_DDR4_SDRAM_MAXIMUM_ACTIVATE_COUNT_UNLIMITED_MAC 0x7

#define IPMI_FRU_DIMMSPD_DDR4_SDRAM_MAXIMUM_ACTIVATE_WINDOW_8192xtREFI 0x0
#define IPMI_FRU_DIMMSPD_DDR4_SDRAM_MAXIMUM_ACTIVATE_WINDOW_4096xtREFI 0x1
#define IPMI_FRU_DIMMSPD_DDR4_SDRAM_MAXIMUM_ACTIVATE_WINDOW_2048xtREFI 0x2

#define IPMI_FRU_DIMMSPD_DDR4_SDRAM_POST_PACKAGE_REPAIR_NOT_SUPPORTED                    0x0
#define IPMI_FRU_DIMMSPD_DDR4_SDRAM_POST_PACKAGE_REPAIR_SUPPORTED_ONE_ROW_PER_BANK_GROUP 0x1

#define IPMI_FRU_DIMMSPD_DDR4_VDD_1_2_NOT_OPERABLE 0x0
#define IPMI_FRU_DIMMSPD_DDR4_VDD_1_2_OPERABLE     0x1

#define IPMI_FRU_DIMMSPD_DDR4_VDD_1_2_NOT_ENDURANT 0x0
#define IPMI_FRU_DIMMSPD_DDR4_VDD_1_2_ENDURANT     0x1

#define IPMI_FRU_DIMMSPD_DDR4_VDD_TBD1_NOT_OPERABLE 0x0
#define IPMI_FRU_DIMMSPD_DDR4_VDD_TBD1_OPERABLE     0x1

#define IPMI_FRU_DIMMSPD_DDR4_VDD_TBD1_NOT_ENDURANT 0x0
#define IPMI_FRU_DIMMSPD_DDR4_VDD_TBD1_ENDURANT     0x1

#define IPMI_FRU_DIMMSPD_DDR4_VDD_TBD2_NOT_OPERABLE 0x0
#define IPMI_FRU_DIMMSPD_DDR4_VDD_TBD2_OPERABLE     0x1

#define IPMI_FRU_DIMMSPD_DDR4_VDD_TBD2_NOT_ENDURANT 0x0
#define IPMI_FRU_DIMMSPD_DDR4_VDD_TBD2_ENDURANT     0x1

#define IPMI_FRU_DIMMSPD_DDR4_DEVICE_WIDTH_4_BITS  0x0
#define IPMI_FRU_DIMMSPD_DDR4_DEVICE_WIDTH_8_BITS  0x1
#define IPMI_FRU_DIMMSPD_DDR4_DEVICE_WIDTH_16_BITS 0x2
#define IPMI_FRU_DIMMSPD_DDR4_DEVICE_WIDTH_32_BITS 0x3

#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_PACKAGE_RANKS_1 0x0
#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_PACKAGE_RANKS_2 0x1
#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_PACKAGE_RANKS_3 0x2
#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_PACKAGE_RANKS_4 0x3

#define IPMI_FRU_DIMMSPD_DDR4_PRIMARY_BUS_WIDTH_8_BITS  0x0
#define IPMI_FRU_DIMMSPD_DDR4_PRIMARY_BUS_WIDTH_16_BITS 0x1
#define IPMI_FRU_DIMMSPD_DDR4_PRIMARY_BUS_WIDTH_32_BITS 0x2
#define IPMI_FRU_DIMMSPD_DDR4_PRIMARY_BUS_WIDTH_64_BITS 0x3

#define IPMI_FRU_DIMMSPD_DDR4_BUS_WIDTH_EXTENSION_0_BITS 0x0
#define IPMI_FRU_DIMMSPD_DDR4_BUS_WIDTH_EXTENSION_8_BITS 0x1

#define IPMI_FRU_DIMMSPD_DDR4_THERMAL_SENSOR_NOT_INCORPORATED_ONTO_THIS_ASSEMBLY 0x0
#define IPMI_FRU_DIMMSPD_DDR4_THERMAL_SENSOR_INCORPORATED_ONTO_THIS_ASSEMBLY     0x1
 
#define IPMI_FRU_DIMMSPD_DDR4_CAS_NOT_SUPPORTED 0x0
#define IPMI_FRU_DIMMSPD_DDR4_CAS_SUPPORTED     0x1

/* For unbuffered memory modules & registered memory modules & load reduction memory modules */

/* in mm */
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_HEIGHT_LT_15 0x00
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_15_TO_16     0x01
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_16_TO_17     0x02
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_17_TO_18     0x03
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_18_TO_19     0x04
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_19_TO_20     0x05
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_20_TO_21     0x06
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_21_TO_22     0x07
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_22_TO_23     0x08
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_23_TO_24     0x09
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_24_TO_25     0x0A
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_25_TO_26     0x0B
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_26_TO_27     0x0C
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_27_TO_28     0x0D
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_28_TO_39     0x0E
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_29_TO_30     0x0F
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_30_TO_31     0x10
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_31_TO_32     0x11
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_32_TO_33     0x12
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_33_TO_34     0x13
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_34_TO_35     0x14
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_35_TO_36     0x15
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_36_TO_37     0x16
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_37_TO_38     0x17
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_38_TO_39     0x18
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_39_TO_40     0x19
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_40_TO_41     0x1A
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_41_TO_42     0x1B
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_42_TO_43     0x1C
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_43_TO_44     0x1D
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_44_TO_45     0x1E
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_NOMINAL_HEIGHT_MAX_45_GT_HEIGHT 0x1F

#define IPMI_FRU_DIMMSPD_DDR4_RAW_CARD_REVISIONS_0_TO_3 0x0
#define IPMI_FRU_DIMMSPD_DDR4_RAW_CARD_REVISIONS_4      0x1
#define IPMI_FRU_DIMMSPD_DDR4_RAW_CARD_REVISIONS_5      0x2
#define IPMI_FRU_DIMMSPD_DDR4_RAW_CARD_REVISIONS_6      0x3
#define IPMI_FRU_DIMMSPD_DDR4_RAW_CARD_REVISIONS_7      0x4
#define IPMI_FRU_DIMMSPD_DDR4_RAW_CARD_REVISIONS_8      0x5
#define IPMI_FRU_DIMMSPD_DDR4_RAW_CARD_REVISIONS_9      0x6
#define IPMI_FRU_DIMMSPD_DDR4_RAW_CARD_REVISIONS_10     0x7

/* in mm */
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_THICKNESS_LT_1  0x0
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_1_TO_2          0x1
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_2_TO_3          0x2
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_3_TO_4          0x3
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_4_TO_5          0x4
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_5_TO_6          0x5
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_6_TO_7          0x6
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_7_TO_8          0x7
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_8_TO_9          0x8
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_9_TO_10         0x9
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_10_TO_11        0xA
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_11_TO_12        0xB
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_12_TO_13        0xC
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_13_TO_14        0xD
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_14_TO_15        0xE
#define IPMI_FRU_DIMMSPD_DDR4_MODULE_MAXIMUM_THICKNESS_15_GT_THICKNESS 0xF

#define IPMI_FRU_DIMMSPD_DDR4_REFERENCE_RAW_CARD_EXTENSION_A_THROUGH_AL    0x0
#define IPMI_FRU_DIMMSPD_DDR4_REFERENCE_RAW_CARD_EXTENSION_AM_THROUGH_B    0x1

#define IPMI_FRU_DIMMSPD_DDR4_REFERENCE_RAW_CARD_REVISION_0 0x0
#define IPMI_FRU_DIMMSPD_DDR4_REFERENCE_RAW_CARD_REVISION_1 0x1 
#define IPMI_FRU_DIMMSPD_DDR4_REFERENCE_RAW_CARD_REVISION_2 0x2
#define IPMI_FRU_DIMMSPD_DDR4_REFERENCE_RAW_CARD_REVISION_3 0x3

#define IPMI_FRU_DIMMSPD_DDR4_REFERENCE_RAW_CARD_NO_JEDEC_REFERENCE_RAW_CARD_DESIGN_USED 0x1F

#define IPMI_FRU_DIMMSPD_DDR4_RANK_1_MAPPING_STANDARD 0x0
#define IPMI_FRU_DIMMSPD_DDR4_RANK_1_MAPPING_MIRRORED 0x1

/* For registered memory modules & load reduction memory modules */

#define IPMI_FRU_DIMMSPD_DDR4_HEAT_SPREADER_SOLUTION_NOT_INCORPORATED_INTO_THIS_ASSEMBLY 0x0
#define IPMI_FRU_DIMMSPD_DDR4_HEAT_SPREADER_SOLUTION_INCORPORATED_INTO_THIS_ASSEMBLY     0x1

#define IPMI_FRU_DIMMSPD_DDR4_DRIVE_STRENGTH_LIGHT_DRIVE    0x0
#define IPMI_FRU_DIMMSPD_DDR4_DRIVE_STRENGTH_MODERATE_DRIVE 0x1
#define IPMI_FRU_DIMMSPD_DDR4_DRIVE_STRENGTH_STRONG_DRIVE   0x2

/* For registered memory modules */

#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_REGISTERS_USED_ON_RDIMM_UNDEFINED   0x0
#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_REGISTERS_USED_ON_RDIMM_1_REGISTER  0x1
#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_REGISTERS_USED_ON_RDIMM_2_REGISTERS 0x2
#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_REGISTERS_USED_ON_RDIMM_4_REGISTERS 0x3

#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_ROWS_OF_DRAMS_ON_RDIMM_UNDEFINED 0x0
#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_ROWS_OF_DRAMS_ON_RDIMM_1_ROW     0x1
#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_ROWS_OF_DRAMS_ON_RDIMM_2_ROWS    0x2
#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_ROWS_OF_DRAMS_ON_RDIMM_4_ROWS    0x3

#define IPMI_FRU_DIMMSPD_DDR4_HEAT_SPREADER_THERMAL_CHARACTERISTICS_UNDEFINED 0x0

/* For load reduction memory modules */

#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_REGISTERS_USED_ON_LRDIMM_UNDEFINED   0x0
#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_REGISTERS_USED_ON_LRDIMM_1_REGISTER  0x1

#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_ROWS_OF_DRAMS_ON_LRDIMM_UNDEFINED 0x0
#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_ROWS_OF_DRAMS_ON_LRDIMM_1_ROW     0x1
#define IPMI_FRU_DIMMSPD_DDR4_NUMBER_OF_ROWS_OF_DRAMS_ON_LRDIMM_2_ROWS    0x2

#define IPMI_FRU_DIMMSPD_DDR4_DRAM_INTERFACE_MDQ_READ_TERMINATION_STRENGTH_DISABLED 0x0
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_INTERFACE_MDQ_READ_TERMINATION_STRENGTH_RZQ4     0x1
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_INTERFACE_MDQ_READ_TERMINATION_STRENGTH_RZQ2     0x2
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_INTERFACE_MDQ_READ_TERMINATION_STRENGTH_RZQ6     0x3
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_INTERFACE_MDQ_READ_TERMINATION_STRENGTH_RZQ      0x4
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_INTERFACE_MDQ_READ_TERMINATION_STRENGTH_RZQ5     0x5
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_INTERFACE_MDQ_READ_TERMINATION_STRENGTH_RZQ3     0x6
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_INTERFACE_MDQ_READ_TERMINATION_STRENGTH_RZQ7     0x7

#define IPMI_FRU_DIMMSPD_DDR4_DRAM_INTERFACE_MDQ_DRIVE_STRENGTH_RZQ6 0x0
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_INTERFACE_MDQ_DRIVE_STRENGTH_RZQ7 0x1
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_INTERFACE_MDQ_DRIVE_STRENGTH_RZQ5 0x2
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_INTERFACE_MDQ_DRIVE_STRENGTH_RZQ4 0x5 /* not a typo, jumps to 5 */

#define IPMI_FRU_DIMMSPD_DDR4_DRAM_DRIVE_STRENGTH_RZQ7 0x0
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_DRIVE_STRENGTH_RZQ5 0x1

#define IPMI_FRU_DIMMSPD_DDR4_DRAM_ODT_STRENGTH_DYNAMIC_ODT_OFF 0x0
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_ODT_STRENGTH_RZQ2            0x1
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_ODT_STRENGTH_RZQ             0x2
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_ODT_STRENGTH_HI_IMPEDANCE    0x3
#define IPMI_FRU_DIMMSPD_DDR4_DRAM_ODT_STRENGTH_RZQ3            0x4

extern fiid_template_t tmpl_fru_dimm_spd_ddr_header;
extern fiid_template_t tmpl_fru_dimm_spd_ddr3_record;
extern fiid_template_t tmpl_fru_dimm_spd_ddr4_record;
extern fiid_template_t tmpl_fru_dimm_spd_ddr4_module_specific_unbuffered_memory_module;
extern fiid_template_t tmpl_fru_dimm_spd_ddr4_module_specific_registered_memory_module;
extern fiid_template_t tmpl_fru_dimm_spd_ddr4_module_specific_load_reduction_memory_module;

#ifdef __cplusplus
}
#endif

#endif /* IPMI_FRU_DIMMSPD_RECORD_FORMAT_H */
