# $Id: 558a2bc785507dbed9143ba166de1ecc09e7633b $

function add(num, code) {
    bushu[bushu_num] = num
    if (key[num]) {
	if (0+key[num] > 0) {
	    vkey[vkey_num++] = 0;
	    vkey[vkey_num] = key[num]
       	    key[num] = -vkey_num;
	    vkey_num++;
	}
	vkey[vkey_num++] = numstrokes;
    } else
	key[num] = numstrokes
    charcode[bushu_num] = code
    numkeys[numstrokes]++
    bushu_num++
}

BEGIN {
	FS="( +)|[ \t-]"
	first = 10000
	last = 0
	bushu_num = 1
}

/^#.*$/ {next}
       
/\=[0-9][0-9]*/ {
	numstrokes = substr($1, 2)
	if (0+numstrokes > 0+maxstrokes) 
		maxstrokes = numstrokes;
	next
}

/[0-9][0-9]*[ \t][ \t]*[0-9][0-9]*/ {
        add($1, $2)
	if (first > $1)
		first = $1
	if (last < $1)
		last = $1
	next
}

/[0-9][0-9]*/ {
        add($1, bushu_num)
	if (first > $1)
		first = $1
	if (last < $1)
		last = $1
	next
}

/^[ \t]*$/ {next}

{
	printf "%d: ignored\n", NR > "/dev/stderr"
}

END {
    print "/* This file is automatically generated."
    print " * To change it edit file `bushu.dat' and run"
    print " * awk -f bushu.awk bushu.dat > bushu.c"
    print " */"	
    print
    print "#ifdef HAVE_CONFIG_H"
    print "# include <config.h>"
    print "#endif"
    print "#include <stdlib.h>"
    print "#include <stdio.h>"
    print "#include <dict.h>"
    print "#include <dico.h>"
    print "#include <bushu.h>"
    print
    printf "int bushu_last = %d;\n", last
    printf "int max_bushu_strokes = %d;\n", maxstrokes
    printf "int bushu_cnt = %d;\n", bushu_num
    print

    print "/* Bushu numbers. Indexed with the internal bushu number */"
    printf "int bushu_num[] = {"
    col = 10
    for (i = 0; i < bushu_num; i++) {
	if (col == 10) {
	    printf "\n\t"
	    col = 0
	}
	printf "%3d, ", bushu[i] 
	col++
    }
    printf "\n};\n"


    print "/* Number of strokes for each bushu */"
    print "/* NOTE: i. This table is indexed with the real bushu number */"
    print "/*       ii.Negative entry means the radical has several */"
    print "/*          forms/stroke counts. The absolute value of the entry */"
    print "/*          serves as index to bushu_var_strokes table */"
    printf "int bushu_stroke[] = {"
    col = 10
    for (i = 0; i <= last; i++) {
	if (col == 10) {
	    printf "\n\t"
	    col = 0
	}
	printf "%3d, ", key[i] 
	col++
    }
    printf "\n};\n"

    print "/* Number of strokes for v bushu */"
    printf "int bushu_var_stroke[] = {"
    col = 10
    for (i = 0; i <= vkey_num; i++) {
	if (col == 10) {
	    printf "\n\t"
	    col = 0
	}
	printf "%3d, ", vkey[i] 
	col++
    }
    printf "\n};\n"

# Compute startpoints
    num = 1
    for (i = 1; i <= 0+maxstrokes; i++) {
	start[i] = num
	num += numkeys[i]
    }
    start[i] = num

    print "/* bushu_index[i] contains the internal index of the first bushu"
    print " * that has i strokes. "
    print " */"
    printf "int bushu_index[] = {"
    col = 10
    for (i = 0; i <= maxstrokes+1; i++) {
	if (col == 10) {
	    printf "\n\t"
	    col = 0
	}
	printf "%3d, ", start[i] 
	col++
    }
    print "\n};\n"

    print "/* Number of radicals that have given number of strokes"
    print " */"
    printf "int bushu_count[] = {"
    col = 10
    maxcount = 0
    for (i = 0; i <= maxstrokes+0; i++) {
	if (col == 10) {
	    printf "\n\t"
	    col = 0
	}
	printf "%3d, ", start[i+1] - start[i]
	if (start[i+1] - start[i] > maxcount)
	    maxcount = start[i+1] - start[i];
	col++
    }
    print "\n};\n"
    printf "int max_bushu_count = %d;\n\n", maxcount
	
    printf "/* Strings representing each radical (for use with bushu.pcf) */\n"
    printf "char bushu_string[%d][2] = {", bushu_num+1
    col = 5	
    for (i = 0; i <= bushu_num; i++) {
	if (col == 5) {
	    printf "\n\t"
	    col = 0
	}
	printf "{ %4d, 0 },", 0+charcode[i]
	col++
    }
    printf "\n};\n"
}

