// Copyright (C) 2001 Kai Germaschewski
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

// TODO
// switching w/o threads
// common cmsg_put w/mutex
// stop play/tone thread gracefully

#include "driver.h"
#include <capi20.h>
#include <cerrno>

// FIXME

#include <linux/types.h>

#ifdef	CCXX_NAMESPACES
using namespace std;
namespace ost {
#endif

struct capi_profile {
	__u16 ncontroller;	/* number of installed controller */
	__u16 nbchannel;	/* number of B-Channels */
	__u32 goptions;		/* global options */
	__u32 support1;		/* B1 protocols support */
	__u32 support2;		/* B2 protocols support */
	__u32 support3;		/* B3 protocols support */
	__u32 reserved[6];	/* reserved */
	__u32 manu[5];		/* manufacturer specific information */
};

CapiConfig::CapiConfig() :
Keydata("/bayonne/capi20")
{
	static Keydata::Define defkeys[] = {
		{"buffersize", "128"},
		{NULL, NULL}
	};		

	load(defkeys);
}

CapiDriver::CapiDriver() :
Driver(), CapiConfig(), Thread(keythreads.priService())
{
	static Script::Define keywords[] = {
		{"join", (Method)&CapiTrunk::scrJoin, &ScriptCommand::chkHasArgs},
		{"wait", (Method)&CapiTrunk::scrWait, &ScriptCommand::chkHasArgs},
		{NULL, NULL, NULL}};

	struct capi_profile cprofile,cprofile1;
	int err;
//	int b_chan;
	int count;
		
	status = CapiTrunk::status;
	running = false;
	appl_id = 0;
	msg_id = 1;

	memset(status, ' ', sizeof(CapiTrunk::status));
	err=capi20_isinstalled();
	if (err != CapiNoError) {
		slog(Slog::levelError) << "CAPI: capi not installed - " 
				 << strerror(err) << endl;
		return;
	}

	capi20_get_profile(0, (CAPI_MESSAGE)&cprofile);
	contr_count = cprofile.ncontroller;
	if (!contr_count) {
		slog(Slog::levelError) << "CAPI: no controllers" << endl;
		return;
	}

	for (count = 0; count < contr_count; count++) {
  	    capi20_get_profile(count+1, (CAPI_MESSAGE)&cprofile1);
	    b_chan[count]= cprofile1.nbchannel;
	    port_count+=b_chan[count];
	    slog(Slog::levelError) << "CAPI: Controler: " << count+1 << endl;
	    slog(Slog::levelError) << "CAPI: B channels: " << b_chan[count] << endl;

	}    



	err = capi20_register(port_count, 7, getBufferSize(), &appl_id);
	if (err != CapiNoError) {
		slog(Slog::levelError) << "CAPI: could not register - " 
				 << strerror(err) << endl;
		return;
	}

	// dsp devices
	ports = new CapiTrunk *[port_count];
	groups = new TrunkGroup *[port_count];
	memset(ports, 0, sizeof(CapiTrunk *) * port_count);
	memset(groups, 0, sizeof(TrunkGroup *) * port_count);

	ScriptCommand::load(keywords);

	pipe(evbuf);
	int opts = fcntl(evbuf[1], F_GETFL);
	fcntl(evbuf[1], F_SETFL, opts | O_NONBLOCK);

	slog(Slog::levelError) << "CAPI: driver loaded. " << contr_count 
			<< " controllers; "<< port_count << " trunks - endof CapiDriver::CapiDriver"
			<< endl;
}

CapiDriver::~CapiDriver()
{
	slog(Slog::levelDebug) << "CAPI: " << __FUNCTION__ << endl;

	stop();

	if(ports)
		delete[] ports;

	if(groups)
		delete[] groups;

	if (appl_id)
		capi20_release(appl_id);

	::close(evbuf[0]);
	::close(evbuf[1]);
}

int CapiDriver::start()
{
	slog(Slog::levelDebug) << "CAPI: " << __FUNCTION__ << endl;


	int count = 0;
	int totalcount=0;
	unsigned err;
	_cmsg cmsg;

	if(active) {
		slog(Slog::levelError) << "CAPI: driver already started" << endl;
		return 0;
	}

	slog(Slog::levelInfo) << "CAPI: driver starting..." << endl;

	active = true;

	for (int contr = 1; contr <= contr_count; contr++) {
	    for (count = 0; count < b_chan[contr-1] ; count++) {
		ports[totalcount] = new CapiTrunk(contr, count);
		totalcount++;
		
	    }	
//		ports[count++] = new CapiTrunk(contr, 1);
//		ports[count++] = new CapiTrunk(contr, 2);
	slog(Slog::levelError) << "CAPI: driver started " << count <<" channels total on controller " << contr << endl;

		err = LISTEN_REQ (&cmsg, appl_id, msg_id++,
				  contr,   // Controller
				  0,       // InfoMask
				  0x10011, // CIPMask
				  0,       // CIPMask2
				  (unsigned char *)"",  // CallingPartyNumber
				  (unsigned char *)""); // CallingPartySubaddress
		if (err != CapiNoError) {
			slog(Slog::levelError) << "CAPI: LISTEN_REQ err = "
					 << err << endl;
		}
		err = capi20_waitformessage(appl_id, NULL);
		if (err != CapiNoError) {
			slog(Slog::levelError) << "CAPI: LISTEN_REQ err = "
					 << err << endl;
		}
		err = capi_get_cmsg(&cmsg, appl_id);
		if (err != CapiNoError) {
			slog(Slog::levelError) << "CAPI: LISTEN_CONF err = "
					 << err << endl;
		}
		if (cmsg.Command != CAPI_LISTEN || 
		    cmsg.Subcommand !=  CAPI_CONF ||
		    cmsg.Info != 0) {
			slog(Slog::levelError) << "CAPI: LISTEN_CONF Info = "
					 << cmsg.Info << endl;
		}
	}

	slog(Slog::levelError) << "CAPI: before thread is started..." << endl;


	if(!running)
		Thread::start();

	return totalcount;
}

void CapiDriver::stop()
{
	slog(Slog::levelDebug) << "CAPI: " << __FUNCTION__ << endl;

	int id;

	if (!active)
		return;

	if (running) {
		slog(Slog::levelDebug) << "terminate()" << endl;
		terminate();
	}
	slog(Slog::levelInfo) << "CAPI: driver stopping..." << endl;

	for(id = 0; id < port_count; ++id) {
		if(ports[id])
			delete (ports[id]);
	}
	memset(ports, 0, sizeof(CapiTrunk *) * port_count);
	active = false;

}

int CapiDriver::getTrunkCount()
{
  //	slog(SLOG_DEBUG) << "CAPI: " << __FUNCTION__ << endl;

	return port_count;
}

Trunk *CapiDriver::getTrunkPort(int id)
{
// 	slog(SLOG_DEBUG) << "CAPI: " << __FUNCTION__ << " "
// 			 << id << endl;

	if (id < 0 || id >= port_count)
		return NULL;

	if (!ports)
		return NULL;

	return ports[id];
}

void CapiDriver::handleCapiMessage()
{
//	slog(Slog::levelError) << "CAPI: " << __FUNCTION__ << endl;

	unsigned err;
	unsigned contr;
	unsigned controffs=0;
	unsigned controffsmax=0;
	_cmsg cmsg;

	err = capi_get_cmsg(&cmsg, appl_id);
//	slog(Slog::levelError) << capi20_cmsg2str(&cmsg) << endl;
	
	if (err != CapiNoError) {
		slog(Slog::levelError) << "CAPI: capi20_get_cmsg err = "
				 << err << endl;
		return;
	}
	contr = cmsg.adr.adrController & 0xff;
	if (contr < 1 || contr > contr_count) {
		slog(Slog::levelError) << capi20_cmsg2str(&cmsg) << endl;
		return;
	}

//	slog(Slog::levelError) << "HANDLE: CONTROLLER:" << contr << endl;

	for (int xcount=0; xcount<contr-1; xcount++) {
//	slog(Slog::levelError) << "HANDLE: b_chan:" << b_chan[xcount] << endl;
	controffs+=b_chan[xcount];

	}
	controffsmax=controffs+b_chan[contr-1];
//slog(Slog::levelError) << "HANDLE: CONTROLLEROFFS:" << controffs << " MAx: " << controffsmax << endl;

	if (IS_DATA_B3_IND(&cmsg) || 
	    IS_DATA_B3_CONF(&cmsg) ||
	    IS_CONNECT_ACTIVE_IND(&cmsg) ||
	    IS_DISCONNECT_CONF(&cmsg) || 
	    IS_DISCONNECT_IND(&cmsg) || 
	    IS_CONNECT_B3_CONF(&cmsg) ||
	    IS_CONNECT_B3_IND(&cmsg) ||
	    IS_CONNECT_B3_ACTIVE_IND(&cmsg) ||
	    IS_DISCONNECT_B3_IND(&cmsg) ||
	    IS_FACILITY_CONF(&cmsg) ||
	    IS_FACILITY_IND(&cmsg) ||
	    IS_ALERT_CONF(&cmsg)) {
//	    slog(Slog::levelDebug) << "CAPI: CMSG received " << endl
//				 << capi20_cmsg2str(&cmsg) << endl;

//		for (int i = 2 * (contr-1); i <= 2 * (contr-1) + 1; i++) {
		for (int i = controffs; i < controffsmax; i++) {
			CapiTrunk *trunk = ports[i];
			TrunkEvent event;

			if (trunk->plci != (cmsg.adr.adrPLCI & 0xffff))
				continue;

			trunk->recvCapiMsg(&cmsg);
			return;
		}
		slog(Slog::levelError) << "CAPI: PLCI not found " << endl
				 << capi20_cmsg2str(&cmsg) << endl;
		return;
	}
	if (IS_CONNECT_CONF(&cmsg)) {
//		for (int i = 2 * (contr-1); i <= 2 * (contr-1) + 1; i++) {
		for (int i = controffs; i < controffsmax; i++) {

			CapiTrunk *trunk = ports[i];

			if (!trunk->plci) {
				if (trunk->recvCapiMsg(&cmsg))
					return;
			}
		}
		slog(Slog::levelError) << "CAPI: PLCI not found " << endl
				 << capi20_cmsg2str(&cmsg) << endl;
		return;
	}
        if (IS_CONNECT_IND(&cmsg)) {
//                for (int i = 2 * (contr-1); i <= 2 * (contr-1) + 1; i++) {
		for (int i = controffs; i < controffsmax; i++) {

                        CapiTrunk *trunk = ports[i];

                        if (!trunk->plci) {
                                if (trunk->recvCapiMsg(&cmsg))
                                        return;
                        }
                }
                capi20_cmsg_answer(&cmsg);
                cmsg.Reject = 2; // reject
                err = capi20_put_cmsg(&cmsg);
                if (err != CapiNoError) {
                        slog(Slog::levelError) << "CAPI: capi20_put_cmsg err = "
                                         << err << endl;
                }
                return;
        }
	slog(Slog::levelError) << "CAPI: driver not handled " << endl 
			 << capi20_cmsg2str(&cmsg) << endl;
}

void CapiDriver::run()
{
//	slog(Slog::levelDebug) << "CAPI RUN CALLED: " << __FUNCTION__ << endl;

	int cnt = 0;
	timeout_t timer, expires;
	CapiTrunk *trunk;
	TrunkEvent event;
	struct timeval tv;
	fd_set rfds;
	char dummy;
	int retval;
	int zahl = 0;
	
	if (!appl_id)
		return;

	setCancel(cancelImmediate);
	for (;;) {
	slog(Slog::levelDebug) << "CAPI ALIVE " << endl;

		timer = ~0;
		for (int i = 0; i < port_count; i++) {
			trunk = ports[i];

		retry:
			expires = trunk->getTimer();
			if(expires > 0 && expires < timer) timer = expires;

			if (!expires) {
				debug->debugService(trunk, "expires");
				event.id = TRUNK_TIMER_EXPIRED;
				trunk->postEvent(&event);
//				goto retry;
			}

//  	       slog(Slog::levelError) << "CAPI RUN PORT_COUNT: " << zahl++ << endl;


		}
//  	       slog(Slog::levelError) << "CAPI RUN TIMER: " << timer << endl;

		if (timer > 10000) {
			tv.tv_sec = 10; // FIXME
			tv.tv_usec = 0;
		} else {
			tv.tv_sec = timer / 1000;
			tv.tv_usec = (timer % 1000) * 1000;
		}

		FD_ZERO(&rfds);
		FD_SET(capi20_fileno(appl_id), &rfds);
		FD_SET(evbuf[0], &rfds);
		retval = select(MAX(capi20_fileno(appl_id), evbuf[0])+1, 
				&rfds, NULL, NULL, &tv);
		if (retval < 0) {
			slog(Slog::levelError) << "select returned "
					 << strerror(errno) << endl;
			break;
		}
		if (FD_ISSET(capi20_fileno(appl_id), &rfds))
			handleCapiMessage();
		if (FD_ISSET(evbuf[0], &rfds))
			read(evbuf[0], &dummy, 1);
	}
}

CapiDriver capiivr;

#ifdef	CCXX_NAMESPACES
};
#endif
