/*
 *  Ball And Paddle
 *
 *  Copyright (C) 2007 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#include "levelsetmenu.h"
#include "mainmenu.h"
#include "game.h"

LevelSetMenu
  LevelSetMenu::m_instance;

void
LevelSetMenu::init ()
{
  string location = IMAGEPATH + "/menuback.png";
  SDL_Surface *temp = IMG_Load (location.c_str ());
  if (temp != NULL)
    imgBackground = SDL_DisplayFormat (temp);
  SDL_FreeSurface (temp);
  cursor = 0;
#ifndef SINGLEDIR
  location = string (PREFIX) + "/share/ballandpaddle/levelsets";
#endif
#ifdef SINGLEDIR
  location = string (PREFIX) + "/levelsets";
#endif
  ifstream file;
  file.open (location.c_str (), ifstream::in);
  int levelsetCount;
  file >> levelsetCount;
  // buffer to consume rest of line
  char buffer[256];
  // consume the rest of the line with the number of skins
  file.getline (buffer, 256);
  for (int i = 0; i < levelsetCount; i++)
    {
      char strLevelsetName[256];
      file.getline (strLevelsetName, 256);
      levelsetNames.push_back (string (strLevelsetName));
      char strLevelsetFilename[256];
      file.getline (strLevelsetFilename, 256);
      levelsetFilenames.push_back (string (strLevelsetFilename));
    }
  file.close ();
  for (int i = 0; i < levelsetNames.size (); i++)
    menuItems.push_back (levelsetNames[i]);
  menuItems.push_back ("Back");
  spacing = 40;
}

void
LevelSetMenu::cleanup ()
{
  while (!menuItems.empty ())
    menuItems.pop_back ();
  while (!levelsetNames.empty ())
    levelsetNames.pop_back ();
  while (!levelsetFilenames.empty ())
    levelsetFilenames.pop_back ();
  SDL_FreeSurface (imgBackground);
}

void
LevelSetMenu::pause ()
{
}

void
LevelSetMenu::resume ()
{
}

void
LevelSetMenu::draw (GameStateManager * gameStateManager)
{
  SDL_BlitSurface (imgBackground, NULL, gameStateManager->screen, NULL);
  SDL_Rect r = { 160, 230, 320, 230 };
  SDL_FillRect (gameStateManager->screen, &r,
		SDL_MapRGB (gameStateManager->screen->format, 64, 64, 64));
  for (int i = 0; i < menuItems.size (); i++)
    {
      if (cursor == i)
	gameStateManager->drawStringCentered (FONT_ACTIVE, menuItems[i], 320,
					      250 + i * spacing);
      else
	gameStateManager->drawStringCentered (FONT_INACTIVE, menuItems[i],
					      320, 250 + i * spacing);
    }
}

void
LevelSetMenu::handleEvents (GameStateManager * gameStateManager)
{

  int mouseX;
  int mouseY;

  SDL_Event event;

  while (SDL_PollEvent (&event))
    {
      switch (event.type)
	{
	case SDL_QUIT:
	  gameStateManager->quit ();
	  break;
	case SDL_KEYDOWN:
	  switch (event.key.keysym.sym)
	    {
	    case SDLK_RETURN:
	      handleItem (gameStateManager);
	      break;
	    case SDLK_UP:
	      cursor--;
	      if (cursor < 0)
		cursor = menuItems.size () - 1;
	      break;
	    case SDLK_DOWN:
	      cursor++;
	      if (cursor >= menuItems.size ())
		cursor = 0;
	      break;
	    }
	  break;
	case SDL_MOUSEMOTION:
	  mouseX = event.motion.x;
	  mouseY = event.motion.y;

	  int x1;
	  int x2;
	  for (int i = 0; i < menuItems.size (); i++)
	    {
	      x1 =
		320 -
		menuItems[i].length () *
		gameStateManager->getCharWidth (FONT_INACTIVE) / 2;
	      x2 =
		x1 +
		menuItems[i].length () *
		gameStateManager->getCharWidth (FONT_INACTIVE);
	      if (mouseX >= x1 && mouseX <= x2 && mouseY >= 250 + i * spacing
		  && mouseY <=
		  250 + gameStateManager->getCharHeight (FONT_INACTIVE) +
		  i * spacing)
		cursor = i;
	    }
	  break;
	case SDL_MOUSEBUTTONDOWN:
	  handleItem (gameStateManager);
	  break;
	}
    }

}

void
LevelSetMenu::update (GameStateManager * gameStateManager)
{
}

void
LevelSetMenu::handleItem (GameStateManager * gameStateManager)
{
  for (int i = 0; i < levelsetNames.size (); i++)
    {
      if (cursor == i)
	{
	  if (gameStateManager->isFullscreen ())
	    SDL_ShowCursor (false);
	  gameStateManager->setLevelset (levelsetNames[i],
					 levelsetFilenames[i]);
	  gameStateManager->setStartLevel (1);
	  gameStateManager->loadSounds ();
	  Game::instance ()->loadImages (gameStateManager);
	  gameStateManager->changeState (Game::instance ());
	}
    }
  if (cursor == menuItems.size () - 1)
    gameStateManager->changeState (MainMenu::instance ());
}
