/* gbuild.h: various functions needed at runtime for widget trees
 * file created 1997/08/18 05:49:10 by gubi (static)
 * RCS_ID("$Id$")
 * RCS_KEY(Template, "$Template: gbuildh.tpl 1997 gubi $")
*/


#ifndef		__gbuild_h__
#define		__gbuild_h__

#ifdef		__cplusplus
  extern "C"	{
#endif		/*__cplusplus*/

#include	<gtk.h>

#ifdef	D_MALLOG
  #include	"dmallog.h"
#endif	/*D_MALLOG*/



/* --- defines --- */


/* we depend on this!
*/
#undef	NULL
#define	NULL	((void*)(0))


/* the GB_CAST macro is used to cast a pointer into any
 * gb_*_S pointer.
*/
#define	GB_CAST(type,struct_p)	((gb_##type##_S*)(struct_p))
#define	GB_wCAST(type,struct_p)	((gb_wdat_##type##_S*)(struct_p))


/* macros to check types
*/
#define	GB_TYPE_IS_STRUCT(type)						\
			( ((type)>GB_STRUCT_NONE) &&			\
			  ((type)<GB_STRUCT_LAST) )
#define	GB_TYPE_IS_LINKAGE(type)					\
			( ((type)>=_GB_LINKAGE_FIRST) &&		\
			  ((type)<=_GB_LINKAGE_LAST) )
#define	GB_TYPE_IS_ABSTRACT(type)					\
			( ((type)==GB_STRUCT_NONE) ||			\
			  ((type)==GB_OBJECT) ||			\
			  ((type)==GB_WIDGET_BASE) ||			\
			  ((type)==GB_WIDGET_MISC) ||			\
			  ((type)==GB_WIDGET_CONTAINER) ||		\
			  ((type)==GB_WIDGET_BIN) ||			\
			  ((type)==GB_STRUCT_LAST) )
#define	GB_TYPE_IS_OBJDAT(type)						\
			( ((type)>=_GB_GTKOBJECT_FIRST) &&		\
			  ((type)<=_GB_GTKOBJECT_LAST) )
#define	GB_TYPE_IS_WIDDAT(type)						\
			( ((type)>=_GB_GTKWIDGET_FIRST) &&		\
			  ((type)<=_GB_GTKWIDGET_LAST) )
#define	GB_TYPE_IS_WIDDAT_MISC(type)					\
			( ((type)>=_GB_GTKMISC_FIRST) &&		\
			  ((type)<=_GB_GTKMISC_LAST) )
#define	GB_TYPE_IS_WIDDAT_CONTAINER(type)				\
			( ((type)>=_GB_GTKCONTAINER_FIRST) &&		\
			  ((type)<=_GB_GTKCONTAINER_LAST) )
#define	GB_TYPE_IS_WIDDAT_BIN(type)					\
			( ((type)>=_GB_GTKBIN_FIRST) &&			\
			  ((type)<=_GB_GTKBIN_LAST) )
#define	GB_TYPE_IS_WIDDAT_WINDOW(type)					\
			( ((type)>=_GB_GTKWINDOW_FIRST) &&		\
			  ((type)<=_GB_GTKWINDOW_LAST) )


/* macros to check structure pointer for types
*/
#define	GB_IS_STRUCT(struct_p)						\
			( (struct_p) &&					\
			  GB_TYPE_IS_STRUCT((struct_p)->type) )
#define	GB_IS_LINKAGE(struct_p)						\
			( (struct_p) &&					\
			  GB_TYPE_IS_LINKAGE((struct_p)->type) )
#define	GB_IS_OBJDAT(struct_p)						\
			( (struct_p) &&					\
			  GB_TYPE_IS_OBJDAT((struct_p)->type) )
#define	GB_IS_WIDDAT(struct_p)						\
			( (struct_p) &&					\
			  GB_TYPE_IS_WIDDAT((struct_p)->type) )
#define	GB_IS_WIDDAT_MISC(struct_p)					\
			( (struct_p) &&					\
			  GB_TYPE_IS_WIDDAT_MISC((struct_p)->type) )
#define	GB_IS_WIDDAT_CONTAINER(struct_p)				\
			( (struct_p) &&					\
			  GB_TYPE_IS_WIDDAT_CONTAINER((struct_p)->type) )
#define	GB_IS_WIDDAT_BIN(struct_p)					\
			( (struct_p) &&					\
			  GB_TYPE_IS_WIDDAT_BIN((struct_p)->type) )
#define	GB_IS_WIDDAT_WINDOW(struct_p)					\
			( (struct_p) &&					\
			  GB_TYPE_IS_WIDDAT_WINDOW((struct_p)->type) )


/* the GB_NULLIFY_ON_DESTROY macro is used to add a
 * signal handler to <widget> for nullification of the
 * pointer <pointer_adress> points to. the signal handler is
 * invoked, when <widget> gets destroyed.
*/
#define	GB_NULLIFY_ON_DESTROY(widget,pointer_adress)			\
	gtk_signal_connect(GTK_OBJECT((widget)),			\
			   "destroy",					\
			   GTK_SIGNAL_FUNC(gb_sigh_pointer_nullify),	\
			   (pointer_adress))


/* the GB_GFREE_ON_DESTROY macro is used to add a
 * signal handler to a GtkWidget that frees the space <pointer>
 * points to. the signal handler is invoked, when <widget>
 * gets destroyed.
*/
#define	GB_GFREE_ON_DESTROY(widget,pointer)				\
	gtk_signal_connect_object(GTK_OBJECT((widget)),			\
				  "destroy",				\
				  GTK_SIGNAL_FUNC(gb_free_pointer),	\
				  (GtkObject*)(pointer))


/* macro for memory allocation and copy
*/
#define	memdup(source, size)	memcpy(g_malloc(size), source, size)



/* --- typedefs --- */

/* the gb_struct_type_E enum typedef specifies the various structure types.
*/
typedef	enum {
	GB_STRUCT_NONE,

#define	_GB_LINKAGE_FIRST		GB_LINKAGE_BOX
	GB_LINKAGE_BOX,
	GB_LINKAGE_TABLE,
	GB_LINKAGE_NOTEBOOK,
#define	_GB_LINKAGE_LAST		GB_LINKAGE_NOTEBOOK

#define	_GB_GTKOBJECT_FIRST		GB_OBJECT
	GB_OBJECT,
#define	_GB_GTKWIDGET_FIRST		GB_WIDGET_BASE
	GB_WIDGET_BASE,
	GB_WIDGET_DRAWING_AREA,
	GB_WIDGET_ENTRY,
	GB_WIDGET_PROGRESS_BAR,
	GB_WIDGET_RULER,
	GB_WIDGET_H_RULER,
	GB_WIDGET_V_RULER,
	GB_WIDGET_SCALE,
	GB_WIDGET_H_SCALE,
	GB_WIDGET_V_SCALE,
	GB_WIDGET_SEPARATOR,
	GB_WIDGET_H_SEPARATOR,
	GB_WIDGET_V_SEPARATOR,
#define	_GB_GTKMISC_FIRST		GB_WIDGET_MISC
	GB_WIDGET_MISC,
	GB_WIDGET_ARROW,
	GB_WIDGET_LABEL,
#define	_GB_GTKMISC_LAST		GB_WIDGET_LABEL
#define	_GB_GTKCONTAINER_FIRST		GB_WIDGET_CONTAINER
	GB_WIDGET_CONTAINER,
	GB_WIDGET_BUTTON,
	GB_WIDGET_TOGGLE_BUTTON,
	GB_WIDGET_CHECK_BUTTON,
	GB_WIDGET_RADIO_BUTTON,
	GB_WIDGET_LIST,
	GB_WIDGET_SCROLLED_WINDOW,
	GB_WIDGET_TABLE,
	GB_WIDGET_NOTEBOOK,
	GB_WIDGET_BOX,
	GB_WIDGET_H_BOX,
	GB_WIDGET_V_BOX,
#define	_GB_GTKBIN_FIRST		GB_WIDGET_BIN
	GB_WIDGET_BIN,
	GB_WIDGET_FRAME,
	GB_WIDGET_ITEM,
	GB_WIDGET_LIST_ITEM,
#define	_GB_GTKWINDOW_FIRST		GB_WIDGET_WINDOW
	GB_WIDGET_WINDOW,
	GB_WIDGET_FILE_SELECTION,
#define	_GB_GTKWINDOW_LAST		GB_WIDGET_FILE_SELECTION
#define	_GB_GTKBIN_LAST			_GB_GTKWINDOW_LAST
#define	_GB_GTKCONTAINER_LAST		_GB_GTKBIN_LAST
#define	_GB_GTKWIDGET_LAST		_GB_GTKCONTAINER_LAST
#define	_GB_GTKOBJECT_LAST		_GB_GTKWIDGET_LAST
	GB_STRUCT_LAST
} gb_struct_type_E;


/* the gb_connect_options_E enum typedef specifies the
 * signal connection options.
*/
typedef	enum {
	GB_CONNECT		= 1 << 0,
	GB_CONNECT_OBJECT	= 1 << 1,
	GB_CONNECT_AFTER	= 1 << 2,
	GB_CONNECT_DATA_POINTER	= 1 << 3	/* FIXME: remove */
} gb_connect_options_E;


/* the gb_reference_E enum typedef specifies the way
 * a pointer is dereferenced.
*/
typedef	enum {
	GB_DEREF_NONE,
	GB_DEREF_POINTER,
	GB_DEREF_GB_SELF_WIDGET,
	GB_DEREF_GB_PARENT_WIDGET,
	GB_DEREF_GB_LAST_PARENT_WIDGET,
	GB_DEREF_GB_WIDGET,
	GB_DEREF_GB_CLONE_WIDGET
} gb_reference_E;


/* the gb_resize_policy_E enum typedef specifies the resizing behaviour
 * of a GtkWindow.
*/
typedef	enum {
	GB_ALLOW_SHRINK	= ( 1 << 0 ),
	GB_ALLOW_GROW	= ( 1 << 1 ),
	GB_AUTO_SHRINK	= ( 1 << 2 )
} gb_resize_policy_E;


/* the gb_page_linkage_E enum typedef specifies how a page of a notebook
 * is linked to the parent.
*/
typedef	enum {
	GB_PAGE_INSERT,
	GB_PAGE_APPEND,
	GB_PAGE_PREPEND
} gb_page_linkage_E;


/* typedefs to introduce auxillary structures.
*/
typedef	union	gb_handler_data_U		gb_handler_data_U;
typedef	struct	gb_keyed_data_S			gb_keyed_data_S;
typedef	struct	gb_signal_handler_S		gb_signal_handler_S;


/* typedefs for descendants of gb_any_S.
*/
typedef	struct	gb_any_S			gb_any_S;
typedef	struct	gb_linkage_box_S		gb_linkage_box_S;
typedef	struct	gb_linkage_table_S		gb_linkage_table_S;
typedef	struct	gb_linkage_notebook_S		gb_linkage_notebook_S;
typedef	struct	gb_objdat_S			gb_objdat_S;
typedef	struct	gb_wdat_base_S			 gb_wdat_base_S;
typedef	struct	gb_wdat_drawing_area_S		  gb_wdat_drawing_area_S;
typedef	struct	gb_wdat_entry_S			  gb_wdat_entry_S;
typedef	struct	gb_wdat_progress_bar_S		  gb_wdat_progress_bar_S;
typedef	struct	gb_wdat_ruler_S			  gb_wdat_ruler_S;
typedef		gb_wdat_ruler_S			   gb_wdat_h_ruler_S;
typedef		gb_wdat_ruler_S			   gb_wdat_v_ruler_S;
typedef	struct	gb_wdat_scale_S			  gb_wdat_scale_S;
typedef		gb_wdat_scale_S			   gb_wdat_h_scale_S;
typedef		gb_wdat_scale_S			   gb_wdat_v_scale_S;
typedef		gb_wdat_base_S			  gb_wdat_separator_S;
typedef		gb_wdat_separator_S		   gb_wdat_h_separator_S;
typedef		gb_wdat_separator_S		   gb_wdat_v_separator_S;
typedef	struct	gb_wdat_misc_S			  gb_wdat_misc_S;
typedef	struct	gb_wdat_arrow_S			   gb_wdat_arrow_S;
typedef	struct	gb_wdat_label_S			   gb_wdat_label_S;
typedef	struct	gb_wdat_container_S		  gb_wdat_container_S;
typedef	struct	gb_wdat_box_S			   gb_wdat_box_S;
typedef		gb_wdat_box_S			    gb_wdat_h_box_S;
typedef		gb_wdat_box_S			    gb_wdat_v_box_S;
typedef	struct	gb_wdat_button_S		   gb_wdat_button_S;
typedef	struct	gb_wdat_toggle_button_S		   gb_wdat_check_button_S;
typedef	struct	gb_wdat_radio_button_S		   gb_wdat_radio_button_S;
typedef	struct	gb_wdat_toggle_button_S		   gb_wdat_toggle_button_S;
typedef	struct	gb_wdat_list_S			   gb_wdat_list_S;
typedef	struct	gb_wdat_scrolled_window_S	   gb_wdat_scrolled_window_S;
typedef	struct	gb_wdat_table_S			   gb_wdat_table_S;
typedef	struct	gb_wdat_notebook_S		   gb_wdat_notebook_S;
typedef	struct	gb_wdat_bin_S			   gb_wdat_bin_S;
typedef		gb_wdat_bin_S			    gb_wdat_item_S;
typedef	struct	gb_wdat_list_item_S		     gb_wdat_list_item_S;
typedef	struct	gb_wdat_frame_S			    gb_wdat_frame_S;
typedef	struct	gb_wdat_window_S		    gb_wdat_window_S;
typedef	struct	gb_wdat_file_selection_S	     gb_wdat_file_selection_S;



/* --- auxillary structures --- */

/* the gb_handler_data_U contains the data of a gb_signal_handler_S
*/
union	gb_handler_data_U {
	gpointer		func_data;
	gpointer		*func_data_p;
	GtkObject		*slot_object
				/* here, NULL indicates
				 * the connecting object
				 * itself
				*/;
	GtkObject		**slot_object_p;
};


/* the gb_keyed_data_S holds the user pointers that will be associated
 * to GtkObjects through key.
*/
struct	gb_keyed_data_S {
	const gchar		*key			/* NULL-terminator */;
	gpointer		data;
};


/* the gb_signal_handler_S holds the user function pointers that get
 * connected to GtkObjects, as well as their type definitions.
*/
struct	gb_signal_handler_S {
	guint			connect_options;
	gint			handler_id;
	gchar			*signal_name;
	GtkSignalFunc		handler_func		/* NULL-terminator */;
	gb_handler_data_U	data;
};


/* --- gb_any_S structure and derrived types --- */

/* the gb_any_S acts as base type for all structures.
*/
struct	gb_any_S {
	gb_struct_type_E	type;
};


/* the gb_linkage_box_S holds information about the
 * linkage of a boxs child.
*/
struct	gb_linkage_box_S {
	gb_struct_type_E	type;
	GtkPackType		pack_type;
	GtkAttachOptions	attach;
	gint			padding;
};


/* the gb_linkage_table_S holds information about the
 * attachment of a tables child.
*/
struct	gb_linkage_table_S {
	gb_struct_type_E	type;
	GtkAttachOptions	xoptions;
	GtkAttachOptions	yoptions;
	gint			xpadding;
	gint			ypadding;
	gint			left_attach;
	gint			right_attach;
	gint			top_attach;
	gint			bottom_attach;
};


/* the gb_linkage_notebook_S holds information about the
 * linkage of a notebooks child.
*/
struct	gb_linkage_notebook_S {
	gb_struct_type_E	type;
	gb_page_linkage_E	page_linkage;
	gint			position;
	gchar			*tab_label;
	gfloat			tab_xalign;
	gfloat			tab_yalign;
	guint			tab_xpad;
	guint			tab_ypad;
};


/* --- widget data structures --- */


/* macros holding multiply used base fields
*/
#define	GB_OBJDAT_S_FIELDS(_struct_type,_object_type,_object_typename)	\
	gb_struct_type_E	type					\
				/* structure type			\
				*/;					\
	_object_type		*_object_typename			\
				/* the object returned from gtk_*_new()	\
				*/;					\
	gboolean		gfree_on_destroy			\
				/* connect gb_sigh_structure_free()	\
				 * or gb_sigh_pointer_nullify()?	\
				*/;					\
	_struct_type		*clone					\
				/* self reference used on cloning	\
				*/;					\
	_struct_type		*next					\
				/* link to next structure		\
				*/;					\
	gb_keyed_data_S		*keyed_data_stack			\
				/* pointer to NULL-terminated		\
				 * key-data array.			\
				*/;					\
	gb_signal_handler_S	*signal_handler_stack			\
				/* pointer to NULL-terminated		\
				 * signal handler array.		\
				*/;					\
	gpointer		user_data				\
				/* initialy NULL			\
				*/

#define	GB_WDAT_BASE_S_FIELDS		\
	GB_OBJDAT_S_FIELDS(gb_wdat_base_S,GtkWidget,widget);		\
	gb_wdat_base_S		*parent					\
				/* pointer to parent			\
				*/;					\
	gb_any_S		*linkage				\
				/* pointer to any gb_linkage_*_S type	\
				 * or NULL to indicate linkage by	\
				 * gtk_container_add().			\
				*/;					\
	gchar			*widget_name;				\
	guint32			flags					\
				/* used bits:				\
				 * GTK_SENSITIVE			\
				 * GTK_CAN_DEFAULT			\
				 * GTK_CAN_FOCUS			\
				 * GTK_HAS_DEFAULT			\
				 * GTK_HAS_FOCUS			\
				*/;					\
	gint			x, y					\
				/* widgets position			\
				*/;					\
	guint			width, height				\
				/* widgets size				\
				*/

#define	GB_WDAT_MISC_S_FIELDS		\
	GB_WDAT_BASE_S_FIELDS;						\
	gfloat			xalign;					\
	gfloat			yalign;					\
	guint			xpad;					\
	guint			ypad

#define	GB_WDAT_CONTAINER_S_FIELDS	\
	GB_WDAT_BASE_S_FIELDS;						\
	gint			border_width				\
				/* space separating container		\
				 * from children			\
				*/

#define	GB_WDAT_BIN_S_FIELDS		\
	GB_WDAT_CONTAINER_S_FIELDS


/* the base object data structure includes the basic fields,
 * that are common to all auccessors of gb_object_S.
*/
struct	gb_objdat_S {
	GB_OBJDAT_S_FIELDS(gb_objdat_S,GtkObject,object);
};


/* the base widget data structure includes the basic fields,
 * that are common to all gb_wdat_*_S.
*/
struct	gb_wdat_base_S {
	GB_WDAT_BASE_S_FIELDS;
};

struct	gb_wdat_drawing_area_S {
	GB_WDAT_BASE_S_FIELDS;
	gint			req_width;
	gint			req_height;
};

struct	gb_wdat_entry_S {
	GB_WDAT_BASE_S_FIELDS;
	gchar			*init_text;
};

struct	gb_wdat_progress_bar_S {
	GB_WDAT_BASE_S_FIELDS;
	gfloat			init_percentage;
};

struct	gb_wdat_ruler_S {
	GB_WDAT_BASE_S_FIELDS;
	GtkMetricType	metric;
	gfloat		lower;
	gfloat		upper;
	gfloat		position;
	gfloat		max_size;
};

struct	gb_wdat_scale_S {
	GB_WDAT_BASE_S_FIELDS;
	gboolean		draw_value;
	GtkPositionType		value_pos;
	GtkUpdateType		update_policy;
	gint			digits;
	GtkAdjustment		*adjustment;
};

struct	gb_wdat_misc_S {
	GB_WDAT_MISC_S_FIELDS;
};

struct	gb_wdat_arrow_S {
	GB_WDAT_MISC_S_FIELDS;
	GtkArrowType		arrow_type;
	GtkShadowType		shadow_type;
};

struct	gb_wdat_label_S {
	GB_WDAT_MISC_S_FIELDS;
	gchar			*label;
};

struct	gb_wdat_container_S {
	GB_WDAT_CONTAINER_S_FIELDS;
};

struct	gb_wdat_box_S {
	GB_WDAT_CONTAINER_S_FIELDS;
	gboolean		homogeneous;
	gint			spacing;
};

struct	gb_wdat_button_S {
	GB_WDAT_CONTAINER_S_FIELDS;
	gchar			*label
				/* NULL indicates no label
				*/;
};

struct	gb_wdat_toggle_button_S {
	GB_WDAT_CONTAINER_S_FIELDS;
	gchar			*label
				/* NULL indicates no label
				*/;
	gboolean		init_state;
	gboolean		draw_indicator;
};

struct	gb_wdat_radio_button_S {
	GB_WDAT_CONTAINER_S_FIELDS;
	gchar			*label
				/* NULL indicates no label
				*/;
	gboolean		init_state;
	gboolean		draw_indicator;
	gb_wdat_radio_button_S	*grouping;
};

struct	gb_wdat_list_S {
	GB_WDAT_CONTAINER_S_FIELDS;
	GtkSelectionMode	select_mode;
};

struct	gb_wdat_scrolled_window_S {
	GB_WDAT_CONTAINER_S_FIELDS;
	GtkPolicyType		hscrollbar_policy;
	GtkPolicyType		vscrollbar_policy;
};

struct	gb_wdat_table_S {
	GB_WDAT_CONTAINER_S_FIELDS;
	gboolean		homogeneous;
	gint			rows;
	gint			columns;
	gint			row_spacing;
	gint			col_spacing;
};

struct	gb_wdat_notebook_S {
	GB_WDAT_CONTAINER_S_FIELDS;
	gint			initial_page;
	GtkPositionType		tab_position;
	gboolean		show_tabs;
	gboolean		show_border;
};

struct	gb_wdat_bin_S {
	GB_WDAT_BIN_S_FIELDS;
};

struct	gb_wdat_frame_S {
	GB_WDAT_BIN_S_FIELDS;
	gchar			*label
				/* NULL indicates no label
				*/;
	GtkShadowType		shadow_type;
	gfloat			xalign;
	gfloat			yalign;
};

struct	gb_wdat_list_item_S {
	GB_WDAT_BIN_S_FIELDS;
	gchar			*label
				/* NULL indicates no label
				*/;
};

struct	gb_wdat_window_S {
	GB_WDAT_BIN_S_FIELDS;
	gchar			*title;
	GtkWindowType		win_type;
	GtkWindowPosition	win_position;
	guint			resize_policy;
	gboolean		auto_build
				/* automatic creation in main() ?
				*/;
};

struct	gb_wdat_file_selection_S {
	GB_WDAT_BIN_S_FIELDS;
	gchar			*title;
	GtkWindowType		win_type;
	GtkWindowPosition	win_position;
	guint			resize_policy;
	gboolean		auto_build;
	gchar			*filename;
};



/* --- global variables --- */

/* gb_number_of_windows reflects the number of window configuration,
 * and therefore the number of widget trees.
*/
extern	guint			gb_number_of_windows;


/* the gb_window_list[] array contains pointers to all window configurations.
 * it's maximum index is identified by gb_number_of_windows-1.
*/
extern	gb_wdat_window_S	*gb_window_list[];



/* --- prototypes --- */


/* the gb_struct_size() function returns sizeof(gb_*_S) for a
 * gb_*_S specified by <struct_type>.
 * some gb_struct_type_E are not valid to actualy form a real
 * structure, those values will be considered a fatal error.
 * returns:
 * sizeof() value for a specific gb_*_S.
*/
guint	gb_struct_size		(const	gb_struct_type_E	struct_type
				 /* numeric value indicating the
				  * gb_*_S type.
				 */);


/* the gb_window_build() function builds the whole window's widget tree.
 * this is done by first creating the window from *WinDat and later on
 * the creation of all the corresponding GtkWidget's according to the
 * gb_*_wdat_S linked to *WinDat by the next pointer.
*/
void	gb_window_build		(gb_wdat_window_S	*WinDat
				 /* *valid* pointer to an existing
				  * gb_wdat_window_S
				 */);


/* the gb_window_connect() function just calls the gb_widget_connect()
 * function for all gb_*_wdat_S of it's tree similar to gb_window_build().
*/
void	gb_window_connect	(gb_wdat_window_S	*WinDat);


/* the gb_widget_create() function creates a new GtkWidget and adds it to
 * it's parent GtkWidget, specified through the parent pointer of the
 * gb_*_wdat_S, by taking apropriate actions according to the linkage
 * specification.
 * this function also connects a signal handler to the "destroy" signal
 * of the GtkWidget.
 * this signal handler either resets the widget pointer of the gb_*_wdat_S
 * to NULL or frees the memory of the gb_*_wdat_S and it's auxilary
 * structures.
 * what action is performed by the signal handler depends on the value
 * of the free_clone field within the gb_*_wdat_S.
*/
void	gb_widget_create	(gb_wdat_base_S		*WidDat
				 /* *valid* pointer to an existing
				  * gb_wdat_base_S or derrived type
				 */);


/* the gb_widget_data_set() function applies the base settings of
 * a widget like width, height etc. as well as it's specific data,
 * e.g. the title of a window.
*/
void	gb_widget_data_set	(gb_wdat_base_S		*WidDat);


/* the gb_object_connect() function connects the handlers of ObjDat,
 * specified through the auxilary handler_stack.
*/
void	gb_object_connect	(gb_objdat_S		*ObjDat);


/* the gb_widget_connect() function is just a wrapper around
 * gb_object_connect(), provided as a convenience.
*/
void	gb_widget_connect	(gb_wdat_base_S		*WidDat);


/* the gb_widget_wdat_clone() function clones the subtree of the specified
 * gb_*_wdat_S.
 * the clone pointer of the gb_*_wdat_S in the source tree contain
 * pointer to their related clones afterwards.
 * the free_clone field of the cloned gb_*_wdat_S is set to TRUE.
*/
void	gb_widget_data_clone	(gb_wdat_base_S		*WidDat);


/* the gb_sigh_pointer_nullify() function is a signal handler that
 * nullifies the pointer located at pointer_adress.
*/
void	gb_sigh_pointer_nullify	(GtkWidget	*pointer
				 /* unused pointer
				 */,
				 gpointer	*pointer_adress
				 /* *valid* pointer to a
				  * pointer.
				 */);


/* the gb_sigh_structure_free() function is a signal handler, normaly
 * used to free a cloned gb_wdat_base_S and it's auxilary structures.
*/
void	gb_sigh_structure_free	(GtkWidget	*pointer,
				 gb_any_S	*Struct
				 /* *valid* pointer to a gb_any_S
				  * or derived type.
				 */);


/* the gb_free_pointer() function is used by by the
 * GB_GFREE_ON_DESTROY() macro to free mem.
 * this is just a function wrapper around the g_free() macro.
*/
void	gb_free_pointer		(gpointer	*mem);


/* the gb_sigh_widget_dump() function just dumps known data about
 * a GtkWidget to stdout.
*/
void	gb_sigh_widget_dump	(GtkWidget	*widget
				 /* *valid* pointer to a GtkWidget
				 */);






#ifdef		__cplusplus
  }
#endif		/*__cplusplus*/

#endif		/*__gbuild_h__*/
